/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.maven.plugins.android.standalonemojos;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.FileListingService;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.SyncException;
import com.android.ddmlib.SyncService;
import com.android.ddmlib.TimeoutException;
import com.jayway.maven.plugins.android.AbstractAndroidMojo;
import com.jayway.maven.plugins.android.DeviceCallback;
import com.jayway.maven.plugins.android.common.LogSyncProgressMonitor;
import com.jayway.maven.plugins.android.configuration.Pull;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

public class PullMojo
extends AbstractAndroidMojo {
    private Pull pull;
    private String pullSource;
    private String pullDestination;
    private String parsedSource;
    private String parsedDestination;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.parseConfiguration();
        this.doWithDevices(new DeviceCallback(){

            @Override
            public void doWithDevice(IDevice device) throws MojoExecutionException {
                String message = "";
                try {
                    SyncService syncService = device.getSyncService();
                    FileListingService fileListingService = device.getFileListingService();
                    FileListingService.FileEntry sourceFileEntry = PullMojo.this.getFileEntry(PullMojo.this.parsedSource, fileListingService);
                    if (sourceFileEntry.isDirectory()) {
                        File destinationDir = new File(PullMojo.this.parsedDestination);
                        if (!destinationDir.exists()) {
                            PullMojo.this.getLog().info((CharSequence)("Creating destination directory " + destinationDir));
                            destinationDir.mkdirs();
                            destinationDir.mkdir();
                        }
                        String destinationDirPath = destinationDir.getAbsolutePath();
                        FileListingService.FileEntry[] fileEntries = PullMojo.this.parsedDestination.endsWith(File.separator) ? new FileListingService.FileEntry[]{sourceFileEntry} : fileListingService.getChildren(sourceFileEntry, true, null);
                        message = "Pull of " + PullMojo.this.parsedSource + " to " + destinationDirPath + " from ";
                        syncService.pull(fileEntries, destinationDirPath, (SyncService.ISyncProgressMonitor)new LogSyncProgressMonitor(PullMojo.this.getLog()));
                    } else {
                        File parentDir = new File(FilenameUtils.getFullPath((String)PullMojo.this.parsedDestination));
                        if (!parentDir.exists()) {
                            PullMojo.this.getLog().info((CharSequence)("Creating destination directory " + parentDir));
                            parentDir.mkdirs();
                        }
                        String destinationFileName = PullMojo.this.parsedDestination.endsWith(File.separator) ? FilenameUtils.getName((String)PullMojo.this.parsedSource) : FilenameUtils.getName((String)PullMojo.this.parsedDestination);
                        File destinationFile = new File(parentDir, destinationFileName);
                        String destionationFilePath = destinationFile.getAbsolutePath();
                        message = "Pull of " + PullMojo.this.parsedSource + " to " + destionationFilePath + " from ";
                        syncService.pullFile(sourceFileEntry, destionationFilePath, (SyncService.ISyncProgressMonitor)new LogSyncProgressMonitor(PullMojo.this.getLog()));
                    }
                    PullMojo.this.getLog().info((CharSequence)(message + device.getSerialNumber() + " (avdName=" + device.getAvdName() + ") successful."));
                }
                catch (SyncException e) {
                    throw new MojoExecutionException(message + device.getSerialNumber() + " (avdName=" + device.getAvdName() + ") failed.", (Exception)((Object)e));
                }
                catch (IOException e) {
                    throw new MojoExecutionException(message + device.getSerialNumber() + " (avdName=" + device.getAvdName() + ") failed.", (Exception)e);
                }
                catch (TimeoutException e) {
                    throw new MojoExecutionException(message + device.getSerialNumber() + " (avdName=" + device.getAvdName() + ") failed.", (Exception)((Object)e));
                }
                catch (AdbCommandRejectedException e) {
                    throw new MojoExecutionException(message + device.getSerialNumber() + " (avdName=" + device.getAvdName() + ") failed.", (Exception)((Object)e));
                }
            }
        });
    }

    private void parseConfiguration() {
        if (this.pull != null) {
            this.parsedSource = StringUtils.isNotEmpty((String)this.pull.getSource()) ? this.pull.getSource() : this.pullSource;
            this.parsedDestination = StringUtils.isNotEmpty((String)this.pull.getDestination()) ? this.pull.getDestination() : this.pullDestination;
        } else {
            this.parsedSource = this.pullSource;
            this.parsedDestination = this.pullDestination;
        }
    }

    private FileListingService.FileEntry getFileEntry(String filePath, FileListingService fileListingService) throws MojoExecutionException {
        if (filePath.startsWith("/sdcard")) {
            filePath = "/mnt" + filePath;
        }
        String[] destinationPathSegments = StringUtils.split((String)filePath, (String)"/");
        FileListingService.FileEntry fileEntry = fileListingService.getRoot();
        for (String destinationPathSegment : destinationPathSegments) {
            fileListingService.getChildren(fileEntry, true, null);
            fileEntry = fileEntry.findChild(destinationPathSegment);
            if (fileEntry != null) continue;
            throw new MojoExecutionException("Cannot execute goal: " + filePath + " does not exist on device.");
        }
        return fileEntry;
    }
}

