/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.maven.plugins.android.phase05compile;

import com.jayway.maven.plugins.android.AbstractAndroidMojo;
import com.jayway.maven.plugins.android.AndroidNdk;
import com.jayway.maven.plugins.android.CommandExecutor;
import com.jayway.maven.plugins.android.ExecutionException;
import com.jayway.maven.plugins.android.common.AetherHelper;
import com.jayway.maven.plugins.android.common.NativeHelper;
import com.jayway.maven.plugins.android.configuration.HeaderFilesDirective;
import com.jayway.maven.plugins.android.configuration.Ndk;
import com.jayway.maven.plugins.android.phase05compile.MakefileHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.util.IOUtil;

public class NdkBuildMojo
extends AbstractAndroidMojo {
    private Ndk ndk;
    private String ndkBuildExecutable;
    private String ndkBuildDirectory;
    private File ndkPath;
    protected String ndkClassifier;
    protected String ndkBuildAdditionalCommandline;
    protected boolean clearNativeArtifacts = false;
    protected boolean attachNativeArtifacts;
    public static final String ENV_ANDROID_NDK_HOME = "ANDROID_NDK_HOME";
    protected File ndkOutputDirectory;
    private File nativeLibrariesOutputDirectory;
    private String target;
    protected String ndkArchitecture = "armeabi";
    protected ArtifactFactory artifactFactory;
    private boolean attachHeaderFiles = true;
    private boolean useLocalSrcIncludePaths = false;
    private List<HeaderFilesDirective> headerFilesDirectives;
    private JarArchiver jarArchiver;
    private boolean useHeaderArchives = true;
    private Map<String, String> systemProperties;
    private boolean ignoreBuildWarnings = true;
    private String buildWarningsRegularExpression = ".*[warning|note]: .*";

    public void execute() throws MojoExecutionException, MojoFailureException {
        File nativeLibDirectory = new File(this.nativeLibrariesOutputDirectory, this.ndkArchitecture);
        boolean libsDirectoryExists = nativeLibDirectory.exists();
        File directoryToRemove = nativeLibDirectory;
        if (!libsDirectoryExists) {
            this.getLog().info((CharSequence)("Creating native output directory " + nativeLibDirectory));
            if (nativeLibDirectory.getParentFile().exists()) {
                nativeLibDirectory.mkdir();
            } else {
                nativeLibDirectory.mkdirs();
                directoryToRemove = nativeLibDirectory.getParentFile();
            }
        }
        CommandExecutor executor = CommandExecutor.Factory.createDefaultCommmandExecutor();
        executor.setErrorListener(new CommandExecutor.ErrorListener(){

            @Override
            public boolean isError(String error) {
                Pattern pattern = Pattern.compile(NdkBuildMojo.this.buildWarningsRegularExpression);
                Matcher matcher = pattern.matcher(error);
                return !NdkBuildMojo.this.ignoreBuildWarnings || !matcher.matches();
            }
        });
        Set<Artifact> nativeLibraryArtifacts = this.findNativeLibraryDependencies();
        Set<Artifact> resolveNativeLibraryArtifacts = AetherHelper.resolveArtifacts(nativeLibraryArtifacts, this.repoSystem, this.repoSession, this.projectRepos);
        try {
            File f = File.createTempFile("android_maven_plugin_makefile", ".mk");
            f.deleteOnExit();
            String makeFile = MakefileHelper.createMakefileFromArtifacts(f.getParentFile(), resolveNativeLibraryArtifacts, this.useHeaderArchives, this.repoSession, this.projectRepos, this.repoSystem);
            IOUtil.copy((String)makeFile, (OutputStream)new FileOutputStream(f));
            executor.addEnvironment("ANDROID_MAVEN_PLUGIN_MAKEFILE", f.getAbsolutePath());
            if (NativeHelper.hasStaticNativeLibraryArtifact(resolveNativeLibraryArtifacts)) {
                executor.addEnvironment("ANDROID_MAVEN_PLUGIN_LOCAL_STATIC_LIBRARIES", MakefileHelper.createStaticLibraryList(resolveNativeLibraryArtifacts, true));
            }
            if (NativeHelper.hasSharedNativeLibraryArtifact(resolveNativeLibraryArtifacts)) {
                executor.addEnvironment("ANDROID_MAVEN_PLUGIN_LOCAL_SHARED_LIBRARIES", MakefileHelper.createStaticLibraryList(resolveNativeLibraryArtifacts, false));
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage());
        }
        File localCIncludesFile = null;
        try {
            localCIncludesFile = File.createTempFile("android_maven_plugin_makefile_captures", ".tmp");
            localCIncludesFile.deleteOnExit();
            executor.addEnvironment("ANDROID_MAVEN_PLUGIN_LOCAL_C_INCLUDES_FILE", localCIncludesFile.getAbsolutePath());
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage());
        }
        if (this.systemProperties != null && !this.systemProperties.isEmpty()) {
            for (Map.Entry<String, String> entry : this.systemProperties.entrySet()) {
                executor.addEnvironment(entry.getKey(), entry.getValue());
            }
        }
        executor.setLogger(this.getLog());
        ArrayList<String> commands = new ArrayList<String>();
        commands.add("-C");
        if (this.ndkBuildDirectory == null) {
            this.ndkBuildDirectory = this.project.getBasedir().getAbsolutePath();
        }
        commands.add(this.ndkBuildDirectory);
        if (this.ndkBuildAdditionalCommandline != null) {
            String[] additionalCommands;
            for (String command : additionalCommands = this.ndkBuildAdditionalCommandline.split(" ")) {
                commands.add(command);
            }
        }
        if (this.target != null) {
            commands.add(this.target);
        } else {
            commands.add(this.project.getArtifactId());
        }
        String ndkBuildPath = this.resolveNdkBuildExecutable();
        this.getLog().info((CharSequence)(ndkBuildPath + " " + ((Object)commands).toString()));
        try {
            executor.executeCommand(ndkBuildPath, commands, this.project.getBasedir(), true);
        }
        catch (ExecutionException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        if (this.clearNativeArtifacts) {
            File destinationDirectory = new File(this.ndkOutputDirectory.getAbsolutePath(), "/" + this.ndkArchitecture);
            try {
                if (!libsDirectoryExists) {
                    FileUtils.moveDirectory((File)nativeLibDirectory, (File)destinationDirectory);
                } else {
                    FileUtils.copyDirectory((File)nativeLibDirectory, (File)destinationDirectory);
                    FileUtils.cleanDirectory((File)nativeLibDirectory);
                }
                nativeLibDirectory = destinationDirectory;
            }
            catch (IOException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)e);
            }
        }
        if (!libsDirectoryExists) {
            this.getLog().info((CharSequence)"Cleaning up native library output directory after build");
            this.getLog().debug((CharSequence)("Removing directory: " + directoryToRemove));
            if (!directoryToRemove.delete()) {
                this.getLog().warn((CharSequence)"Could not remove directory, marking as delete on exit");
                directoryToRemove.deleteOnExit();
            }
        }
        if ("so".equals(this.project.getPackaging()) || "a".equals(this.project.getPackaging()) || this.attachNativeArtifacts) {
            File[] files = nativeLibDirectory.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    if ("a".equals(NdkBuildMojo.this.project.getPackaging())) {
                        return name.startsWith("lib" + (NdkBuildMojo.this.target != null ? NdkBuildMojo.this.target : NdkBuildMojo.this.project.getArtifactId())) && name.endsWith(".a");
                    }
                    return name.startsWith("lib" + (NdkBuildMojo.this.target != null ? NdkBuildMojo.this.target : NdkBuildMojo.this.project.getArtifactId())) && name.endsWith(".so");
                }
            });
            if (files == null || files.length != 1) {
                this.getLog().warn((CharSequence)("Error while detecting native compile artifacts: " + (files == null || files.length == 0 ? "None found" : "Found more than 1 artifact")));
                if (files != null && files.length > 1) {
                    this.getLog().error((CharSequence)"Currently, only a single, final native library is supported by the build");
                    throw new MojoExecutionException("Currently, only a single, final native library is supported by the build");
                }
                this.getLog().error((CharSequence)"No native compiled library found, did the native compile complete successfully?");
                throw new MojoExecutionException("No native compiled library found, did the native compile complete successfully?");
            }
            this.getLog().debug((CharSequence)("Adding native compile artifact: " + files[0]));
            String artifactType = this.resolveArtifactType(files[0]);
            this.projectHelper.attachArtifact(this.project, artifactType, this.ndkClassifier != null ? this.ndkClassifier : this.ndkArchitecture, files[0]);
        }
        this.processHeaderFileIncludes(localCIncludesFile);
    }

    private String resolveNdkBuildExecutable() throws MojoExecutionException {
        if (this.ndkBuildExecutable != null) {
            this.getLog().debug((CharSequence)("ndk-build overriden, using " + this.ndkBuildExecutable));
            return this.ndkBuildExecutable;
        }
        return this.getAndroidNdk().getNdkBuildPath();
    }

    private void processHeaderFileIncludes(File localCIncludesFile) throws MojoExecutionException {
        try {
            if (this.attachHeaderFiles) {
                ArrayList<HeaderFilesDirective> finalHeaderFilesDirectives = new ArrayList<HeaderFilesDirective>();
                if (this.useLocalSrcIncludePaths) {
                    Properties props = new Properties();
                    props.load(new FileInputStream(localCIncludesFile));
                    String localCIncludes = props.getProperty("LOCAL_C_INCLUDES");
                    if (localCIncludes != null && !localCIncludes.trim().isEmpty()) {
                        String[] includes;
                        for (String include : includes = localCIncludes.split(" ")) {
                            HeaderFilesDirective headerFilesDirective = new HeaderFilesDirective();
                            File includeDir = new File(this.project.getBasedir(), include);
                            headerFilesDirective.setDirectory(includeDir.getAbsolutePath());
                            headerFilesDirective.setIncludes(new String[]{"**/*.h"});
                            finalHeaderFilesDirectives.add(headerFilesDirective);
                        }
                    }
                } else if (this.headerFilesDirectives != null) {
                    finalHeaderFilesDirectives.addAll(this.headerFilesDirectives);
                }
                if (finalHeaderFilesDirectives.isEmpty()) {
                    this.getLog().debug((CharSequence)"No header files included, will add default set");
                    HeaderFilesDirective e = new HeaderFilesDirective();
                    e.setDirectory(new File(this.project.getBasedir() + "/jni").getAbsolutePath());
                    e.setIncludes(new String[]{"**/*.h"});
                    finalHeaderFilesDirectives.add(e);
                }
                this.createHeaderArchive(finalHeaderFilesDirectives);
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error while processing headers to include: " + e.getMessage(), e);
        }
    }

    private void createHeaderArchive(List<HeaderFilesDirective> finalHeaderFilesDirectives) throws MojoExecutionException {
        try {
            MavenArchiver mavenArchiver = new MavenArchiver();
            mavenArchiver.setArchiver(this.jarArchiver);
            File jarFile = new File(new File(this.project.getBuild().getDirectory()), this.project.getBuild().getFinalName() + ".har");
            mavenArchiver.setOutputFile(jarFile);
            for (HeaderFilesDirective headerFilesDirective : finalHeaderFilesDirectives) {
                mavenArchiver.getArchiver().addDirectory(new File(headerFilesDirective.getDirectory()), headerFilesDirective.getIncludes(), headerFilesDirective.getExcludes());
            }
            MavenArchiveConfiguration mavenArchiveConfiguration = new MavenArchiveConfiguration();
            mavenArchiveConfiguration.setAddMavenDescriptor(false);
            mavenArchiver.createArchive(this.project, mavenArchiveConfiguration);
            this.projectHelper.attachArtifact(this.project, "har", this.ndkClassifier != null ? this.ndkClassifier : this.ndkArchitecture, jarFile);
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage());
        }
    }

    private Set<Artifact> findNativeLibraryDependencies() throws MojoExecutionException {
        NativeHelper nativeHelper = new NativeHelper(this.project, this.projectRepos, this.repoSession, this.repoSystem, this.artifactFactory, this.getLog());
        Set<Artifact> staticLibraryArtifacts = nativeHelper.getNativeDependenciesArtifacts(this.unpackedApkLibsDirectory, false);
        Set<Artifact> sharedLibraryArtifacts = nativeHelper.getNativeDependenciesArtifacts(this.unpackedApkLibsDirectory, true);
        LinkedHashSet<Artifact> mergedArtifacts = new LinkedHashSet<Artifact>(staticLibraryArtifacts);
        mergedArtifacts.addAll(sharedLibraryArtifacts);
        return mergedArtifacts;
    }

    private String resolveArtifactType(File file) {
        if ("so".equals(this.project.getPackaging()) || "a".equals(this.project.getPackaging())) {
            return this.project.getPackaging();
        }
        return file.getName().endsWith("so") ? "so" : "a";
    }

    protected AndroidNdk getAndroidNdk() throws MojoExecutionException {
        File chosenNdkPath = this.ndk != null ? (this.ndk.getPath() != null ? this.ndk.getPath() : (this.ndkPath != null ? this.ndkPath : new File(this.getAndroidNdkHomeOrThrow()))) : (this.ndkPath != null ? this.ndkPath : new File(this.getAndroidNdkHomeOrThrow()));
        return new AndroidNdk(chosenNdkPath);
    }

    private String getAndroidNdkHomeOrThrow() throws MojoExecutionException {
        String androidHome = System.getenv(ENV_ANDROID_NDK_HOME);
        if (StringUtils.isBlank((String)androidHome)) {
            throw new MojoExecutionException("No Android NDK path could be found. You may configure it in the pom using <ndk><path>...</path></ndk> or <properties><ndk.path>...</ndk.path></properties> or on command-line using -Dandroid.ndk.path=... or by setting environment variable ANDROID_NDK_HOME");
        }
        return androidHome;
    }
}

