/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.maven.plugins.android;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.TimeoutException;
import com.android.ddmlib.testrunner.IRemoteAndroidTestRunner;
import com.android.ddmlib.testrunner.ITestRunListener;
import com.android.ddmlib.testrunner.RemoteAndroidTestRunner;
import com.android.ddmlib.testrunner.TestIdentifier;
import com.jayway.maven.plugins.android.AbstractAndroidMojo;
import com.jayway.maven.plugins.android.DeviceCallback;
import com.jayway.maven.plugins.android.asm.AndroidTestFinder;
import com.jayway.maven.plugins.android.common.DeviceHelper;
import com.jayway.maven.plugins.android.configuration.Test;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public abstract class AbstractInstrumentationMojo
extends AbstractAndroidMojo {
    private boolean mavenTestSkip;
    private boolean mavenSkipTests;
    private Test test;
    private String testSkip;
    private String testInstrumentationPackage;
    private String testInstrumentationRunner;
    private Boolean testDebug;
    private Boolean testCoverage;
    private Boolean testLogOnly;
    private String testTestSize;
    private Boolean testCreateReport;
    protected List testPackages;
    protected List testClasses;
    private boolean classesExists;
    private boolean packagesExists;
    private String parsedSkip;
    private String parsedInstrumentationPackage;
    private String parsedInstrumentationRunner;
    private List parsedClasses;
    private List parsedPackages;
    private String parsedTestSize;
    private Boolean parsedCoverage;
    private Boolean parsedDebug;
    private Boolean parsedLogOnly;
    private Boolean parsedCreateReport;
    private String packagesList;

    protected void instrument() throws MojoExecutionException, MojoFailureException {
        this.parseConfiguration();
        if (this.parsedInstrumentationPackage == null) {
            this.parsedInstrumentationPackage = this.extractPackageNameFromAndroidManifest(this.androidManifestFile);
        }
        if (this.parsedInstrumentationRunner == null) {
            this.parsedInstrumentationRunner = this.extractInstrumentationRunnerFromAndroidManifest(this.androidManifestFile);
        }
        this.packagesList = AbstractInstrumentationMojo.buildCommaSeparatedString(this.parsedPackages);
        this.packagesExists = StringUtils.isNotBlank((String)this.packagesList);
        this.classesExists = this.parsedClasses != null ? this.parsedClasses.size() > 0 : false;
        if (this.classesExists && this.packagesExists) {
            throw new MojoFailureException("packages and classes are mutually exclusive. They cannot be specified at the same time. Please specify either packages or classes. For details, see http://developer.android.com/guide/developing/testing/testing_otheride.html");
        }
        this.doWithDevices(new DeviceCallback(){

            @Override
            public void doWithDevice(IDevice device) throws MojoExecutionException, MojoFailureException {
                RemoteAndroidTestRunner remoteAndroidTestRunner = new RemoteAndroidTestRunner(AbstractInstrumentationMojo.this.parsedInstrumentationPackage, AbstractInstrumentationMojo.this.parsedInstrumentationRunner, device);
                if (AbstractInstrumentationMojo.this.packagesExists) {
                    remoteAndroidTestRunner.setTestPackageName(AbstractInstrumentationMojo.this.packagesList);
                    AbstractInstrumentationMojo.this.getLog().info((CharSequence)("Running tests for specified test packages: " + AbstractInstrumentationMojo.this.packagesList));
                }
                if (AbstractInstrumentationMojo.this.classesExists) {
                    remoteAndroidTestRunner.setClassNames((String[])AbstractInstrumentationMojo.this.parsedClasses.toArray());
                    AbstractInstrumentationMojo.this.getLog().info((CharSequence)("Running tests for specified test classes/methods: " + AbstractInstrumentationMojo.this.parsedClasses));
                }
                remoteAndroidTestRunner.setDebug(AbstractInstrumentationMojo.this.parsedDebug.booleanValue());
                remoteAndroidTestRunner.setCoverage(AbstractInstrumentationMojo.this.parsedCoverage.booleanValue());
                remoteAndroidTestRunner.setLogOnly(AbstractInstrumentationMojo.this.parsedLogOnly.booleanValue());
                if (StringUtils.isNotBlank((String)AbstractInstrumentationMojo.this.parsedTestSize)) {
                    IRemoteAndroidTestRunner.TestSize validSize = IRemoteAndroidTestRunner.TestSize.getTestSize((String)AbstractInstrumentationMojo.this.parsedTestSize);
                    remoteAndroidTestRunner.setTestSize(validSize);
                }
                AbstractInstrumentationMojo.this.getLog().info((CharSequence)("Running instrumentation tests in " + AbstractInstrumentationMojo.this.parsedInstrumentationPackage + " on " + device.getSerialNumber() + " (avdName=" + device.getAvdName() + ")"));
                try {
                    AndroidTestRunListener testRunListener = new AndroidTestRunListener(AbstractInstrumentationMojo.this.project, device);
                    remoteAndroidTestRunner.run(new ITestRunListener[]{testRunListener});
                    if (testRunListener.hasFailuresOrErrors()) {
                        throw new MojoFailureException("Tests failed on device.");
                    }
                    if (testRunListener.testRunFailed()) {
                        throw new MojoFailureException("Test run failed to complete: " + testRunListener.getTestRunFailureCause());
                    }
                    if (testRunListener.threwException()) {
                        throw new MojoFailureException(testRunListener.getExceptionMessages());
                    }
                }
                catch (TimeoutException e) {
                    throw new MojoExecutionException("timeout", (Exception)((Object)e));
                }
                catch (AdbCommandRejectedException e) {
                    throw new MojoExecutionException("adb command rejected", (Exception)((Object)e));
                }
                catch (ShellCommandUnresponsiveException e) {
                    throw new MojoExecutionException("shell command unresponsive", (Exception)((Object)e));
                }
                catch (IOException e) {
                    throw new MojoExecutionException("IO problem", (Exception)e);
                }
            }
        });
    }

    private void parseConfiguration() {
        if (this.test != null) {
            this.parsedSkip = StringUtils.isNotEmpty((String)this.test.getSkip()) ? this.test.getSkip() : this.testSkip;
            this.parsedInstrumentationPackage = StringUtils.isNotEmpty((String)this.test.getInstrumentationPackage()) ? this.test.getInstrumentationPackage() : this.testInstrumentationPackage;
            this.parsedInstrumentationRunner = StringUtils.isNotEmpty((String)this.test.getInstrumentationRunner()) ? this.test.getInstrumentationRunner() : this.testInstrumentationRunner;
            this.parsedClasses = this.test.getClasses() == null || this.test.getClasses().size() == 0 ? this.test.getClasses() : this.testClasses;
            this.parsedPackages = this.test.getPackages() == null || this.test.getPackages().size() == 0 ? this.test.getPackages() : this.testPackages;
            this.parsedTestSize = StringUtils.isNotEmpty((String)this.test.getTestSize()) ? this.test.getTestSize() : this.testTestSize;
            this.parsedCoverage = this.test.isCoverage() != null ? this.test.isCoverage() : this.testCoverage;
            this.parsedDebug = this.test.isDebug() != null ? this.test.isDebug() : this.testDebug;
            this.parsedLogOnly = this.test.isLogOnly() != null ? this.test.isLogOnly() : this.testLogOnly;
            this.parsedCreateReport = this.test.isCreateReport() != null ? this.test.isCreateReport() : this.testCreateReport;
        } else {
            this.parsedSkip = this.testSkip;
            this.parsedInstrumentationPackage = this.testInstrumentationPackage;
            this.parsedInstrumentationRunner = this.testInstrumentationRunner;
            this.parsedClasses = this.testClasses;
            this.parsedPackages = this.testPackages;
            this.parsedTestSize = this.testTestSize;
            this.parsedCoverage = this.testCoverage;
            this.parsedDebug = this.testDebug;
            this.parsedLogOnly = this.testLogOnly;
            this.parsedCreateReport = this.testCreateReport;
        }
    }

    protected boolean isEnableIntegrationTest() throws MojoFailureException, MojoExecutionException {
        this.parseConfiguration();
        if (this.mavenTestSkip) {
            this.getLog().info((CharSequence)"maven.test.skip set - skipping tests");
            return false;
        }
        if (this.mavenSkipTests) {
            this.getLog().info((CharSequence)"maven.skip.tests set - skipping tests");
            return false;
        }
        if ("true".equalsIgnoreCase(this.parsedSkip)) {
            this.getLog().info((CharSequence)"android.test.skip set - skipping tests");
            return false;
        }
        if ("false".equalsIgnoreCase(this.parsedSkip)) {
            return true;
        }
        if (this.parsedSkip == null || "auto".equalsIgnoreCase(this.parsedSkip)) {
            if (this.extractInstrumentationRunnerFromAndroidManifest(this.androidManifestFile) == null) {
                this.getLog().info((CharSequence)"No InstrumentationRunner found - skipping tests");
                return false;
            }
            return AndroidTestFinder.containsAndroidTests(new File(this.project.getBuild().getOutputDirectory()));
        }
        throw new MojoFailureException("android.test.skip must be configured as 'true', 'false' or 'auto'.");
    }

    protected static String buildCommaSeparatedString(List<String> lines) {
        if (lines == null || lines.size() == 0) {
            return null;
        }
        ArrayList<String> strings = new ArrayList<String>(lines.size());
        for (String str : lines) {
            if (!StringUtils.isNotBlank((String)str)) continue;
            strings.add(StringUtils.trimToEmpty((String)str));
        }
        return StringUtils.join(strings, (String)",");
    }

    private class AndroidTestRunListener
    implements ITestRunListener {
        private static final String INDENT = "  ";
        private static final String TAG_TESTSUITES = "testsuites";
        private static final String TAG_TESTSUITE = "testsuite";
        private static final String ATTR_TESTSUITE_ERRORS = "errors";
        private static final String ATTR_TESTSUITE_FAILURES = "failures";
        private static final String ATTR_TESTSUITE_HOSTNAME = "hostname";
        private static final String ATTR_TESTSUITE_NAME = "name";
        private static final String ATTR_TESTSUITE_TESTS = "tests";
        private static final String ATTR_TESTSUITE_TIME = "time";
        private static final String ATTR_TESTSUITE_TIMESTAMP = "timestamp";
        private static final String TAG_PROPERTIES = "properties";
        private static final String TAG_PROPERTY = "property";
        private static final String ATTR_PROPERTY_NAME = "name";
        private static final String ATTR_PROPERTY_VALUE = "value";
        private static final String TAG_TESTCASE = "testcase";
        private static final String ATTR_TESTCASE_NAME = "name";
        private static final String ATTR_TESTCASE_CLASSNAME = "classname";
        private static final String ATTR_TESTCASE_TIME = "time";
        private static final String TAG_ERROR = "error";
        private static final String TAG_FAILURE = "failure";
        private static final String ATTR_MESSAGE = "message";
        private static final String ATTR_TYPE = "type";
        private final NumberFormat timeFormatter = new DecimalFormat("#0.0000");
        private int testCount = 0;
        private int testFailureCount = 0;
        private int testErrorCount = 0;
        private String testRunFailureCause = null;
        private final MavenProject project;
        private final IDevice device;
        private Document junitReport;
        private Node testSuiteNode;
        private Node currentTestCaseNode;
        private long currentTestCaseStartTime;
        private boolean threwException = false;
        private final StringBuilder exceptionMessages = new StringBuilder();

        public AndroidTestRunListener(MavenProject project, IDevice device) {
            this.project = project;
            this.device = device;
        }

        public void testRunStarted(String runName, int testCount) {
            this.testCount = testCount;
            AbstractInstrumentationMojo.this.getLog().info((CharSequence)("  Run started: " + runName + ", " + testCount + " tests:"));
            if (AbstractInstrumentationMojo.this.parsedCreateReport.booleanValue()) {
                try {
                    Attr propValueAttr;
                    Attr propNameAttr;
                    NamedNodeMap propertyAttributes;
                    Element propertyNode;
                    DocumentBuilderFactory fact = DocumentBuilderFactory.newInstance();
                    DocumentBuilder parser = null;
                    parser = fact.newDocumentBuilder();
                    this.junitReport = parser.newDocument();
                    Element testSuitesNode = this.junitReport.createElement(TAG_TESTSUITES);
                    this.junitReport.appendChild(testSuitesNode);
                    this.testSuiteNode = this.junitReport.createElement(TAG_TESTSUITE);
                    NamedNodeMap testSuiteAttributes = this.testSuiteNode.getAttributes();
                    Attr nameAttr = this.junitReport.createAttribute("name");
                    nameAttr.setValue(runName);
                    testSuiteAttributes.setNamedItem(nameAttr);
                    Attr hostnameAttr = this.junitReport.createAttribute(ATTR_TESTSUITE_HOSTNAME);
                    hostnameAttr.setValue(DeviceHelper.getDescriptiveName(this.device));
                    testSuiteAttributes.setNamedItem(hostnameAttr);
                    Element propertiesNode = this.junitReport.createElement(TAG_PROPERTIES);
                    for (Map.Entry<Object, Object> systemProperty : System.getProperties().entrySet()) {
                        propertyNode = this.junitReport.createElement(TAG_PROPERTY);
                        propertyAttributes = propertyNode.getAttributes();
                        propNameAttr = this.junitReport.createAttribute("name");
                        propNameAttr.setValue(systemProperty.getKey().toString());
                        propertyAttributes.setNamedItem(propNameAttr);
                        propValueAttr = this.junitReport.createAttribute(ATTR_PROPERTY_VALUE);
                        propValueAttr.setValue(systemProperty.getValue().toString());
                        propertyAttributes.setNamedItem(propValueAttr);
                        propertiesNode.appendChild(propertyNode);
                    }
                    Map deviceProperties = this.device.getProperties();
                    for (Map.Entry deviceProperty : deviceProperties.entrySet()) {
                        propertyNode = this.junitReport.createElement(TAG_PROPERTY);
                        propertyAttributes = propertyNode.getAttributes();
                        propNameAttr = this.junitReport.createAttribute("name");
                        propNameAttr.setValue((String)deviceProperty.getKey());
                        propertyAttributes.setNamedItem(propNameAttr);
                        propValueAttr = this.junitReport.createAttribute(ATTR_PROPERTY_VALUE);
                        propValueAttr.setValue((String)deviceProperty.getValue());
                        propertyAttributes.setNamedItem(propValueAttr);
                        propertiesNode.appendChild(propertyNode);
                    }
                    this.testSuiteNode.appendChild(propertiesNode);
                    testSuitesNode.appendChild(this.testSuiteNode);
                }
                catch (ParserConfigurationException e) {
                    this.threwException = true;
                    this.exceptionMessages.append("Failed to create document");
                    this.exceptionMessages.append(e.getMessage());
                }
            }
        }

        public void testStarted(TestIdentifier test) {
            AbstractInstrumentationMojo.this.getLog().info((CharSequence)("    Start: " + test.toString()));
            if (AbstractInstrumentationMojo.this.parsedCreateReport.booleanValue()) {
                this.currentTestCaseStartTime = new Date().getTime();
                this.currentTestCaseNode = this.junitReport.createElement(TAG_TESTCASE);
                NamedNodeMap testCaseAttributes = this.currentTestCaseNode.getAttributes();
                Attr classAttr = this.junitReport.createAttribute(ATTR_TESTCASE_CLASSNAME);
                classAttr.setValue(test.getClassName());
                testCaseAttributes.setNamedItem(classAttr);
                Attr methodAttr = this.junitReport.createAttribute("name");
                methodAttr.setValue(test.getTestName());
                testCaseAttributes.setNamedItem(methodAttr);
            }
        }

        public void testFailed(ITestRunListener.TestFailure status, TestIdentifier test, String trace) {
            if (status == ITestRunListener.TestFailure.ERROR) {
                ++this.testErrorCount;
            } else {
                ++this.testFailureCount;
            }
            AbstractInstrumentationMojo.this.getLog().info((CharSequence)("    " + status.name() + ":" + test.toString()));
            AbstractInstrumentationMojo.this.getLog().info((CharSequence)("    " + trace));
            if (AbstractInstrumentationMojo.this.parsedCreateReport.booleanValue()) {
                NamedNodeMap errorfailureAttributes;
                Element errorFailureNode;
                if (status == ITestRunListener.TestFailure.ERROR) {
                    errorFailureNode = this.junitReport.createElement(TAG_ERROR);
                    errorfailureAttributes = errorFailureNode.getAttributes();
                } else {
                    errorFailureNode = this.junitReport.createElement(TAG_FAILURE);
                    errorfailureAttributes = errorFailureNode.getAttributes();
                }
                errorFailureNode.setTextContent(trace);
                Attr msgAttr = this.junitReport.createAttribute(ATTR_MESSAGE);
                msgAttr.setValue(this.parseForMessage(trace));
                errorfailureAttributes.setNamedItem(msgAttr);
                Attr typeAttr = this.junitReport.createAttribute(ATTR_TYPE);
                typeAttr.setValue(this.parseForException(trace));
                errorfailureAttributes.setNamedItem(typeAttr);
                this.currentTestCaseNode.appendChild(errorFailureNode);
            }
        }

        public void testEnded(TestIdentifier test, Map<String, String> testMetrics) {
            AbstractInstrumentationMojo.this.getLog().info((CharSequence)("    End: " + test.toString()));
            this.logMetrics(testMetrics);
            if (AbstractInstrumentationMojo.this.parsedCreateReport.booleanValue()) {
                this.testSuiteNode.appendChild(this.currentTestCaseNode);
                NamedNodeMap testCaseAttributes = this.currentTestCaseNode.getAttributes();
                Attr timeAttr = this.junitReport.createAttribute("time");
                long now = new Date().getTime();
                double seconds = (double)(now - this.currentTestCaseStartTime) / 1000.0;
                timeAttr.setValue(this.timeFormatter.format(seconds));
                testCaseAttributes.setNamedItem(timeAttr);
            }
        }

        public void testRunEnded(long elapsedTime, Map<String, String> runMetrics) {
            AbstractInstrumentationMojo.this.getLog().info((CharSequence)("  Run ended: " + elapsedTime + " ms"));
            if (this.hasFailuresOrErrors()) {
                AbstractInstrumentationMojo.this.getLog().error((CharSequence)"  FAILURES!!!");
            }
            AbstractInstrumentationMojo.this.getLog().info((CharSequence)("  Tests run: " + this.testCount + ",  Failures: " + this.testFailureCount + ",  Errors: " + this.testErrorCount));
            if (AbstractInstrumentationMojo.this.parsedCreateReport.booleanValue()) {
                NamedNodeMap testSuiteAttributes = this.testSuiteNode.getAttributes();
                Attr testCountAttr = this.junitReport.createAttribute(ATTR_TESTSUITE_TESTS);
                testCountAttr.setValue(Integer.toString(this.testCount));
                testSuiteAttributes.setNamedItem(testCountAttr);
                Attr testFailuresAttr = this.junitReport.createAttribute(ATTR_TESTSUITE_FAILURES);
                testFailuresAttr.setValue(Integer.toString(this.testFailureCount));
                testSuiteAttributes.setNamedItem(testFailuresAttr);
                Attr testErrorsAttr = this.junitReport.createAttribute(ATTR_TESTSUITE_ERRORS);
                testErrorsAttr.setValue(Integer.toString(this.testErrorCount));
                testSuiteAttributes.setNamedItem(testErrorsAttr);
                Attr timeAttr = this.junitReport.createAttribute("time");
                timeAttr.setValue(this.timeFormatter.format((double)elapsedTime / 1000.0));
                testSuiteAttributes.setNamedItem(timeAttr);
                Attr timeStampAttr = this.junitReport.createAttribute(ATTR_TESTSUITE_TIMESTAMP);
                timeStampAttr.setValue(new Date().toString());
                testSuiteAttributes.setNamedItem(timeStampAttr);
            }
            this.logMetrics(runMetrics);
            if (AbstractInstrumentationMojo.this.parsedCreateReport.booleanValue()) {
                this.writeJunitReportToFile();
            }
        }

        public void testRunFailed(String errorMessage) {
            this.testRunFailureCause = errorMessage;
            AbstractInstrumentationMojo.this.getLog().info((CharSequence)("  Run failed: " + errorMessage));
        }

        public void testRunStopped(long elapsedTime) {
            AbstractInstrumentationMojo.this.getLog().info((CharSequence)("  Run stopped:" + elapsedTime));
        }

        private String parseForMessage(String trace) {
            if (StringUtils.isNotBlank((String)trace)) {
                boolean hasMessage;
                String newline = "\r\n";
                int messageEnd = trace.indexOf(newline);
                boolean bl = hasMessage = !trace.startsWith("junit.") && messageEnd > 0;
                if (hasMessage) {
                    int messageStart = trace.indexOf(":") + 2;
                    if (messageStart > messageEnd) {
                        messageEnd = trace.indexOf(newline + "at");
                    }
                    return trace.substring(messageStart, messageEnd);
                }
                return "";
            }
            return "";
        }

        private String parseForException(String trace) {
            if (StringUtils.isNotBlank((String)trace)) {
                return trace.substring(0, trace.indexOf(":"));
            }
            return "";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        private void writeJunitReportToFile() {
            block9: {
                TransformerFactory xfactory = TransformerFactory.newInstance();
                Transformer xformer = null;
                try {
                    xformer = xfactory.newTransformer();
                }
                catch (TransformerConfigurationException e) {
                    e.printStackTrace();
                }
                DOMSource source = new DOMSource(this.junitReport);
                FileWriter writer = null;
                try {
                    String directory = this.project.getBuild().getDirectory() + "/surefire-reports";
                    FileUtils.forceMkdir((File)new File(directory));
                    String fileName = directory + "/TEST-" + DeviceHelper.getDescriptiveName(this.device) + ".xml";
                    File reportFile = new File(fileName);
                    writer = new FileWriter(reportFile);
                    StreamResult result = new StreamResult(writer);
                    xformer.transform(source, result);
                    AbstractInstrumentationMojo.this.getLog().info((CharSequence)("Report file written to " + reportFile.getAbsolutePath()));
                    IOUtils.closeQuietly((Writer)writer);
                }
                catch (IOException e) {
                    this.threwException = true;
                    this.exceptionMessages.append("Failed to write test report file");
                    this.exceptionMessages.append(e.getMessage());
                }
                catch (TransformerException e2) {
                    this.threwException = true;
                    this.exceptionMessages.append("Failed to transform document to write to test report file");
                    this.exceptionMessages.append(e2.getMessage());
                    break block9;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                finally {
                    IOUtils.closeQuietly(writer);
                }
            }
        }

        private void logMetrics(Map<String, String> metrics) {
            for (Map.Entry<String, String> entry : metrics.entrySet()) {
                AbstractInstrumentationMojo.this.getLog().info((CharSequence)("    " + entry.getKey() + ": " + entry.getValue()));
            }
        }

        public boolean hasFailuresOrErrors() {
            return this.testErrorCount > 0 || this.testFailureCount > 0;
        }

        public boolean testRunFailed() {
            return this.testRunFailureCause != null;
        }

        public String getTestRunFailureCause() {
            return this.testRunFailureCause;
        }

        public boolean threwException() {
            return this.threwException;
        }

        public String getExceptionMessages() {
            return this.exceptionMessages.toString();
        }
    }
}

