/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.aiplatform.v1beta1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ModelMonitoringJobName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_MODEL_MONITOR_MODEL_MONITORING_JOB = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/modelMonitors/{model_monitor}/modelMonitoringJobs/{model_monitoring_job}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String modelMonitor;
    private final String modelMonitoringJob;

    @Deprecated
    protected ModelMonitoringJobName() {
        this.project = null;
        this.location = null;
        this.modelMonitor = null;
        this.modelMonitoringJob = null;
    }

    private ModelMonitoringJobName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.modelMonitor = (String)Preconditions.checkNotNull((Object)builder.getModelMonitor());
        this.modelMonitoringJob = (String)Preconditions.checkNotNull((Object)builder.getModelMonitoringJob());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getModelMonitor() {
        return this.modelMonitor;
    }

    public String getModelMonitoringJob() {
        return this.modelMonitoringJob;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ModelMonitoringJobName of(String project, String location, String modelMonitor, String modelMonitoringJob) {
        return ModelMonitoringJobName.newBuilder().setProject(project).setLocation(location).setModelMonitor(modelMonitor).setModelMonitoringJob(modelMonitoringJob).build();
    }

    public static String format(String project, String location, String modelMonitor, String modelMonitoringJob) {
        return ModelMonitoringJobName.newBuilder().setProject(project).setLocation(location).setModelMonitor(modelMonitor).setModelMonitoringJob(modelMonitoringJob).build().toString();
    }

    public static ModelMonitoringJobName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_MODEL_MONITOR_MODEL_MONITORING_JOB.validatedMatch(formattedString, "ModelMonitoringJobName.parse: formattedString not in valid format");
        return ModelMonitoringJobName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("model_monitor"), (String)matchMap.get("model_monitoring_job"));
    }

    public static List<ModelMonitoringJobName> parseList(List<String> formattedStrings) {
        ArrayList<ModelMonitoringJobName> list = new ArrayList<ModelMonitoringJobName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ModelMonitoringJobName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ModelMonitoringJobName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ModelMonitoringJobName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_MODEL_MONITOR_MODEL_MONITORING_JOB.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ModelMonitoringJobName modelMonitoringJobName = this;
            synchronized (modelMonitoringJobName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.modelMonitor != null) {
                        fieldMapBuilder.put((Object)"model_monitor", (Object)this.modelMonitor);
                    }
                    if (this.modelMonitoringJob != null) {
                        fieldMapBuilder.put((Object)"model_monitoring_job", (Object)this.modelMonitoringJob);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_MODEL_MONITOR_MODEL_MONITORING_JOB.instantiate(new String[]{"project", this.project, "location", this.location, "model_monitor", this.modelMonitor, "model_monitoring_job", this.modelMonitoringJob});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            ModelMonitoringJobName that = (ModelMonitoringJobName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.modelMonitor, that.modelMonitor) && Objects.equals(this.modelMonitoringJob, that.modelMonitoringJob);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.modelMonitor);
        h *= 1000003;
        return h ^= Objects.hashCode(this.modelMonitoringJob);
    }

    public static class Builder {
        private String project;
        private String location;
        private String modelMonitor;
        private String modelMonitoringJob;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getModelMonitor() {
            return this.modelMonitor;
        }

        public String getModelMonitoringJob() {
            return this.modelMonitoringJob;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setModelMonitor(String modelMonitor) {
            this.modelMonitor = modelMonitor;
            return this;
        }

        public Builder setModelMonitoringJob(String modelMonitoringJob) {
            this.modelMonitoringJob = modelMonitoringJob;
            return this;
        }

        private Builder(ModelMonitoringJobName modelMonitoringJobName) {
            this.project = modelMonitoringJobName.project;
            this.location = modelMonitoringJobName.location;
            this.modelMonitor = modelMonitoringJobName.modelMonitor;
            this.modelMonitoringJob = modelMonitoringJobName.modelMonitoringJob;
        }

        public ModelMonitoringJobName build() {
            return new ModelMonitoringJobName(this);
        }
    }
}

