/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.parser.model;

import com.github.dreamhead.moco.ResponseBase;
import com.github.dreamhead.moco.ResponseHandler;
import com.github.dreamhead.moco.RestSetting;
import com.github.dreamhead.moco.RestSettingBuilder;
import com.github.dreamhead.moco.parser.model.RequestSetting;
import com.github.dreamhead.moco.parser.model.ResponseSetting;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.stream.Collectors;

public abstract class RestBaseSetting {
    private RequestSetting request;
    private ResponseSetting response;

    protected abstract RestSettingBuilder startRestSetting();

    final RestSetting toRestSetting() {
        if (this.response == null) {
            throw new IllegalArgumentException("Response is expected in rest setting");
        }
        return (RestSetting)this.getRestSettingBuilder().response(this.response.getResponseHandler(), new ResponseHandler[0]);
    }

    private ResponseBase<RestSetting> getRestSettingBuilder() {
        RestSettingBuilder builder = this.startRestSetting();
        if (this.request != null) {
            return builder.request(this.request.getRequestMatcher());
        }
        return builder;
    }

    public static Iterable<RestSetting> asRestSetting(List<? extends RestBaseSetting> setting) {
        if (setting == null || setting.isEmpty()) {
            return ImmutableList.of();
        }
        return setting.stream().map(RestBaseSetting::toRestSetting).collect(Collectors.toList());
    }

    protected final MoreObjects.ToStringHelper toStringHelper() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("request", (Object)this.request).add("response", (Object)this.response);
    }
}

