/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.parser.model;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.github.dreamhead.moco.CookieAttribute;
import com.github.dreamhead.moco.parser.deserializer.CookieContainerDeserializer;
import com.github.dreamhead.moco.parser.model.Container;
import com.github.dreamhead.moco.parser.model.LatencyContainer;
import com.google.common.base.MoreObjects;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;

@JsonDeserialize(using=CookieContainerDeserializer.class)
public final class CookieContainer
implements Container {
    private String value;
    private String path;
    private String domain;
    private LatencyContainer maxAge;
    private boolean secure;
    private boolean httpOnly;
    private String template;

    public static CookieContainer newContainer(String text) {
        CookieContainer container = new CookieContainer();
        container.value = text;
        return container;
    }

    public static CookieContainer newContainer(String text, String path, String domain, LatencyContainer maxAge, boolean secure, boolean httpOnly, String template) {
        CookieContainer container = new CookieContainer();
        container.value = text;
        container.path = path;
        container.domain = domain;
        container.maxAge = maxAge;
        container.secure = secure;
        container.httpOnly = httpOnly;
        container.template = template;
        return container;
    }

    public String getValue() {
        return this.value;
    }

    public boolean isForTemplate() {
        return this.template != null;
    }

    public String getTemplate() {
        return this.template;
    }

    public CookieAttribute[] getOptions() {
        ArrayList options = Lists.newArrayList();
        if (this.path != null) {
            options.add(CookieAttribute.path((String)this.path));
        }
        if (this.domain != null) {
            options.add(CookieAttribute.domain((String)this.domain));
        }
        if (this.secure) {
            options.add(CookieAttribute.secure());
        }
        if (this.httpOnly) {
            options.add(CookieAttribute.httpOnly());
        }
        if (this.maxAge != null) {
            options.add(CookieAttribute.maxAge((long)this.maxAge.getLatency(), (TimeUnit)this.maxAge.getUnit()));
        }
        return options.toArray(new CookieAttribute[options.size()]);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("value", (Object)this.value).add("path", (Object)this.path).add("domain", (Object)this.domain).add("max age", (Object)this.maxAge).add("secure", this.secure).add("HTTP only", this.httpOnly).add("template", (Object)this.template).toString();
    }
}

