/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.bootstrap.arg;

import com.github.dreamhead.moco.HttpsCertificate;
import com.github.dreamhead.moco.bootstrap.HttpsArg;
import com.github.dreamhead.moco.bootstrap.ServerType;
import com.github.dreamhead.moco.bootstrap.ShutdownPortOption;
import java.util.Optional;

public abstract class StartArgs
extends ShutdownPortOption {
    private final ServerType type;
    private final Optional<Integer> port;
    private final Optional<String> configurationFile;
    private final Optional<String> settings;
    private final Optional<String> env;
    private final Optional<HttpsArg> httpsArg;

    protected StartArgs(ServerType type, Integer port, Integer shutdownPort, String configurationFile, String globalSettings, String env, HttpsArg httpsArg) {
        super(shutdownPort);
        this.type = type;
        this.port = Optional.ofNullable(port);
        this.configurationFile = Optional.ofNullable(configurationFile);
        this.settings = Optional.ofNullable(globalSettings);
        this.env = Optional.ofNullable(env);
        this.httpsArg = Optional.ofNullable(httpsArg);
    }

    public final Optional<Integer> getPort() {
        return this.port;
    }

    public final Optional<String> getConfigurationFile() {
        return this.configurationFile;
    }

    public final boolean hasConfigurationFile() {
        return this.configurationFile.isPresent();
    }

    public final Optional<String> getSettings() {
        return this.settings;
    }

    public final Optional<String> getEnv() {
        return this.env;
    }

    public final boolean isHttps() {
        return this.httpsArg.isPresent();
    }

    public final Optional<HttpsCertificate> getHttpsCertificate() {
        return this.httpsArg.map(HttpsArg::getCertificate);
    }

    public static String help() {
        String separator = System.getProperty("line.separator");
        return "Moco Options:" + separator + "moco [server type] -p port -c [configuration file]" + separator + separator + "server type: http, https, socket";
    }

    public final boolean isSocket() {
        return this.type == ServerType.SOCKET;
    }
}

