/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.spark.counter;

import com.facebook.presto.hive.$internal.org.apache.commons.logging.Log;
import com.facebook.presto.hive.$internal.org.apache.commons.logging.LogFactory;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.hive.spark.counter.SparkCounter;
import org.apache.hive.spark.counter.SparkCounterGroup;
import org.apache.spark.api.java.JavaSparkContext;

public class SparkCounters
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log LOG = LogFactory.getLog(SparkCounters.class);
    private Map<String, SparkCounterGroup> sparkCounterGroups;
    private final transient JavaSparkContext javaSparkContext;

    private SparkCounters() {
        this(null);
    }

    public SparkCounters(JavaSparkContext javaSparkContext) {
        this.javaSparkContext = javaSparkContext;
        this.sparkCounterGroups = new HashMap<String, SparkCounterGroup>();
    }

    public void createCounter(Enum<?> key) {
        this.createCounter(key.getDeclaringClass().getName(), key.name());
    }

    public void createCounter(String groupName, Enum<?> key) {
        this.createCounter(groupName, key.name(), 0L);
    }

    public void createCounter(String groupName, String counterName) {
        this.createCounter(groupName, counterName, 0L);
    }

    public void createCounter(String groupName, String counterName, long initValue) {
        this.getGroup(groupName).createCounter(counterName, initValue);
    }

    public void increment(Enum<?> key, long incrValue) {
        this.increment(key.getDeclaringClass().getName(), key.name(), incrValue);
    }

    public void increment(String groupName, String counterName, long value) {
        SparkCounter counter = this.getGroup(groupName).getCounter(counterName);
        if (counter == null) {
            LOG.error(String.format("counter[%s, %s] has not initialized before.", groupName, counterName));
        } else {
            counter.increment(value);
        }
    }

    public long getValue(String groupName, String counterName) {
        SparkCounter counter = this.getGroup(groupName).getCounter(counterName);
        if (counter == null) {
            LOG.error(String.format("counter[%s, %s] has not initialized before.", groupName, counterName));
            return 0L;
        }
        return counter.getValue();
    }

    public SparkCounter getCounter(String groupName, String counterName) {
        return this.getGroup(groupName).getCounter(counterName);
    }

    public SparkCounter getCounter(Enum<?> key) {
        return this.getCounter(key.getDeclaringClass().getName(), key.name());
    }

    private SparkCounterGroup getGroup(String groupName) {
        SparkCounterGroup group = this.sparkCounterGroups.get(groupName);
        if (group == null) {
            group = new SparkCounterGroup(groupName, groupName, this.javaSparkContext);
            this.sparkCounterGroups.put(groupName, group);
        }
        return group;
    }

    public Map<String, SparkCounterGroup> getSparkCounterGroups() {
        return this.sparkCounterGroups;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        Map<String, SparkCounterGroup> groups = this.getSparkCounterGroups();
        if (groups != null) {
            for (Map.Entry<String, SparkCounterGroup> groupEntry : groups.entrySet()) {
                String groupName = groupEntry.getKey();
                SparkCounterGroup group = groupEntry.getValue();
                sb.append(groupName).append("\n");
                Map<String, SparkCounter> counters = group.getSparkCounters();
                for (Map.Entry<String, SparkCounter> counterEntry : counters.entrySet()) {
                    String counterName = counterEntry.getKey();
                    SparkCounter counter = counterEntry.getValue();
                    sb.append("\t").append(counterName).append(": ").append(counter.getValue()).append("\n");
                }
            }
        }
        return sb.toString();
    }

    public SparkCounters snapshot() {
        SparkCounters snapshot = new SparkCounters();
        for (SparkCounterGroup group : this.sparkCounterGroups.values()) {
            SparkCounterGroup groupSnapshot = group.snapshot();
            snapshot.sparkCounterGroups.put(groupSnapshot.getGroupName(), groupSnapshot);
        }
        return snapshot;
    }
}

