/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf;

import com.facebook.presto.hive.$internal.org.apache.commons.logging.Log;
import com.facebook.presto.hive.$internal.org.apache.commons.logging.LogFactory;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedExpressions;
import org.apache.hadoop.hive.ql.exec.vector.expressions.FilterStringColRegExpStringScalar;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.Text;

@Description(name="rlike,regexp", value="str _FUNC_ regexp - Returns true if str matches regexp and false otherwise", extended="Example:\n  > SELECT 'fb' _FUNC_ '.*' FROM src LIMIT 1;\n  true")
@VectorizedExpressions(value={FilterStringColRegExpStringScalar.class})
public class UDFRegExp
extends UDF {
    static final Log LOG = LogFactory.getLog(UDFRegExp.class.getName());
    private final Text lastRegex = new Text();
    private Pattern p = null;
    private boolean warned = false;
    private final BooleanWritable result = new BooleanWritable();

    public BooleanWritable evaluate(Text s, Text regex) {
        if (s == null || regex == null) {
            return null;
        }
        if (regex.getLength() == 0) {
            if (!this.warned) {
                this.warned = true;
                LOG.warn(this.getClass().getSimpleName() + " regex is empty. Additional " + "warnings for an empty regex will be suppressed.");
            }
            this.result.set(false);
            return this.result;
        }
        if (!regex.equals((Object)this.lastRegex) || this.p == null) {
            this.lastRegex.set(regex);
            this.p = Pattern.compile(regex.toString());
        }
        Matcher m = this.p.matcher(s.toString());
        this.result.set(m.find(0));
        return this.result;
    }
}

