/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.spark;

import com.facebook.presto.hive.$internal.com.google.common.base.Preconditions;
import com.facebook.presto.hive.$internal.org.apache.commons.logging.Log;
import com.facebook.presto.hive.$internal.org.apache.commons.logging.LogFactory;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.DriverContext;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.io.orc.OrcInputFormat;
import org.apache.hadoop.hive.ql.io.rcfile.stats.PartialScanWork;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.optimizer.GenMapRedUtils;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.PrunedPartitionList;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.spark.GenSparkProcContext;
import org.apache.hadoop.hive.ql.parse.spark.GenSparkUtils;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.ql.plan.SparkWork;
import org.apache.hadoop.hive.ql.plan.StatsNoJobWork;
import org.apache.hadoop.hive.ql.plan.StatsWork;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;
import org.apache.hadoop.mapred.InputFormat;

public class SparkProcessAnalyzeTable
implements NodeProcessor {
    private static final Log LOGGER = LogFactory.getLog(SparkProcessAnalyzeTable.class.getName());
    private GenSparkUtils utils = null;

    public SparkProcessAnalyzeTable(GenSparkUtils utils) {
        this.utils = utils;
    }

    @Override
    public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procContext, Object ... nodeOutputs) throws SemanticException {
        GenSparkProcContext context = (GenSparkProcContext)procContext;
        TableScanOperator tableScan = (TableScanOperator)nd;
        ParseContext parseContext = context.parseContext;
        Class<? extends InputFormat> inputFormat = ((TableScanDesc)tableScan.getConf()).getTableMetadata().getInputFormatClass();
        if (parseContext.getQueryProperties().isAnalyzeCommand()) {
            Preconditions.checkArgument(tableScan.getChildOperators() == null || tableScan.getChildOperators().size() == 0, "AssertionError: expected tableScan.getChildOperators() to be null, or tableScan.getChildOperators().size() to be 0");
            String alias = null;
            for (String a : parseContext.getTopOps().keySet()) {
                if (tableScan != parseContext.getTopOps().get(a)) continue;
                alias = a;
            }
            Preconditions.checkArgument(alias != null, "AssertionError: expected alias to be not null");
            SparkWork sparkWork = (SparkWork)context.currentTask.getWork();
            boolean partialScan = parseContext.getQueryProperties().isPartialScanAnalyzeCommand();
            boolean noScan = parseContext.getQueryProperties().isNoScanAnalyzeCommand();
            if (inputFormat.equals(OrcInputFormat.class) && (noScan || partialScan)) {
                StatsNoJobWork snjWork = new StatsNoJobWork(((TableScanDesc)tableScan.getConf()).getTableMetadata().getTableSpec());
                snjWork.setStatsReliable(parseContext.getConf().getBoolVar(HiveConf.ConfVars.HIVE_STATS_RELIABLE));
                Task<StatsNoJobWork> snjTask = TaskFactory.get(snjWork, parseContext.getConf(), new Task[0]);
                snjTask.setParentTasks(null);
                context.rootTasks.remove(context.currentTask);
                context.rootTasks.add(snjTask);
                return true;
            }
            StatsWork statsWork = new StatsWork(((TableScanDesc)tableScan.getConf()).getTableMetadata().getTableSpec());
            statsWork.setAggKey(((TableScanDesc)tableScan.getConf()).getStatsAggPrefix());
            statsWork.setSourceTask(context.currentTask);
            statsWork.setStatsReliable(parseContext.getConf().getBoolVar(HiveConf.ConfVars.HIVE_STATS_RELIABLE));
            Task<StatsWork> statsTask = TaskFactory.get(statsWork, parseContext.getConf(), new Task[0]);
            context.currentTask.addDependentTask(statsTask);
            if (parseContext.getQueryProperties().isNoScanAnalyzeCommand()) {
                statsTask.setParentTasks(null);
                statsWork.setNoScanAnalyzeCommand(true);
                context.rootTasks.remove(context.currentTask);
                context.rootTasks.add(statsTask);
            }
            if (parseContext.getQueryProperties().isPartialScanAnalyzeCommand()) {
                this.handlePartialScanCommand(tableScan, parseContext, statsWork, context, statsTask);
            }
            Set<Partition> confirmedPartns = GenMapRedUtils.getConfirmedPartitionsForScan(tableScan);
            PrunedPartitionList partitions = null;
            if (confirmedPartns.size() > 0) {
                Table source = ((TableScanDesc)tableScan.getConf()).getTableMetadata();
                List<String> partCols = GenMapRedUtils.getPartitionColumns(tableScan);
                partitions = new PrunedPartitionList(source, confirmedPartns, partCols, false);
            }
            MapWork w = this.utils.createMapWork(context, tableScan, sparkWork, partitions);
            w.setGatheringStats(true);
            return true;
        }
        return null;
    }

    private void handlePartialScanCommand(TableScanOperator tableScan, ParseContext parseContext, StatsWork statsWork, GenSparkProcContext context, Task<StatsWork> statsTask) throws SemanticException {
        String aggregationKey = ((TableScanDesc)tableScan.getConf()).getStatsAggPrefix();
        StringBuffer aggregationKeyBuffer = new StringBuffer(aggregationKey);
        List<Path> inputPaths = GenMapRedUtils.getInputPathsForPartialScan(tableScan, aggregationKeyBuffer);
        aggregationKey = aggregationKeyBuffer.toString();
        PartialScanWork scanWork = new PartialScanWork(inputPaths);
        scanWork.setMapperCannotSpanPartns(true);
        scanWork.setAggKey(aggregationKey);
        statsWork.setPartialScanAnalyzeCommand(true);
        DriverContext driverCxt = new DriverContext();
        Task<PartialScanWork> partialScanTask = TaskFactory.get(scanWork, parseContext.getConf(), new Task[0]);
        partialScanTask.initialize(parseContext.getConf(), null, driverCxt);
        partialScanTask.setWork(scanWork);
        statsWork.setSourceTask(partialScanTask);
        context.rootTasks.remove(context.currentTask);
        context.rootTasks.add(partialScanTask);
        partialScanTask.addDependentTask(statsTask);
    }
}

