/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.stats;

import com.facebook.presto.hive.$internal.com.google.common.collect.ImmutableList;
import java.lang.reflect.Method;
import java.util.List;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.metadata.ChainedRelMetadataProvider;
import org.apache.calcite.rel.metadata.ReflectiveRelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMdDistinctRowCount;
import org.apache.calcite.rel.metadata.RelMdUtil;
import org.apache.calcite.rel.metadata.RelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.util.BuiltInMethod;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveCalciteUtil;
import org.apache.hadoop.hive.ql.optimizer.calcite.cost.HiveCost;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveJoin;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveTableScan;
import org.apache.hadoop.hive.ql.plan.ColStatistics;

public class HiveRelMdDistinctRowCount
extends RelMdDistinctRowCount {
    private static final HiveRelMdDistinctRowCount INSTANCE = new HiveRelMdDistinctRowCount();
    public static final RelMetadataProvider SOURCE = ChainedRelMetadataProvider.of(ImmutableList.of(ReflectiveRelMetadataProvider.reflectiveSource((Method)BuiltInMethod.DISTINCT_ROW_COUNT.method, (Object)((Object)INSTANCE)), ReflectiveRelMetadataProvider.reflectiveSource((Method)BuiltInMethod.CUMULATIVE_COST.method, (Object)((Object)INSTANCE))));

    private HiveRelMdDistinctRowCount() {
    }

    public Double getDistinctRowCount(RelNode rel, ImmutableBitSet groupKey, RexNode predicate) {
        if (rel instanceof HiveTableScan) {
            return this.getDistinctRowCount((HiveTableScan)rel, groupKey, predicate);
        }
        return super.getDistinctRowCount(rel, groupKey, predicate);
    }

    private Double getDistinctRowCount(HiveTableScan htRel, ImmutableBitSet groupKey, RexNode predicate) {
        List<Integer> projIndxLst = HiveCalciteUtil.translateBitSetToProjIndx(groupKey);
        List<ColStatistics> colStats = htRel.getColStat(projIndxLst);
        Double noDistinctRows = 1.0;
        for (ColStatistics cStat : colStats) {
            noDistinctRows = noDistinctRows * (double)cStat.getCountDistint();
        }
        return Math.min(noDistinctRows, htRel.getRows());
    }

    public static Double getDistinctRowCount(RelNode r, int indx) {
        ImmutableBitSet bitSetOfRqdProj = ImmutableBitSet.of((int[])new int[]{indx});
        return RelMetadataQuery.getDistinctRowCount((RelNode)r, (ImmutableBitSet)bitSetOfRqdProj, (RexNode)r.getCluster().getRexBuilder().makeLiteral(true));
    }

    public Double getDistinctRowCount(Join rel, ImmutableBitSet groupKey, RexNode predicate) {
        if (rel instanceof HiveJoin) {
            HiveJoin hjRel = (HiveJoin)rel;
            if (hjRel.isLeftSemiJoin()) {
                return RelMetadataQuery.getDistinctRowCount((RelNode)hjRel.getLeft(), (ImmutableBitSet)groupKey, (RexNode)rel.getCluster().getRexBuilder().makeLiteral(true));
            }
            return RelMdUtil.getJoinDistinctRowCount((RelNode)rel, (JoinRelType)rel.getJoinType(), (ImmutableBitSet)groupKey, (RexNode)predicate, (boolean)true);
        }
        return RelMetadataQuery.getDistinctRowCount((RelNode)rel, (ImmutableBitSet)groupKey, (RexNode)predicate);
    }

    public RelOptCost getCumulativeCost(HiveJoin rel) {
        RelOptCost cost = RelMetadataQuery.getNonCumulativeCost((RelNode)rel);
        List inputs = rel.getInputs();
        HiveCost maxICost = HiveCost.ZERO;
        for (RelNode input : inputs) {
            RelOptCost iCost = RelMetadataQuery.getCumulativeCost((RelNode)input);
            if (!maxICost.isLt(iCost)) continue;
            maxICost = iCost;
        }
        return cost.plus((RelOptCost)maxICost);
    }
}

