/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.mr;

import com.facebook.presto.hive.$internal.org.apache.commons.logging.Log;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.exec.FetchOperator;
import org.apache.hadoop.hive.ql.exec.mr.ExecMapper;
import org.apache.hadoop.hive.ql.io.IOContext;
import org.apache.hadoop.hive.ql.plan.MapredLocalWork;
import org.apache.hadoop.mapred.JobConf;

public class ExecMapperContext {
    public static final Log l4j = ExecMapper.l4j;
    private Path lastInputPath = null;
    private Path currentInputPath = null;
    private boolean inputFileChecked = false;
    private String fileId = null;
    private MapredLocalWork localWork = null;
    private Map<String, FetchOperator> fetchOperators;
    private JobConf jc;
    private IOContext ioCxt;
    private String currentBigBucketFile = null;

    public String getCurrentBigBucketFile() {
        return this.currentBigBucketFile;
    }

    public void setCurrentBigBucketFile(String currentBigBucketFile) {
        this.currentBigBucketFile = currentBigBucketFile;
    }

    public ExecMapperContext(JobConf jc) {
        this.jc = jc;
        this.ioCxt = IOContext.get((Configuration)jc);
    }

    public void clear() {
        IOContext.clear();
        this.ioCxt = null;
    }

    public boolean inputFileChanged() {
        if (!this.inputFileChecked) {
            this.currentInputPath = this.ioCxt.getInputPath();
            this.inputFileChecked = true;
        }
        return this.lastInputPath == null || !this.lastInputPath.equals((Object)this.currentInputPath);
    }

    public void resetRow() {
        this.lastInputPath = this.currentInputPath;
        this.inputFileChecked = false;
    }

    public Path getLastInputPath() {
        return this.lastInputPath;
    }

    public void setLastInputPath(Path lastInputPath) {
        this.lastInputPath = lastInputPath;
    }

    public Path getCurrentInputPath() {
        this.currentInputPath = this.ioCxt.getInputPath();
        return this.currentInputPath;
    }

    public void setCurrentInputPath(Path currentInputPath) {
        this.currentInputPath = currentInputPath;
    }

    public JobConf getJc() {
        return this.jc;
    }

    public void setJc(JobConf jc) {
        this.jc = jc;
    }

    public MapredLocalWork getLocalWork() {
        return this.localWork;
    }

    public void setLocalWork(MapredLocalWork localWork) {
        this.localWork = localWork;
    }

    public String getFileId() {
        return this.fileId;
    }

    public void setFileId(String fileId) {
        this.fileId = fileId;
    }

    public Map<String, FetchOperator> getFetchOperators() {
        return this.fetchOperators;
    }

    public void setFetchOperators(Map<String, FetchOperator> fetchOperators) {
        this.fetchOperators = fetchOperators;
    }

    public IOContext getIoCxt() {
        return this.ioCxt;
    }

    public void setIoCxt(IOContext ioCxt) {
        this.ioCxt = ioCxt;
    }
}

