/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli.thrift;

import com.facebook.presto.hive.$internal.org.apache.hadoop.hive.conf.HiveConf;
import com.facebook.presto.hive.$internal.org.apache.thrift.TProcessorFactory;
import com.facebook.presto.hive.$internal.org.apache.thrift.protocol.TBinaryProtocol;
import com.facebook.presto.hive.$internal.org.apache.thrift.server.TThreadPoolServer;
import com.facebook.presto.hive.$internal.org.apache.thrift.transport.TServerSocket;
import com.facebook.presto.hive.$internal.org.apache.thrift.transport.TTransportFactory;
import java.net.InetSocketAddress;
import org.apache.hive.service.auth.HiveAuthFactory;
import org.apache.hive.service.cli.CLIService;
import org.apache.hive.service.cli.thrift.ThriftCLIService;

public class ThriftBinaryCLIService
extends ThriftCLIService {
    public ThriftBinaryCLIService(CLIService cliService) {
        super(cliService, "ThriftBinaryCLIService");
    }

    @Override
    public void run() {
        try {
            hiveAuthFactory = new HiveAuthFactory();
            TTransportFactory transportFactory = hiveAuthFactory.getAuthTransFactory();
            TProcessorFactory processorFactory = hiveAuthFactory.getAuthProcFactory(this);
            String portString = System.getenv("HIVE_SERVER2_THRIFT_PORT");
            this.portNum = portString != null ? Integer.valueOf(portString).intValue() : this.hiveConf.getIntVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_PORT);
            String hiveHost = System.getenv("HIVE_SERVER2_THRIFT_BIND_HOST");
            if (hiveHost == null) {
                hiveHost = this.hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_BIND_HOST);
            }
            this.serverAddress = hiveHost != null && !hiveHost.isEmpty() ? new InetSocketAddress(hiveHost, this.portNum) : new InetSocketAddress(this.portNum);
            this.minWorkerThreads = this.hiveConf.getIntVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_MIN_WORKER_THREADS);
            this.maxWorkerThreads = this.hiveConf.getIntVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_MAX_WORKER_THREADS);
            TServerSocket serverSocket = null;
            if (!this.hiveConf.getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_USE_SSL)) {
                serverSocket = HiveAuthFactory.getServerSocket(hiveHost, this.portNum);
            } else {
                String keyStorePath = this.hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_SSL_KEYSTORE_PATH).trim();
                if (keyStorePath.isEmpty()) {
                    throw new IllegalArgumentException(HiveConf.ConfVars.HIVE_SERVER2_SSL_KEYSTORE_PATH.varname + " Not configured for SSL connection");
                }
                serverSocket = HiveAuthFactory.getServerSSLSocket(hiveHost, this.portNum, keyStorePath, this.hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_SSL_KEYSTORE_PASSWORD));
            }
            TThreadPoolServer.Args sargs = ((TThreadPoolServer.Args)((TThreadPoolServer.Args)((TThreadPoolServer.Args)new TThreadPoolServer.Args(serverSocket).processorFactory(processorFactory)).transportFactory(transportFactory)).protocolFactory(new TBinaryProtocol.Factory())).minWorkerThreads(this.minWorkerThreads).maxWorkerThreads(this.maxWorkerThreads);
            this.server = new TThreadPoolServer(sargs);
            LOG.info("ThriftBinaryCLIService listening on " + this.serverAddress);
            this.server.serve();
        }
        catch (Throwable t) {
            LOG.error("Error: ", t);
        }
    }
}

