/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli.operation;

import com.facebook.presto.hive.;
import com.facebook.presto.hive.$internal.org.apache.hadoop.conf.Configuration;
import com.facebook.presto.hive.$internal.org.apache.hadoop.hive.conf.HiveConf;
import com.facebook.presto.hive.$internal.org.apache.hadoop.hive.shims.ShimLoader;
import com.facebook.presto.hive.$internal.org.apache.hadoop.io.BytesWritable;
import com.facebook.presto.hive.$internal.org.apache.hadoop.io.Writable;
import com.facebook.presto.hive.$internal.org.apache.hadoop.security.UserGroupInformation;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.PrivilegedExceptionAction;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import org.apache.hive.service.cli.FetchOrientation;
import org.apache.hive.service.cli.HiveSQLException;
import org.apache.hive.service.cli.OperationState;
import org.apache.hive.service.cli.RowSet;
import org.apache.hive.service.cli.RowSetFactory;
import org.apache.hive.service.cli.TableSchema;
import org.apache.hive.service.cli.operation.ExecuteStatementOperation;
import org.apache.hive.service.cli.operation.Operation;
import org.apache.hive.service.cli.session.HiveSession;

public class SQLOperation
extends ExecuteStatementOperation {
    private .Driver driver = null;
    private .CommandProcessorResponse response;
    private TableSchema resultSchema = null;
    private .Schema mResultSchema = null;
    private .SerDe serde = null;
    private boolean fetchStarted = false;
    private final transient List<Object> convey = new ArrayList<Object>();

    public SQLOperation(HiveSession parentSession, String statement, Map<String, String> confOverlay, boolean runInBackground) {
        super(parentSession, statement, confOverlay, runInBackground);
    }

    public void prepare(HiveConf sqlOperationConf) throws HiveSQLException {
        this.setState(OperationState.RUNNING);
        try {
            this.driver = new .Driver(sqlOperationConf, this.getParentSession().getUserName());
            this.driver.setTryCount(Integer.MAX_VALUE);
            String subStatement = new .VariableSubstitution().substitute(sqlOperationConf, this.statement);
            this.response = this.driver.compileAndRespond(subStatement);
            if (0 != this.response.getResponseCode()) {
                throw new HiveSQLException("Error while compiling statement: " + this.response.getErrorMessage(), this.response.getSQLState(), this.response.getResponseCode());
            }
            this.mResultSchema = this.driver.getSchema();
            if (this.driver.getPlan().getFetchTask() != null) {
                if (this.mResultSchema == null || !this.mResultSchema.isSetFieldSchemas()) {
                    throw new HiveSQLException("Error compiling query: Schema and FieldSchema should be set when query plan has a FetchTask");
                }
                this.resultSchema = new TableSchema(this.mResultSchema);
                this.setHasResultSet(true);
            } else {
                this.setHasResultSet(false);
            }
            for (.Task task : this.driver.getPlan().getRootTasks()) {
                if (task.getClass() != .ExplainTask.class) continue;
                this.resultSchema = new TableSchema(this.mResultSchema);
                this.setHasResultSet(true);
                break;
            }
        }
        catch (HiveSQLException e) {
            this.setState(OperationState.ERROR);
            throw e;
        }
        catch (Exception e) {
            this.setState(OperationState.ERROR);
            throw new HiveSQLException("Error running query: " + e.toString(), e);
        }
    }

    private void runInternal(HiveConf sqlOperationConf) throws HiveSQLException {
        try {
            this.driver.setTryCount(Integer.MAX_VALUE);
            this.response = this.driver.run();
            if (0 != this.response.getResponseCode()) {
                throw new HiveSQLException("Error while processing statement: " + this.response.getErrorMessage(), this.response.getSQLState(), this.response.getResponseCode());
            }
        }
        catch (HiveSQLException e) {
            if (this.getStatus().getState() == OperationState.CANCELED) {
                return;
            }
            this.setState(OperationState.ERROR);
            throw e;
        }
        catch (Exception e) {
            this.setState(OperationState.ERROR);
            throw new HiveSQLException("Error running query: " + e.toString(), e);
        }
        this.setState(OperationState.FINISHED);
    }

    @Override
    public void run() throws HiveSQLException {
        this.setState(OperationState.PENDING);
        final HiveConf opConfig = this.getConfigForOperation();
        this.prepare(opConfig);
        if (!this.shouldRunAsync()) {
            this.runInternal(opConfig);
        } else {
            final .SessionState parentSessionState = .SessionState.get();
            final .Hive sessionHive = this.getCurrentHive();
            final UserGroupInformation currentUGI = this.getCurrentUGI(opConfig);
            Runnable backgroundOperation = new Runnable(){

                @Override
                public void run() {
                    PrivilegedExceptionAction<Object> doAsAction = new PrivilegedExceptionAction<Object>(){

                        @Override
                        public Object run() throws HiveSQLException {
                            .Hive.set((.Hive)sessionHive);
                            .SessionState.setCurrentSessionState((.SessionState)parentSessionState);
                            try {
                                SQLOperation.this.runInternal(opConfig);
                            }
                            catch (HiveSQLException e) {
                                SQLOperation.this.setOperationException(e);
                                Operation.LOG.error("Error running hive query: ", e);
                            }
                            return null;
                        }
                    };
                    try {
                        ShimLoader.getHadoopShims().doAs(currentUGI, doAsAction);
                    }
                    catch (Exception e) {
                        SQLOperation.this.setOperationException(new HiveSQLException(e));
                        Operation.LOG.error("Error running hive query as user : " + currentUGI.getShortUserName(), e);
                    }
                }
            };
            try {
                Future<?> backgroundHandle = this.getParentSession().getSessionManager().submitBackgroundOperation(backgroundOperation);
                this.setBackgroundHandle(backgroundHandle);
            }
            catch (RejectedExecutionException rejected) {
                this.setState(OperationState.ERROR);
                throw new HiveSQLException("The background threadpool cannot accept new task for execution, please retry the operation", rejected);
            }
        }
    }

    private UserGroupInformation getCurrentUGI(HiveConf opConfig) throws HiveSQLException {
        try {
            return ShimLoader.getHadoopShims().getUGIForConf(opConfig);
        }
        catch (Exception e) {
            throw new HiveSQLException("Unable to get current user", e);
        }
    }

    private .Hive getCurrentHive() throws HiveSQLException {
        try {
            return .Hive.get();
        }
        catch (.HiveException e) {
            throw new HiveSQLException("Failed to get current Hive object", e);
        }
    }

    private void cleanup(OperationState state) throws HiveSQLException {
        Future<?> backgroundHandle;
        this.setState(state);
        if (this.shouldRunAsync() && (backgroundHandle = this.getBackgroundHandle()) != null) {
            backgroundHandle.cancel(true);
        }
        if (this.driver != null) {
            this.driver.close();
            this.driver.destroy();
        }
        this.driver = null;
        .SessionState ss = .SessionState.get();
        if (ss.getTmpOutputFile() != null) {
            ss.getTmpOutputFile().delete();
        }
    }

    @Override
    public void cancel() throws HiveSQLException {
        this.cleanup(OperationState.CANCELED);
    }

    @Override
    public void close() throws HiveSQLException {
        this.cleanup(OperationState.CLOSED);
    }

    @Override
    public TableSchema getResultSetSchema() throws HiveSQLException {
        this.assertState(OperationState.FINISHED);
        if (this.resultSchema == null) {
            this.resultSchema = new TableSchema(this.driver.getSchema());
        }
        return this.resultSchema;
    }

    @Override
    public RowSet getNextRowSet(FetchOrientation orientation, long maxRows) throws HiveSQLException {
        this.validateDefaultFetchOrientation(orientation);
        this.assertState(OperationState.FINISHED);
        RowSet rowSet = RowSetFactory.create(this.resultSchema, this.getProtocolVersion());
        try {
            if (orientation.equals((Object)FetchOrientation.FETCH_FIRST) && this.fetchStarted) {
                this.driver.resetFetch();
            }
            this.fetchStarted = true;
            this.driver.setMaxRows((int)maxRows);
            if (this.driver.getResults(this.convey)) {
                RowSet rowSet2 = this.decode(this.convey, rowSet);
                return rowSet2;
            }
            RowSet rowSet3 = rowSet;
            return rowSet3;
        }
        catch (IOException e) {
            throw new HiveSQLException(e);
        }
        catch (.CommandNeedRetryException e) {
            throw new HiveSQLException(e);
        }
        catch (Exception e) {
            throw new HiveSQLException(e);
        }
        finally {
            this.convey.clear();
        }
    }

    private RowSet decode(List<Object> rows, RowSet rowSet) throws Exception {
        if (this.driver.isFetchingTable()) {
            return this.prepareFromRow(rows, rowSet);
        }
        return this.decodeFromString(rows, rowSet);
    }

    private RowSet prepareFromRow(List<Object> rows, RowSet rowSet) throws Exception {
        for (Object row : rows) {
            rowSet.addRow((Object[])row);
        }
        return rowSet;
    }

    private RowSet decodeFromString(List<Object> rows, RowSet rowSet) throws SQLException, .SerDeException {
        this.getSerDe();
        .StructObjectInspector soi = (.StructObjectInspector)this.serde.getObjectInspector();
        List fieldRefs = soi.getAllStructFieldRefs();
        Object[] deserializedFields = new Object[fieldRefs.size()];
        int protocol = this.getProtocolVersion().getValue();
        for (Object rowString : rows) {
            Object rowObj;
            try {
                rowObj = this.serde.deserialize((Writable)new BytesWritable(((String)rowString).getBytes("UTF-8")));
            }
            catch (UnsupportedEncodingException e) {
                throw new .SerDeException((Throwable)e);
            }
            for (int i = 0; i < fieldRefs.size(); ++i) {
                .StructField fieldRef = (.StructField)fieldRefs.get(i);
                .ObjectInspector fieldOI = fieldRef.getFieldObjectInspector();
                Object fieldData = soi.getStructFieldData(rowObj, fieldRef);
                deserializedFields[i] = .SerDeUtils.toThriftPayload((Object)fieldData, (.ObjectInspector)fieldOI, (int)protocol);
            }
            rowSet.addRow(deserializedFields);
        }
        return rowSet;
    }

    private .SerDe getSerDe() throws SQLException {
        if (this.serde != null) {
            return this.serde;
        }
        try {
            List fieldSchemas = this.mResultSchema.getFieldSchemas();
            StringBuilder namesSb = new StringBuilder();
            StringBuilder typesSb = new StringBuilder();
            if (fieldSchemas != null && !fieldSchemas.isEmpty()) {
                for (int pos = 0; pos < fieldSchemas.size(); ++pos) {
                    if (pos != 0) {
                        namesSb.append(",");
                        typesSb.append(",");
                    }
                    namesSb.append(((.FieldSchema)fieldSchemas.get(pos)).getName());
                    typesSb.append(((.FieldSchema)fieldSchemas.get(pos)).getType());
                }
            }
            String names = namesSb.toString();
            String types = typesSb.toString();
            this.serde = new .LazySimpleSerDe();
            Properties props = new Properties();
            if (names.length() > 0) {
                LOG.debug("Column names: " + names);
                props.setProperty("columns", names);
            }
            if (types.length() > 0) {
                LOG.debug("Column types: " + types);
                props.setProperty("columns.types", types);
            }
            this.serde.initialize((Configuration)new HiveConf(), props);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new SQLException("Could not create ResultSet: " + ex.getMessage(), ex);
        }
        return this.serde;
    }

    private HiveConf getConfigForOperation() throws HiveSQLException {
        HiveConf sqlOperationConf = this.getParentSession().getHiveConf();
        if (!this.getConfOverlay().isEmpty() || this.shouldRunAsync()) {
            sqlOperationConf = new HiveConf(sqlOperationConf);
            for (Map.Entry<String, String> confEntry : this.getConfOverlay().entrySet()) {
                try {
                    sqlOperationConf.verifyAndSet(confEntry.getKey(), confEntry.getValue());
                }
                catch (IllegalArgumentException e) {
                    throw new HiveSQLException("Error applying statement specific settings", e);
                }
            }
        }
        return sqlOperationConf;
    }
}

