/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli.operation;

import com.facebook.presto.hive.;
import org.apache.hive.service.cli.FetchOrientation;
import org.apache.hive.service.cli.HiveSQLException;
import org.apache.hive.service.cli.OperationState;
import org.apache.hive.service.cli.OperationType;
import org.apache.hive.service.cli.RowSet;
import org.apache.hive.service.cli.RowSetFactory;
import org.apache.hive.service.cli.TableSchema;
import org.apache.hive.service.cli.operation.MetadataOperation;
import org.apache.hive.service.cli.session.HiveSession;

public class GetSchemasOperation
extends MetadataOperation {
    private final String catalogName;
    private final String schemaName;
    private static final TableSchema RESULT_SET_SCHEMA = new TableSchema().addStringColumn("TABLE_SCHEM", "Schema name.").addStringColumn("TABLE_CATALOG", "Catalog name.");
    private RowSet rowSet;

    protected GetSchemasOperation(HiveSession parentSession, String catalogName, String schemaName) {
        super(parentSession, OperationType.GET_SCHEMAS);
        this.catalogName = catalogName;
        this.schemaName = schemaName;
        this.rowSet = RowSetFactory.create(RESULT_SET_SCHEMA, this.getProtocolVersion());
    }

    @Override
    public void run() throws HiveSQLException {
        this.setState(OperationState.RUNNING);
        try {
            .IMetaStoreClient metastoreClient = this.getParentSession().getMetaStoreClient();
            String schemaPattern = this.convertSchemaPattern(this.schemaName);
            for (String dbName : metastoreClient.getDatabases(schemaPattern)) {
                this.rowSet.addRow(new Object[]{dbName, ""});
            }
            this.setState(OperationState.FINISHED);
        }
        catch (Exception e) {
            this.setState(OperationState.ERROR);
            throw new HiveSQLException(e);
        }
    }

    @Override
    public TableSchema getResultSetSchema() throws HiveSQLException {
        this.assertState(OperationState.FINISHED);
        return RESULT_SET_SCHEMA;
    }

    @Override
    public RowSet getNextRowSet(FetchOrientation orientation, long maxRows) throws HiveSQLException {
        this.assertState(OperationState.FINISHED);
        this.validateDefaultFetchOrientation(orientation);
        if (orientation.equals((Object)FetchOrientation.FETCH_FIRST)) {
            this.rowSet.setStartOffset(0L);
        }
        return this.rowSet.extractSubset((int)maxRows);
    }
}

