/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli;

import com.facebook.presto.hive.;
import com.facebook.presto.hive.$internal.org.apache.commons.logging.Log;
import com.facebook.presto.hive.$internal.org.apache.commons.logging.LogFactory;
import com.facebook.presto.hive.$internal.org.apache.hadoop.fs.FileSystem;
import com.facebook.presto.hive.$internal.org.apache.hadoop.fs.Path;
import com.facebook.presto.hive.$internal.org.apache.hadoop.fs.permission.FsPermission;
import com.facebook.presto.hive.$internal.org.apache.hadoop.hive.conf.HiveConf;
import com.facebook.presto.hive.$internal.org.apache.hadoop.hive.shims.ShimLoader;
import com.facebook.presto.hive.$internal.org.apache.hadoop.security.UserGroupInformation;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.security.auth.login.LoginException;
import org.apache.hive.service.CompositeService;
import org.apache.hive.service.ServiceException;
import org.apache.hive.service.auth.HiveAuthFactory;
import org.apache.hive.service.cli.FetchOrientation;
import org.apache.hive.service.cli.GetInfoType;
import org.apache.hive.service.cli.GetInfoValue;
import org.apache.hive.service.cli.HiveSQLException;
import org.apache.hive.service.cli.ICLIService;
import org.apache.hive.service.cli.OperationHandle;
import org.apache.hive.service.cli.OperationStatus;
import org.apache.hive.service.cli.RowSet;
import org.apache.hive.service.cli.SessionHandle;
import org.apache.hive.service.cli.TableSchema;
import org.apache.hive.service.cli.operation.Operation;
import org.apache.hive.service.cli.session.SessionManager;
import org.apache.hive.service.cli.thrift.TProtocolVersion;

public class CLIService
extends CompositeService
implements ICLIService {
    public static final TProtocolVersion SERVER_VERSION;
    private final Log LOG = LogFactory.getLog(CLIService.class.getName());
    private HiveConf hiveConf;
    private SessionManager sessionManager;
    private .IMetaStoreClient metastoreClient;
    private UserGroupInformation serviceUGI;
    private UserGroupInformation httpUGI;

    public CLIService() {
        super("CLIService");
    }

    @Override
    public synchronized void init(HiveConf hiveConf) {
        this.hiveConf = hiveConf;
        this.sessionManager = new SessionManager();
        this.addService(this.sessionManager);
        if (hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_AUTHENTICATION).equalsIgnoreCase(HiveAuthFactory.AuthTypes.KERBEROS.toString())) {
            try {
                HiveAuthFactory.loginFromKeytab(hiveConf);
                this.serviceUGI = ShimLoader.getHadoopShims().getUGIForConf(hiveConf);
            }
            catch (IOException e) {
                throw new ServiceException("Unable to login to kerberos with given principal/keytab", e);
            }
            catch (LoginException e) {
                throw new ServiceException("Unable to login to kerberos with given principal/keytab", e);
            }
            String principal = hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_SPNEGO_PRINCIPAL);
            String keyTabFile = hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_SPNEGO_KEYTAB);
            if (principal.isEmpty() || keyTabFile.isEmpty()) {
                this.LOG.info("SPNego httpUGI not created, spNegoPrincipal: " + principal + ", ketabFile: " + keyTabFile);
            } else {
                try {
                    this.httpUGI = HiveAuthFactory.loginFromSpnegoKeytabAndReturnUGI(hiveConf);
                    this.LOG.info("SPNego httpUGI successfully created.");
                }
                catch (IOException e) {
                    this.LOG.warn("SPNego httpUGI creation failed: ", e);
                }
            }
        }
        super.init(hiveConf);
    }

    public UserGroupInformation getServiceUGI() {
        return this.serviceUGI;
    }

    public UserGroupInformation getHttpUGI() {
        return this.httpUGI;
    }

    @Override
    public synchronized void start() {
        super.start();
        try {
            this.setupStagingDir(this.hiveConf.getVar(HiveConf.ConfVars.SCRATCHDIR), false);
            this.setupStagingDir(this.hiveConf.getVar(HiveConf.ConfVars.LOCALSCRATCHDIR), true);
            this.setupStagingDir(this.hiveConf.getVar(HiveConf.ConfVars.DOWNLOADED_RESOURCES_DIR), true);
        }
        catch (IOException eIO) {
            throw new ServiceException("Error setting stage directories", eIO);
        }
        try {
            this.metastoreClient = new .HiveMetaStoreClient(this.hiveConf);
            this.metastoreClient.getDatabases("default");
        }
        catch (Exception e) {
            throw new ServiceException("Unable to connect to MetaStore!", e);
        }
    }

    @Override
    public synchronized void stop() {
        if (this.metastoreClient != null) {
            this.metastoreClient.close();
        }
        super.stop();
    }

    public SessionHandle openSession(TProtocolVersion protocol, String username, String password, Map<String, String> configuration) throws HiveSQLException {
        SessionHandle sessionHandle = this.sessionManager.openSession(protocol, username, password, configuration, false, null);
        this.LOG.debug(sessionHandle + ": openSession()");
        return sessionHandle;
    }

    public SessionHandle openSessionWithImpersonation(TProtocolVersion protocol, String username, String password, Map<String, String> configuration, String delegationToken) throws HiveSQLException {
        SessionHandle sessionHandle = this.sessionManager.openSession(protocol, username, password, configuration, true, delegationToken);
        this.LOG.debug(sessionHandle + ": openSession()");
        return sessionHandle;
    }

    @Override
    public SessionHandle openSession(String username, String password, Map<String, String> configuration) throws HiveSQLException {
        SessionHandle sessionHandle = this.sessionManager.openSession(SERVER_VERSION, username, password, configuration, false, null);
        this.LOG.debug(sessionHandle + ": openSession()");
        return sessionHandle;
    }

    @Override
    public SessionHandle openSessionWithImpersonation(String username, String password, Map<String, String> configuration, String delegationToken) throws HiveSQLException {
        SessionHandle sessionHandle = this.sessionManager.openSession(SERVER_VERSION, username, password, configuration, true, delegationToken);
        this.LOG.debug(sessionHandle + ": openSession()");
        return sessionHandle;
    }

    @Override
    public void closeSession(SessionHandle sessionHandle) throws HiveSQLException {
        this.sessionManager.closeSession(sessionHandle);
        this.LOG.debug(sessionHandle + ": closeSession()");
    }

    @Override
    public GetInfoValue getInfo(SessionHandle sessionHandle, GetInfoType getInfoType) throws HiveSQLException {
        GetInfoValue infoValue = this.sessionManager.getSession(sessionHandle).getInfo(getInfoType);
        this.LOG.debug(sessionHandle + ": getInfo()");
        return infoValue;
    }

    @Override
    public OperationHandle executeStatement(SessionHandle sessionHandle, String statement, Map<String, String> confOverlay) throws HiveSQLException {
        OperationHandle opHandle = this.sessionManager.getSession(sessionHandle).executeStatement(statement, confOverlay);
        this.LOG.debug(sessionHandle + ": executeStatement()");
        return opHandle;
    }

    @Override
    public OperationHandle executeStatementAsync(SessionHandle sessionHandle, String statement, Map<String, String> confOverlay) throws HiveSQLException {
        OperationHandle opHandle = this.sessionManager.getSession(sessionHandle).executeStatementAsync(statement, confOverlay);
        this.LOG.debug(sessionHandle + ": executeStatementAsync()");
        return opHandle;
    }

    @Override
    public OperationHandle getTypeInfo(SessionHandle sessionHandle) throws HiveSQLException {
        OperationHandle opHandle = this.sessionManager.getSession(sessionHandle).getTypeInfo();
        this.LOG.debug(sessionHandle + ": getTypeInfo()");
        return opHandle;
    }

    @Override
    public OperationHandle getCatalogs(SessionHandle sessionHandle) throws HiveSQLException {
        OperationHandle opHandle = this.sessionManager.getSession(sessionHandle).getCatalogs();
        this.LOG.debug(sessionHandle + ": getCatalogs()");
        return opHandle;
    }

    @Override
    public OperationHandle getSchemas(SessionHandle sessionHandle, String catalogName, String schemaName) throws HiveSQLException {
        OperationHandle opHandle = this.sessionManager.getSession(sessionHandle).getSchemas(catalogName, schemaName);
        this.LOG.debug(sessionHandle + ": getSchemas()");
        return opHandle;
    }

    @Override
    public OperationHandle getTables(SessionHandle sessionHandle, String catalogName, String schemaName, String tableName, List<String> tableTypes) throws HiveSQLException {
        OperationHandle opHandle = this.sessionManager.getSession(sessionHandle).getTables(catalogName, schemaName, tableName, tableTypes);
        this.LOG.debug(sessionHandle + ": getTables()");
        return opHandle;
    }

    @Override
    public OperationHandle getTableTypes(SessionHandle sessionHandle) throws HiveSQLException {
        OperationHandle opHandle = this.sessionManager.getSession(sessionHandle).getTableTypes();
        this.LOG.debug(sessionHandle + ": getTableTypes()");
        return opHandle;
    }

    @Override
    public OperationHandle getColumns(SessionHandle sessionHandle, String catalogName, String schemaName, String tableName, String columnName) throws HiveSQLException {
        OperationHandle opHandle = this.sessionManager.getSession(sessionHandle).getColumns(catalogName, schemaName, tableName, columnName);
        this.LOG.debug(sessionHandle + ": getColumns()");
        return opHandle;
    }

    @Override
    public OperationHandle getFunctions(SessionHandle sessionHandle, String catalogName, String schemaName, String functionName) throws HiveSQLException {
        OperationHandle opHandle = this.sessionManager.getSession(sessionHandle).getFunctions(catalogName, schemaName, functionName);
        this.LOG.debug(sessionHandle + ": getFunctions()");
        return opHandle;
    }

    @Override
    public OperationStatus getOperationStatus(OperationHandle opHandle) throws HiveSQLException {
        Operation operation = this.sessionManager.getOperationManager().getOperation(opHandle);
        if (operation.shouldRunAsync()) {
            long timeout = operation.getParentSession().getHiveConf().getLongVar(HiveConf.ConfVars.HIVE_SERVER2_LONG_POLLING_TIMEOUT);
            try {
                operation.getBackgroundHandle().get(timeout, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException e) {
                this.LOG.trace(opHandle + ": Long polling timed out");
            }
            catch (CancellationException e) {
                this.LOG.trace(opHandle + ": The background operation was cancelled", e);
            }
            catch (ExecutionException e) {
                this.LOG.trace(opHandle + ": The background operation was aborted", e);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        OperationStatus opStatus = operation.getStatus();
        this.LOG.debug(opHandle + ": getOperationStatus()");
        return opStatus;
    }

    @Override
    public void cancelOperation(OperationHandle opHandle) throws HiveSQLException {
        this.sessionManager.getOperationManager().getOperation(opHandle).getParentSession().cancelOperation(opHandle);
        this.LOG.debug(opHandle + ": cancelOperation()");
    }

    @Override
    public void closeOperation(OperationHandle opHandle) throws HiveSQLException {
        this.sessionManager.getOperationManager().getOperation(opHandle).getParentSession().closeOperation(opHandle);
        this.LOG.debug(opHandle + ": closeOperation");
    }

    @Override
    public TableSchema getResultSetMetadata(OperationHandle opHandle) throws HiveSQLException {
        TableSchema tableSchema = this.sessionManager.getOperationManager().getOperation(opHandle).getParentSession().getResultSetMetadata(opHandle);
        this.LOG.debug(opHandle + ": getResultSetMetadata()");
        return tableSchema;
    }

    @Override
    public RowSet fetchResults(OperationHandle opHandle, FetchOrientation orientation, long maxRows) throws HiveSQLException {
        RowSet rowSet = this.sessionManager.getOperationManager().getOperation(opHandle).getParentSession().fetchResults(opHandle, orientation, maxRows);
        this.LOG.debug(opHandle + ": fetchResults()");
        return rowSet;
    }

    @Override
    public RowSet fetchResults(OperationHandle opHandle) throws HiveSQLException {
        RowSet rowSet = this.sessionManager.getOperationManager().getOperation(opHandle).getParentSession().fetchResults(opHandle);
        this.LOG.debug(opHandle + ": fetchResults()");
        return rowSet;
    }

    public synchronized String getDelegationTokenFromMetaStore(String owner) throws HiveSQLException, UnsupportedOperationException, LoginException, IOException {
        if (!this.hiveConf.getBoolVar(HiveConf.ConfVars.METASTORE_USE_THRIFT_SASL) || !this.hiveConf.getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_ENABLE_DOAS)) {
            throw new UnsupportedOperationException("delegation token is can only be obtained for a secure remote metastore");
        }
        try {
            .Hive.closeCurrent();
            return .Hive.get((HiveConf)this.hiveConf).getDelegationToken(owner, owner);
        }
        catch (.HiveException e) {
            if (e.getCause() instanceof UnsupportedOperationException) {
                throw (UnsupportedOperationException)e.getCause();
            }
            throw new HiveSQLException("Error connect metastore to setup impersonation", e);
        }
    }

    private void setupStagingDir(String dirPath, boolean isLocal) throws IOException {
        Path scratchDir;
        FileSystem fs = isLocal ? FileSystem.getLocal(this.hiveConf) : scratchDir.getFileSystem(this.hiveConf);
        if (!fs.exists(scratchDir = new Path(dirPath))) {
            fs.mkdirs(scratchDir);
            FsPermission fsPermission = new FsPermission(511);
            fs.setPermission(scratchDir, fsPermission);
        }
    }

    @Override
    public String getDelegationToken(SessionHandle sessionHandle, HiveAuthFactory authFactory, String owner, String renewer) throws HiveSQLException {
        String delegationToken = this.sessionManager.getSession(sessionHandle).getDelegationToken(authFactory, owner, renewer);
        this.LOG.info(sessionHandle + ": getDelegationToken()");
        return delegationToken;
    }

    @Override
    public void cancelDelegationToken(SessionHandle sessionHandle, HiveAuthFactory authFactory, String tokenStr) throws HiveSQLException {
        this.sessionManager.getSession(sessionHandle).cancelDelegationToken(authFactory, tokenStr);
        this.LOG.info(sessionHandle + ": cancelDelegationToken()");
    }

    @Override
    public void renewDelegationToken(SessionHandle sessionHandle, HiveAuthFactory authFactory, String tokenStr) throws HiveSQLException {
        this.sessionManager.getSession(sessionHandle).renewDelegationToken(authFactory, tokenStr);
        this.LOG.info(sessionHandle + ": renewDelegationToken()");
    }

    static {
        TProtocolVersion[] protocols = TProtocolVersion.values();
        SERVER_VERSION = protocols[protocols.length - 1];
    }
}

