/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.auth;

import com.facebook.presto.hive.$internal.net.sf.jpam.Pam;
import com.facebook.presto.hive.$internal.org.apache.hadoop.hive.conf.HiveConf;
import javax.security.sasl.AuthenticationException;
import org.apache.hive.service.auth.PasswdAuthenticationProvider;

public class PamAuthenticationProviderImpl
implements PasswdAuthenticationProvider {
    private final String pamServiceNames;

    PamAuthenticationProviderImpl() {
        HiveConf conf = new HiveConf();
        this.pamServiceNames = conf.getVar(HiveConf.ConfVars.HIVE_SERVER2_PAM_SERVICES);
    }

    @Override
    public void Authenticate(String user, String password) throws AuthenticationException {
        String[] pamServices;
        if (this.pamServiceNames == null || this.pamServiceNames.trim().isEmpty()) {
            throw new AuthenticationException("No PAM services are set.");
        }
        for (String pamService : pamServices = this.pamServiceNames.split(",")) {
            Pam pam = new Pam(pamService);
            boolean isAuthenticated = pam.authenticateSuccessful(user, password);
            if (isAuthenticated) continue;
            throw new AuthenticationException("Error authenticating with the PAM service: " + pamService);
        }
    }
}

