/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.auth;

import com.facebook.presto.hive.$internal.org.apache.hadoop.hive.conf.HiveConf;
import java.util.Hashtable;
import javax.naming.NamingException;
import javax.naming.directory.InitialDirContext;
import javax.security.sasl.AuthenticationException;
import org.apache.hive.service.auth.PasswdAuthenticationProvider;

public class LdapAuthenticationProviderImpl
implements PasswdAuthenticationProvider {
    private final String ldapURL;
    private final String baseDN;
    private final String ldapDomain;

    LdapAuthenticationProviderImpl() {
        HiveConf conf = new HiveConf();
        this.ldapURL = conf.getVar(HiveConf.ConfVars.HIVE_SERVER2_PLAIN_LDAP_URL);
        this.baseDN = conf.getVar(HiveConf.ConfVars.HIVE_SERVER2_PLAIN_LDAP_BASEDN);
        this.ldapDomain = conf.getVar(HiveConf.ConfVars.HIVE_SERVER2_PLAIN_LDAP_DOMAIN);
    }

    @Override
    public void Authenticate(String user, String password) throws AuthenticationException {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", this.ldapURL);
        if (this.ldapDomain != null) {
            user = user + "@" + this.ldapDomain;
        }
        String bindDN = this.baseDN != null ? "uid=" + user + "," + this.baseDN : user;
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.security.principal", bindDN);
        env.put("java.naming.security.credentials", password);
        try {
            InitialDirContext ctx = new InitialDirContext(env);
            ctx.close();
        }
        catch (NamingException e) {
            throw new AuthenticationException("Error validating LDAP user", e);
        }
    }
}

