/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.$internal.org.apache.hadoop.util;

import com.facebook.presto.hive.$internal.org.apache.commons.logging.Log;
import com.facebook.presto.hive.$internal.org.apache.hadoop.fs.Path;
import com.facebook.presto.hive.$internal.org.apache.hadoop.util.VersionInfo;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;
import java.util.StringTokenizer;

public class StringUtils {
    private static final DecimalFormat decimalFormat;
    private static DecimalFormat oneDecimal;
    public static final char COMMA = ',';
    public static final String COMMA_STR = ",";
    public static final char ESCAPE_CHAR = '\\';

    public static String stringifyException(Throwable e) {
        StringWriter stm = new StringWriter();
        PrintWriter wrt = new PrintWriter(stm);
        e.printStackTrace(wrt);
        wrt.close();
        return stm.toString();
    }

    public static String simpleHostname(String fullHostname) {
        int offset = fullHostname.indexOf(46);
        if (offset != -1) {
            return fullHostname.substring(0, offset);
        }
        return fullHostname;
    }

    public static String humanReadableInt(long number) {
        long absNumber = Math.abs(number);
        double result = number;
        String suffix = "";
        if (absNumber >= 1024L) {
            if (absNumber < 0x100000L) {
                result = (double)number / 1024.0;
                suffix = "k";
            } else if (absNumber < 0x40000000L) {
                result = (double)number / 1048576.0;
                suffix = "m";
            } else {
                result = (double)number / 1.073741824E9;
                suffix = "g";
            }
        }
        return oneDecimal.format(result) + suffix;
    }

    public static String formatPercent(double done, int digits) {
        DecimalFormat percentFormat = new DecimalFormat("0.00%");
        double scale = Math.pow(10.0, digits + 2);
        double rounded = Math.floor(done * scale);
        percentFormat.setDecimalSeparatorAlwaysShown(false);
        percentFormat.setMinimumFractionDigits(digits);
        percentFormat.setMaximumFractionDigits(digits);
        return percentFormat.format(rounded / scale);
    }

    public static String arrayToString(String[] strs) {
        if (strs.length == 0) {
            return "";
        }
        StringBuffer sbuf = new StringBuffer();
        sbuf.append(strs[0]);
        for (int idx = 1; idx < strs.length; ++idx) {
            sbuf.append(COMMA_STR);
            sbuf.append(strs[idx]);
        }
        return sbuf.toString();
    }

    public static String byteToHexString(byte[] bytes, int start, int end) {
        if (bytes == null) {
            throw new IllegalArgumentException("bytes == null");
        }
        StringBuilder s = new StringBuilder();
        for (int i = start; i < end; ++i) {
            s.append(String.format("%02x", bytes[i]));
        }
        return s.toString();
    }

    public static String byteToHexString(byte[] bytes) {
        return StringUtils.byteToHexString(bytes, 0, bytes.length);
    }

    public static byte[] hexStringToByte(String hex) {
        byte[] bts = new byte[hex.length() / 2];
        for (int i = 0; i < bts.length; ++i) {
            bts[i] = (byte)Integer.parseInt(hex.substring(2 * i, 2 * i + 2), 16);
        }
        return bts;
    }

    public static String uriToString(URI[] uris) {
        if (uris == null) {
            return null;
        }
        StringBuffer ret = new StringBuffer(uris[0].toString());
        for (int i = 1; i < uris.length; ++i) {
            ret.append(COMMA_STR);
            ret.append(uris[i].toString());
        }
        return ret.toString();
    }

    public static URI[] stringToURI(String[] str) {
        if (str == null) {
            return null;
        }
        URI[] uris = new URI[str.length];
        for (int i = 0; i < str.length; ++i) {
            try {
                uris[i] = new URI(str[i]);
                continue;
            }
            catch (URISyntaxException ur) {
                System.out.println("Exception in specified URI's " + StringUtils.stringifyException(ur));
                uris[i] = null;
            }
        }
        return uris;
    }

    public static Path[] stringToPath(String[] str) {
        if (str == null) {
            return null;
        }
        Path[] p = new Path[str.length];
        for (int i = 0; i < str.length; ++i) {
            p[i] = new Path(str[i]);
        }
        return p;
    }

    public static String formatTimeDiff(long finishTime, long startTime) {
        long timeDiff = finishTime - startTime;
        return StringUtils.formatTime(timeDiff);
    }

    public static String formatTime(long timeDiff) {
        StringBuffer buf = new StringBuffer();
        long hours = timeDiff / 3600000L;
        long rem = timeDiff % 3600000L;
        long minutes = rem / 60000L;
        long seconds = (rem %= 60000L) / 1000L;
        if (hours != 0L) {
            buf.append(hours);
            buf.append("hrs, ");
        }
        if (minutes != 0L) {
            buf.append(minutes);
            buf.append("mins, ");
        }
        buf.append(seconds);
        buf.append("sec");
        return buf.toString();
    }

    public static String getFormattedTimeWithDiff(DateFormat dateFormat, long finishTime, long startTime) {
        StringBuffer buf = new StringBuffer();
        if (0L != finishTime) {
            buf.append(dateFormat.format(new Date(finishTime)));
            if (0L != startTime) {
                buf.append(" (" + StringUtils.formatTimeDiff(finishTime, startTime) + ")");
            }
        }
        return buf.toString();
    }

    public static String[] getStrings(String str) {
        Collection<String> values = StringUtils.getStringCollection(str);
        if (values.size() == 0) {
            return null;
        }
        return values.toArray(new String[values.size()]);
    }

    public static Collection<String> getStringCollection(String str) {
        ArrayList<String> values = new ArrayList<String>();
        if (str == null) {
            return values;
        }
        StringTokenizer tokenizer = new StringTokenizer(str, COMMA_STR);
        values = new ArrayList();
        while (tokenizer.hasMoreTokens()) {
            values.add(tokenizer.nextToken());
        }
        return values;
    }

    public static String[] split(String str) {
        return StringUtils.split(str, '\\', ',');
    }

    public static String[] split(String str, char escapeChar, char separator) {
        if (str == null) {
            return null;
        }
        ArrayList<String> strList = new ArrayList<String>();
        StringBuilder split = new StringBuilder();
        int index = 0;
        while ((index = StringUtils.findNext(str, separator, escapeChar, index, split)) >= 0) {
            ++index;
            strList.add(split.toString());
            split.setLength(0);
        }
        strList.add(split.toString());
        int last = strList.size();
        while (--last >= 0 && "".equals(strList.get(last))) {
            strList.remove(last);
        }
        return strList.toArray(new String[strList.size()]);
    }

    public static int findNext(String str, char separator, char escapeChar, int start, StringBuilder split) {
        int numPreEscapes = 0;
        for (int i = start; i < str.length(); ++i) {
            char curChar = str.charAt(i);
            if (numPreEscapes == 0 && curChar == separator) {
                return i;
            }
            split.append(curChar);
            numPreEscapes = curChar == escapeChar ? ++numPreEscapes % 2 : 0;
        }
        return -1;
    }

    public static String escapeString(String str) {
        return StringUtils.escapeString(str, '\\', ',');
    }

    public static String escapeString(String str, char escapeChar, char charToEscape) {
        return StringUtils.escapeString(str, escapeChar, new char[]{charToEscape});
    }

    private static boolean hasChar(char[] chars, char character) {
        for (char target : chars) {
            if (character != target) continue;
            return true;
        }
        return false;
    }

    public static String escapeString(String str, char escapeChar, char[] charsToEscape) {
        if (str == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            char curChar = str.charAt(i);
            if (curChar == escapeChar || StringUtils.hasChar(charsToEscape, curChar)) {
                result.append(escapeChar);
            }
            result.append(curChar);
        }
        return result.toString();
    }

    public static String unEscapeString(String str) {
        return StringUtils.unEscapeString(str, '\\', ',');
    }

    public static String unEscapeString(String str, char escapeChar, char charToEscape) {
        return StringUtils.unEscapeString(str, escapeChar, new char[]{charToEscape});
    }

    public static String unEscapeString(String str, char escapeChar, char[] charsToEscape) {
        if (str == null) {
            return null;
        }
        StringBuilder result = new StringBuilder(str.length());
        boolean hasPreEscape = false;
        for (int i = 0; i < str.length(); ++i) {
            char curChar = str.charAt(i);
            if (hasPreEscape) {
                if (curChar != escapeChar && !StringUtils.hasChar(charsToEscape, curChar)) {
                    throw new IllegalArgumentException("Illegal escaped string " + str + " unescaped " + escapeChar + " at " + (i - 1));
                }
                result.append(curChar);
                hasPreEscape = false;
                continue;
            }
            if (StringUtils.hasChar(charsToEscape, curChar)) {
                throw new IllegalArgumentException("Illegal escaped string " + str + " unescaped " + curChar + " at " + i);
            }
            if (curChar == escapeChar) {
                hasPreEscape = true;
                continue;
            }
            result.append(curChar);
        }
        if (hasPreEscape) {
            throw new IllegalArgumentException("Illegal escaped string " + str + ", not expecting " + escapeChar + " in the end.");
        }
        return result.toString();
    }

    public static String getHostname() {
        try {
            return "" + InetAddress.getLocalHost();
        }
        catch (UnknownHostException uhe) {
            return "" + uhe;
        }
    }

    private static String toStartupShutdownString(String prefix, String[] msg) {
        StringBuffer b = new StringBuffer(prefix);
        b.append("\n/************************************************************");
        for (String s : msg) {
            b.append("\n" + prefix + s);
        }
        b.append("\n************************************************************/");
        return b.toString();
    }

    public static void startupShutdownMessage(Class<?> clazz, String[] args, final Log LOG) {
        final String hostname = StringUtils.getHostname();
        final String classname = clazz.getSimpleName();
        LOG.info(StringUtils.toStartupShutdownString("STARTUP_MSG: ", new String[]{"Starting " + classname, "  host = " + hostname, "  args = " + Arrays.asList(args), "  version = " + VersionInfo.getVersion(), "  build = " + VersionInfo.getUrl() + " -r " + VersionInfo.getRevision() + "; compiled by '" + VersionInfo.getUser() + "' on " + VersionInfo.getDate()}));
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                LOG.info(StringUtils.toStartupShutdownString("SHUTDOWN_MSG: ", new String[]{"Shutting down " + classname + " at " + hostname}));
            }
        });
    }

    public static String escapeHTML(String string) {
        char[] chars;
        if (string == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        boolean lastCharacterWasSpace = false;
        block6: for (char c : chars = string.toCharArray()) {
            if (c == ' ') {
                if (lastCharacterWasSpace) {
                    lastCharacterWasSpace = false;
                    sb.append("&nbsp;");
                    continue;
                }
                lastCharacterWasSpace = true;
                sb.append(" ");
                continue;
            }
            lastCharacterWasSpace = false;
            switch (c) {
                case '<': {
                    sb.append("&lt;");
                    continue block6;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block6;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block6;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static String byteDesc(long len) {
        double val = 0.0;
        String ending = "";
        if (len < 0x100000L) {
            val = 1.0 * (double)len / 1024.0;
            ending = " KB";
        } else if (len < 0x40000000L) {
            val = 1.0 * (double)len / 1048576.0;
            ending = " MB";
        } else if (len < 0x10000000000L) {
            val = 1.0 * (double)len / 1.073741824E9;
            ending = " GB";
        } else if (len < 0x4000000000000L) {
            val = 1.0 * (double)len / 1.099511627776E12;
            ending = " TB";
        } else {
            val = 1.0 * (double)len / 1.125899906842624E15;
            ending = " PB";
        }
        return StringUtils.limitDecimalTo2(val) + ending;
    }

    public static synchronized String limitDecimalTo2(double d) {
        return decimalFormat.format(d);
    }

    static {
        NumberFormat numberFormat = NumberFormat.getNumberInstance(Locale.ENGLISH);
        decimalFormat = (DecimalFormat)numberFormat;
        decimalFormat.applyPattern("#.##");
        oneDecimal = new DecimalFormat("0.0");
    }

    public static enum TraditionalBinaryPrefix {
        KILO(1024L),
        MEGA(TraditionalBinaryPrefix.KILO.value << 10),
        GIGA(TraditionalBinaryPrefix.MEGA.value << 10),
        TERA(TraditionalBinaryPrefix.GIGA.value << 10),
        PETA(TraditionalBinaryPrefix.TERA.value << 10),
        EXA(TraditionalBinaryPrefix.PETA.value << 10);

        public final long value;
        public final char symbol;

        private TraditionalBinaryPrefix(long value) {
            this.value = value;
            this.symbol = this.toString().charAt(0);
        }

        public static TraditionalBinaryPrefix valueOf(char symbol) {
            symbol = Character.toUpperCase(symbol);
            for (TraditionalBinaryPrefix prefix : TraditionalBinaryPrefix.values()) {
                if (symbol != prefix.symbol) continue;
                return prefix;
            }
            throw new IllegalArgumentException("Unknown symbol '" + symbol + "'");
        }

        public static long string2long(String s) {
            int lastpos;
            char lastchar = (s = s.trim()).charAt(lastpos = s.length() - 1);
            if (Character.isDigit(lastchar)) {
                return Long.parseLong(s);
            }
            long prefix = TraditionalBinaryPrefix.valueOf((char)lastchar).value;
            long num = Long.parseLong(s.substring(0, lastpos));
            if (num > Long.MAX_VALUE / prefix || num < Long.MIN_VALUE / prefix) {
                throw new IllegalArgumentException(s + " does not fit in a Long");
            }
            return num * prefix;
        }
    }
}

