/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.$internal.org.apache.hadoop.util;

import com.facebook.presto.hive.$internal.org.apache.commons.logging.Log;
import com.facebook.presto.hive.$internal.org.apache.commons.logging.LogFactory;
import com.facebook.presto.hive.$internal.org.apache.hadoop.util.Shell;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ProcfsBasedProcessTree {
    private static final Log LOG = LogFactory.getLog("com.facebook.presto.hive.$internal.org.apache.hadoop.mapred.ProcfsBasedProcessTree");
    private static final String PROCFS = "/proc/";
    public static final long DEFAULT_SLEEPTIME_BEFORE_SIGKILL = 5000L;
    private long sleepTimeBeforeSigKill = 5000L;
    private static final Pattern PROCFS_STAT_FILE_FORMAT = Pattern.compile("^([0-9-]+)\\s([^\\s]+)\\s[^\\s]\\s([0-9-]+)\\s([0-9-]+)\\s([0-9-]+)\\s([0-9-]+\\s){16}([0-9]+)(\\s[0-9-]+){16}");
    private String procfsDir;
    private Integer pid = -1;
    private Map<Integer, ProcessInfo> processTree = new HashMap<Integer, ProcessInfo>();

    public ProcfsBasedProcessTree(String pid) {
        this(pid, PROCFS);
    }

    public ProcfsBasedProcessTree(String pid, String procfsDir) {
        this.pid = this.getValidPID(pid);
        this.procfsDir = procfsDir;
    }

    public void setSigKillInterval(long interval) {
        this.sleepTimeBeforeSigKill = interval;
    }

    public static boolean isAvailable() {
        try {
            String osName = System.getProperty("os.name");
            if (!osName.startsWith("Linux")) {
                LOG.info("ProcfsBasedProcessTree currently is supported only on Linux.");
                return false;
            }
        }
        catch (SecurityException se) {
            LOG.warn("Failed to get Operating System name. " + se);
            return false;
        }
        return true;
    }

    public ProcfsBasedProcessTree getProcessTree() {
        if (this.pid != -1) {
            List<Integer> processList = this.getProcessList();
            HashMap<Integer, ProcessInfo> allProcessInfo = new HashMap<Integer, ProcessInfo>();
            HashMap<Integer, ProcessInfo> oldProcs = new HashMap<Integer, ProcessInfo>(this.processTree);
            this.processTree.clear();
            ProcessInfo me = null;
            for (Integer n : processList) {
                ProcessInfo pInfo = new ProcessInfo(n);
                if (this.constructProcessInfo(pInfo, this.procfsDir) == null) continue;
                allProcessInfo.put(n, pInfo);
                if (!n.equals(this.pid)) continue;
                me = pInfo;
                this.processTree.put(n, pInfo);
            }
            if (me == null) {
                return this;
            }
            for (Map.Entry entry : allProcessInfo.entrySet()) {
                ProcessInfo pInfo;
                ProcessInfo parentPInfo;
                Integer pID = (Integer)entry.getKey();
                if (pID == 1 || (parentPInfo = (ProcessInfo)allProcessInfo.get((pInfo = (ProcessInfo)entry.getValue()).getPpid())) == null) continue;
                parentPInfo.addChild(pInfo);
            }
            LinkedList<ProcessInfo> pInfoQueue = new LinkedList<ProcessInfo>();
            pInfoQueue.addAll(me.getChildren());
            while (!pInfoQueue.isEmpty()) {
                ProcessInfo processInfo = (ProcessInfo)pInfoQueue.remove();
                if (!this.processTree.containsKey(processInfo.getPid())) {
                    this.processTree.put(processInfo.getPid(), processInfo);
                }
                pInfoQueue.addAll(processInfo.getChildren());
            }
            for (Map.Entry<Integer, ProcessInfo> procs : this.processTree.entrySet()) {
                ProcessInfo oldInfo = (ProcessInfo)oldProcs.get(procs.getKey());
                if (oldInfo == null || procs.getValue() == null) continue;
                procs.getValue().updateAge(oldInfo);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug(this.toString());
            }
        }
        return this;
    }

    public boolean isAlive() {
        if (this.pid == -1) {
            return false;
        }
        return this.isAlive(this.pid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        LOG.debug("Killing ProcfsBasedProcessTree of " + this.pid);
        if (this.pid == -1) {
            return;
        }
        Shell shexec = null;
        if (this.isAlive(this.pid)) {
            try {
                String[] args = new String[]{"kill", this.pid.toString()};
                shexec = new Shell.ShellCommandExecutor(args);
                ((Shell.ShellCommandExecutor)shexec).execute();
            }
            catch (IOException ioe) {
                LOG.warn("Error executing shell command " + ioe);
            }
            finally {
                LOG.info("Killing " + this.pid + " with SIGTERM. Exit code " + shexec.getExitCode());
            }
        }
        SigKillThread sigKillThread = new SigKillThread();
        sigKillThread.setDaemon(true);
        sigKillThread.start();
    }

    public long getCumulativeVmem() {
        return this.getCumulativeVmem(0);
    }

    public long getCumulativeVmem(int olderThanAge) {
        long total = 0L;
        for (ProcessInfo p : this.processTree.values()) {
            if (p == null || p.getAge() <= olderThanAge) continue;
            total += p.getVmem().longValue();
        }
        return total;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getPidFromPidFile(String pidFileName) {
        BufferedReader pidFile = null;
        FileReader fReader = null;
        String pid = null;
        try {
            fReader = new FileReader(pidFileName);
            pidFile = new BufferedReader(fReader);
        }
        catch (FileNotFoundException f) {
            LOG.debug("PidFile doesn't exist : " + pidFileName);
            return pid;
        }
        try {
            pid = pidFile.readLine();
        }
        catch (IOException i) {
            LOG.error("Failed to read from " + pidFileName);
        }
        finally {
            try {
                if (fReader != null) {
                    fReader.close();
                }
                try {
                    if (pidFile != null) {
                        pidFile.close();
                    }
                }
                catch (IOException i) {
                    LOG.warn("Error closing the stream " + pidFile);
                }
            }
            catch (IOException i) {
                LOG.warn("Error closing the stream " + fReader);
            }
        }
        return pid;
    }

    private Integer getValidPID(String pid) {
        Integer retPid = -1;
        try {
            retPid = Integer.parseInt(pid);
            if (retPid <= 0) {
                retPid = -1;
            }
        }
        catch (NumberFormatException nfe) {
            retPid = -1;
        }
        return retPid;
    }

    private List<Integer> getProcessList() {
        String[] processDirs = new File(this.procfsDir).list();
        ArrayList<Integer> processList = new ArrayList<Integer>();
        for (String dir : processDirs) {
            try {
                int pd = Integer.parseInt(dir);
                if (!new File(this.procfsDir, dir).isDirectory()) continue;
                processList.add(pd);
            }
            catch (NumberFormatException n) {
            }
            catch (SecurityException s) {
                // empty catch block
            }
        }
        return processList;
    }

    private ProcessInfo constructProcessInfo(ProcessInfo pinfo) {
        return this.constructProcessInfo(pinfo, PROCFS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProcessInfo constructProcessInfo(ProcessInfo pinfo, String procfsDir) {
        ProcessInfo ret = null;
        BufferedReader in = null;
        FileReader fReader = null;
        try {
            File pidDir = new File(procfsDir, String.valueOf(pinfo.getPid()));
            fReader = new FileReader(new File(pidDir, "/stat"));
            in = new BufferedReader(fReader);
        }
        catch (FileNotFoundException f) {
            return ret;
        }
        ret = pinfo;
        try {
            String str = in.readLine();
            Matcher m = PROCFS_STAT_FILE_FORMAT.matcher(str);
            boolean mat = m.find();
            if (mat) {
                pinfo.updateProcessInfo(m.group(2), Integer.parseInt(m.group(3)), Integer.parseInt(m.group(4)), Integer.parseInt(m.group(5)), Long.parseLong(m.group(7)));
            }
        }
        catch (IOException io) {
            LOG.warn("Error reading the stream " + io);
            ret = null;
        }
        finally {
            try {
                if (fReader != null) {
                    fReader.close();
                }
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException i) {
                    LOG.warn("Error closing the stream " + in);
                }
            }
            catch (IOException i) {
                LOG.warn("Error closing the stream " + fReader);
            }
        }
        return ret;
    }

    private boolean isAlive(Integer pid) {
        Shell.ShellCommandExecutor shexec = null;
        try {
            String[] args = new String[]{"kill", "-0", pid.toString()};
            shexec = new Shell.ShellCommandExecutor(args);
            shexec.execute();
        }
        catch (Shell.ExitCodeException ee) {
            return false;
        }
        catch (IOException ioe) {
            LOG.warn("Error executing shell command " + Arrays.toString(shexec.getExecString()) + ioe);
            return false;
        }
        return shexec.getExitCode() == 0;
    }

    public String toString() {
        StringBuffer pTree = new StringBuffer("[ ");
        for (Integer p : this.processTree.keySet()) {
            pTree.append(p);
            pTree.append(" ");
        }
        return pTree.substring(0, pTree.length()) + "]";
    }

    private static class ProcessInfo {
        private Integer pid;
        private String name;
        private Integer pgrpId;
        private Integer ppid;
        private Integer sessionId;
        private Long vmem;
        private int age;
        private List<ProcessInfo> children = new ArrayList<ProcessInfo>();

        public ProcessInfo(int pid) {
            this.pid = pid;
            this.age = 1;
        }

        public Integer getPid() {
            return this.pid;
        }

        public String getName() {
            return this.name;
        }

        public Integer getPgrpId() {
            return this.pgrpId;
        }

        public Integer getPpid() {
            return this.ppid;
        }

        public Integer getSessionId() {
            return this.sessionId;
        }

        public Long getVmem() {
            return this.vmem;
        }

        public int getAge() {
            return this.age;
        }

        public boolean isParent(ProcessInfo p) {
            return this.pid.equals(p.getPpid());
        }

        public void updateProcessInfo(String name, Integer ppid, Integer pgrpId, Integer sessionId, Long vmem) {
            this.name = name;
            this.ppid = ppid;
            this.pgrpId = pgrpId;
            this.sessionId = sessionId;
            this.vmem = vmem;
        }

        public void updateAge(ProcessInfo oldInfo) {
            this.age = oldInfo.age + 1;
        }

        public boolean addChild(ProcessInfo p) {
            return this.children.add(p);
        }

        public List<ProcessInfo> getChildren() {
            return this.children;
        }
    }

    private class SigKillThread
    extends Thread {
        private SigKillThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.setName(this.getClass().getName() + "-" + String.valueOf(ProcfsBasedProcessTree.this.pid));
            Shell shexec = null;
            try {
                Thread.sleep(ProcfsBasedProcessTree.this.sleepTimeBeforeSigKill);
            }
            catch (InterruptedException i) {
                LOG.warn("Thread sleep is interrupted.");
            }
            if (ProcfsBasedProcessTree.this.isAlive(ProcfsBasedProcessTree.this.pid)) {
                try {
                    String[] args = new String[]{"kill", "-9", ProcfsBasedProcessTree.this.pid.toString()};
                    shexec = new Shell.ShellCommandExecutor(args);
                    ((Shell.ShellCommandExecutor)shexec).execute();
                }
                catch (IOException ioe) {
                    LOG.warn("Error executing shell command " + ioe);
                }
                finally {
                    LOG.info("Killing " + ProcfsBasedProcessTree.this.pid + " with SIGKILL. Exit code " + shexec.getExitCode());
                }
            }
        }
    }
}

