/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.$internal.org.apache.hadoop.net;

import com.facebook.presto.hive.$internal.org.apache.hadoop.conf.Configurable;
import com.facebook.presto.hive.$internal.org.apache.hadoop.conf.Configuration;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.SocketFactory;

public class SocksSocketFactory
extends SocketFactory
implements Configurable {
    private Configuration conf;
    private Proxy proxy;

    public SocksSocketFactory() {
        this.proxy = Proxy.NO_PROXY;
    }

    public SocksSocketFactory(Proxy proxy) {
        this.proxy = proxy;
    }

    @Override
    public Socket createSocket() throws IOException {
        return new Socket(this.proxy);
    }

    @Override
    public Socket createSocket(InetAddress addr, int port) throws IOException {
        Socket socket = this.createSocket();
        socket.connect(new InetSocketAddress(addr, port));
        return socket;
    }

    @Override
    public Socket createSocket(InetAddress addr, int port, InetAddress localHostAddr, int localPort) throws IOException {
        Socket socket = this.createSocket();
        socket.bind(new InetSocketAddress(localHostAddr, localPort));
        socket.connect(new InetSocketAddress(addr, port));
        return socket;
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        Socket socket = this.createSocket();
        socket.connect(new InetSocketAddress(host, port));
        return socket;
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localHostAddr, int localPort) throws IOException, UnknownHostException {
        Socket socket = this.createSocket();
        socket.bind(new InetSocketAddress(localHostAddr, localPort));
        socket.connect(new InetSocketAddress(host, port));
        return socket;
    }

    public int hashCode() {
        return this.proxy.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SocksSocketFactory)) {
            return false;
        }
        SocksSocketFactory other = (SocksSocketFactory)obj;
        return !(this.proxy == null ? other.proxy != null : !this.proxy.equals(other.proxy));
    }

    @Override
    public Configuration getConf() {
        return this.conf;
    }

    @Override
    public void setConf(Configuration conf) {
        this.conf = conf;
        String proxyStr = conf.get("hadoop.socks.server");
        if (proxyStr != null && proxyStr.length() > 0) {
            this.setProxy(proxyStr);
        }
    }

    private void setProxy(String proxyStr) {
        String[] strs = proxyStr.split(":", 2);
        if (strs.length != 2) {
            throw new RuntimeException("Bad SOCKS proxy parameter: " + proxyStr);
        }
        String host = strs[0];
        int port = Integer.parseInt(strs[1]);
        this.proxy = new Proxy(Proxy.Type.SOCKS, InetSocketAddress.createUnresolved(host, port));
    }
}

