/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.$internal.org.apache.hadoop.net;

import com.facebook.presto.hive.$internal.org.apache.hadoop.net.SocketIOWithTimeout;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SelectableChannel;

public class SocketInputStream
extends InputStream
implements ReadableByteChannel {
    private Reader reader;

    public SocketInputStream(ReadableByteChannel channel, long timeout) throws IOException {
        SocketIOWithTimeout.checkChannelValidity(channel);
        this.reader = new Reader(channel, timeout);
    }

    public SocketInputStream(Socket socket, long timeout) throws IOException {
        this(socket.getChannel(), timeout);
    }

    public SocketInputStream(Socket socket) throws IOException {
        this(socket.getChannel(), (long)socket.getSoTimeout());
    }

    @Override
    public int read() throws IOException {
        byte[] buf = new byte[1];
        int ret = this.read(buf, 0, 1);
        if (ret > 0) {
            return buf[0];
        }
        if (ret != -1) {
            throw new IOException("Could not read from stream");
        }
        return ret;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.read(ByteBuffer.wrap(b, off, len));
    }

    @Override
    public synchronized void close() throws IOException {
        this.reader.channel.close();
        this.reader.close();
    }

    public ReadableByteChannel getChannel() {
        return this.reader.channel;
    }

    @Override
    public boolean isOpen() {
        return this.reader.isOpen();
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        return this.reader.doIO(dst, 1);
    }

    public void waitForReadable() throws IOException {
        this.reader.waitForIO(1);
    }

    private static class Reader
    extends SocketIOWithTimeout {
        ReadableByteChannel channel;

        Reader(ReadableByteChannel channel, long timeout) throws IOException {
            super((SelectableChannel)((Object)channel), timeout);
            this.channel = channel;
        }

        @Override
        int performIO(ByteBuffer buf) throws IOException {
            return this.channel.read(buf);
        }
    }
}

