/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.$internal.org.apache.hadoop.metrics;

import com.facebook.presto.hive.$internal.org.apache.commons.logging.Log;
import com.facebook.presto.hive.$internal.org.apache.commons.logging.LogFactory;
import com.facebook.presto.hive.$internal.org.apache.hadoop.metrics.ContextFactory;
import com.facebook.presto.hive.$internal.org.apache.hadoop.metrics.MetricsContext;
import com.facebook.presto.hive.$internal.org.apache.hadoop.metrics.MetricsRecord;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class MetricsUtil {
    public static final Log LOG = LogFactory.getLog(MetricsUtil.class);

    private MetricsUtil() {
    }

    public static MetricsContext getContext(String contextName) {
        return MetricsUtil.getContext(contextName, contextName);
    }

    public static MetricsContext getContext(String refName, String contextName) {
        MetricsContext metricsContext;
        try {
            metricsContext = ContextFactory.getFactory().getContext(refName, contextName);
            if (!metricsContext.isMonitoring()) {
                metricsContext.startMonitoring();
            }
        }
        catch (Exception ex) {
            LOG.error("Unable to create metrics context " + contextName, ex);
            metricsContext = ContextFactory.getNullContext(contextName);
        }
        return metricsContext;
    }

    public static MetricsRecord createRecord(MetricsContext context, String recordName) {
        MetricsRecord metricsRecord = context.createRecord(recordName);
        metricsRecord.setTag("hostName", MetricsUtil.getHostName());
        return metricsRecord;
    }

    private static String getHostName() {
        String hostName = null;
        try {
            hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException ex) {
            LOG.info("Unable to obtain hostName", ex);
            hostName = "unknown";
        }
        return hostName;
    }
}

