/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.$internal.org.apache.hadoop.mapreduce.lib.output;

import com.facebook.presto.hive.$internal.org.apache.hadoop.conf.Configuration;
import com.facebook.presto.hive.$internal.org.apache.hadoop.fs.FileSystem;
import com.facebook.presto.hive.$internal.org.apache.hadoop.fs.Path;
import com.facebook.presto.hive.$internal.org.apache.hadoop.io.SequenceFile;
import com.facebook.presto.hive.$internal.org.apache.hadoop.io.compress.CompressionCodec;
import com.facebook.presto.hive.$internal.org.apache.hadoop.io.compress.DefaultCodec;
import com.facebook.presto.hive.$internal.org.apache.hadoop.mapreduce.Job;
import com.facebook.presto.hive.$internal.org.apache.hadoop.mapreduce.JobContext;
import com.facebook.presto.hive.$internal.org.apache.hadoop.mapreduce.RecordWriter;
import com.facebook.presto.hive.$internal.org.apache.hadoop.mapreduce.TaskAttemptContext;
import com.facebook.presto.hive.$internal.org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import com.facebook.presto.hive.$internal.org.apache.hadoop.util.ReflectionUtils;
import java.io.IOException;

public class SequenceFileOutputFormat<K, V>
extends FileOutputFormat<K, V> {
    @Override
    public RecordWriter<K, V> getRecordWriter(TaskAttemptContext context) throws IOException, InterruptedException {
        Configuration conf = context.getConfiguration();
        CompressionCodec codec = null;
        SequenceFile.CompressionType compressionType = SequenceFile.CompressionType.NONE;
        if (SequenceFileOutputFormat.getCompressOutput(context)) {
            compressionType = SequenceFileOutputFormat.getOutputCompressionType(context);
            Class<CompressionCodec> codecClass = SequenceFileOutputFormat.getOutputCompressorClass(context, DefaultCodec.class);
            codec = ReflectionUtils.newInstance(codecClass, conf);
        }
        Path file = this.getDefaultWorkFile(context, "");
        FileSystem fs = file.getFileSystem(conf);
        final SequenceFile.Writer out = SequenceFile.createWriter(fs, conf, file, context.getOutputKeyClass(), context.getOutputValueClass(), compressionType, codec, context);
        return new RecordWriter<K, V>(){

            @Override
            public void write(K key, V value) throws IOException {
                out.append(key, value);
            }

            @Override
            public void close(TaskAttemptContext context) throws IOException {
                out.close();
            }
        };
    }

    public static SequenceFile.CompressionType getOutputCompressionType(JobContext job) {
        String val = job.getConfiguration().get("mapred.output.compression.type", SequenceFile.CompressionType.RECORD.toString());
        return SequenceFile.CompressionType.valueOf(val);
    }

    public static void setOutputCompressionType(Job job, SequenceFile.CompressionType style) {
        SequenceFileOutputFormat.setCompressOutput(job, true);
        job.getConfiguration().set("mapred.output.compression.type", style.toString());
    }
}

