/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.$internal.org.apache.hadoop.mapreduce.lib.output;

import com.facebook.presto.hive.$internal.org.apache.hadoop.conf.Configuration;
import com.facebook.presto.hive.$internal.org.apache.hadoop.fs.Path;
import com.facebook.presto.hive.$internal.org.apache.hadoop.io.compress.CompressionCodec;
import com.facebook.presto.hive.$internal.org.apache.hadoop.mapred.FileAlreadyExistsException;
import com.facebook.presto.hive.$internal.org.apache.hadoop.mapred.InvalidJobConfException;
import com.facebook.presto.hive.$internal.org.apache.hadoop.mapreduce.Job;
import com.facebook.presto.hive.$internal.org.apache.hadoop.mapreduce.JobContext;
import com.facebook.presto.hive.$internal.org.apache.hadoop.mapreduce.OutputCommitter;
import com.facebook.presto.hive.$internal.org.apache.hadoop.mapreduce.OutputFormat;
import com.facebook.presto.hive.$internal.org.apache.hadoop.mapreduce.RecordWriter;
import com.facebook.presto.hive.$internal.org.apache.hadoop.mapreduce.TaskAttemptContext;
import com.facebook.presto.hive.$internal.org.apache.hadoop.mapreduce.TaskID;
import com.facebook.presto.hive.$internal.org.apache.hadoop.mapreduce.TaskInputOutputContext;
import com.facebook.presto.hive.$internal.org.apache.hadoop.mapreduce.lib.output.FileOutputCommitter;
import java.io.IOException;
import java.text.NumberFormat;

public abstract class FileOutputFormat<K, V>
extends OutputFormat<K, V> {
    private static final NumberFormat NUMBER_FORMAT = NumberFormat.getInstance();
    private FileOutputCommitter committer = null;

    public static void setCompressOutput(Job job, boolean compress) {
        job.getConfiguration().setBoolean("mapred.output.compress", compress);
    }

    public static boolean getCompressOutput(JobContext job) {
        return job.getConfiguration().getBoolean("mapred.output.compress", false);
    }

    public static void setOutputCompressorClass(Job job, Class<? extends CompressionCodec> codecClass) {
        FileOutputFormat.setCompressOutput(job, true);
        job.getConfiguration().setClass("mapred.output.compression.codec", codecClass, CompressionCodec.class);
    }

    public static Class<? extends CompressionCodec> getOutputCompressorClass(JobContext job, Class<? extends CompressionCodec> defaultValue) {
        Class<? extends CompressionCodec> codecClass = defaultValue;
        Configuration conf = job.getConfiguration();
        String name = conf.get("mapred.output.compression.codec");
        if (name != null) {
            try {
                codecClass = conf.getClassByName(name).asSubclass(CompressionCodec.class);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Compression codec " + name + " was not found.", e);
            }
        }
        return codecClass;
    }

    @Override
    public abstract RecordWriter<K, V> getRecordWriter(TaskAttemptContext var1) throws IOException, InterruptedException;

    @Override
    public void checkOutputSpecs(JobContext job) throws FileAlreadyExistsException, IOException {
        Path outDir = FileOutputFormat.getOutputPath(job);
        if (outDir == null) {
            throw new InvalidJobConfException("Output directory not set.");
        }
        if (outDir.getFileSystem(job.getConfiguration()).exists(outDir)) {
            throw new FileAlreadyExistsException("Output directory " + outDir + " already exists");
        }
    }

    public static void setOutputPath(Job job, Path outputDir) {
        job.getConfiguration().set("mapred.output.dir", outputDir.toString());
    }

    public static Path getOutputPath(JobContext job) {
        String name = job.getConfiguration().get("mapred.output.dir");
        return name == null ? null : new Path(name);
    }

    public static Path getWorkOutputPath(TaskInputOutputContext<?, ?, ?, ?> context) throws IOException, InterruptedException {
        FileOutputCommitter committer = (FileOutputCommitter)context.getOutputCommitter();
        return committer.getWorkPath();
    }

    public static Path getPathForWorkFile(TaskInputOutputContext<?, ?, ?, ?> context, String name, String extension) throws IOException, InterruptedException {
        return new Path(FileOutputFormat.getWorkOutputPath(context), FileOutputFormat.getUniqueFile(context, name, extension));
    }

    public static synchronized String getUniqueFile(TaskAttemptContext context, String name, String extension) {
        TaskID taskId = context.getTaskAttemptID().getTaskID();
        int partition = taskId.getId();
        StringBuilder result = new StringBuilder();
        result.append(name);
        result.append('-');
        result.append(taskId.isMap() ? (char)'m' : 'r');
        result.append('-');
        result.append(NUMBER_FORMAT.format(partition));
        result.append(extension);
        return result.toString();
    }

    public Path getDefaultWorkFile(TaskAttemptContext context, String extension) throws IOException {
        FileOutputCommitter committer = (FileOutputCommitter)this.getOutputCommitter(context);
        return new Path(committer.getWorkPath(), FileOutputFormat.getUniqueFile(context, "part", extension));
    }

    @Override
    public synchronized OutputCommitter getOutputCommitter(TaskAttemptContext context) throws IOException {
        if (this.committer == null) {
            Path output = FileOutputFormat.getOutputPath(context);
            this.committer = new FileOutputCommitter(output, context);
        }
        return this.committer;
    }

    static {
        NUMBER_FORMAT.setMinimumIntegerDigits(5);
        NUMBER_FORMAT.setGroupingUsed(false);
    }
}

