/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.$internal.org.apache.hadoop.mapreduce;

import com.facebook.presto.hive.$internal.org.apache.hadoop.io.Text;
import com.facebook.presto.hive.$internal.org.apache.hadoop.mapreduce.ID;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.text.NumberFormat;

public class JobID
extends com.facebook.presto.hive.$internal.org.apache.hadoop.mapred.ID
implements Comparable<ID> {
    protected static final String JOB = "job";
    private final Text jtIdentifier;
    protected static final NumberFormat idFormat = NumberFormat.getInstance();

    public JobID(String jtIdentifier, int id) {
        super(id);
        this.jtIdentifier = new Text(jtIdentifier);
    }

    public JobID() {
        this.jtIdentifier = new Text();
    }

    public String getJtIdentifier() {
        return this.jtIdentifier.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        JobID that = (JobID)o;
        return this.jtIdentifier.equals(that.jtIdentifier);
    }

    @Override
    public int compareTo(ID o) {
        JobID that = (JobID)o;
        int jtComp = this.jtIdentifier.compareTo(that.jtIdentifier);
        if (jtComp == 0) {
            return this.id - that.id;
        }
        return jtComp;
    }

    public StringBuilder appendTo(StringBuilder builder) {
        builder.append('_');
        builder.append(this.jtIdentifier);
        builder.append('_');
        builder.append(idFormat.format(this.id));
        return builder;
    }

    @Override
    public int hashCode() {
        return this.jtIdentifier.hashCode() + this.id;
    }

    @Override
    public String toString() {
        return this.appendTo(new StringBuilder(JOB)).toString();
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this.jtIdentifier.readFields(in);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        this.jtIdentifier.write(out);
    }

    public static JobID forName(String str) throws IllegalArgumentException {
        if (str == null) {
            return null;
        }
        try {
            String[] parts = str.split("_");
            if (parts.length == 3 && parts[0].equals(JOB)) {
                return new com.facebook.presto.hive.$internal.org.apache.hadoop.mapred.JobID(parts[1], Integer.parseInt(parts[2]));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new IllegalArgumentException("JobId string : " + str + " is not properly formed");
    }

    static {
        idFormat.setGroupingUsed(false);
        idFormat.setMinimumIntegerDigits(4);
    }
}

