/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.$internal.org.apache.hadoop.mapreduce;

import com.facebook.presto.hive.$internal.org.apache.hadoop.conf.Configuration;
import com.facebook.presto.hive.$internal.org.apache.hadoop.fs.Path;
import com.facebook.presto.hive.$internal.org.apache.hadoop.io.RawComparator;
import com.facebook.presto.hive.$internal.org.apache.hadoop.mapred.JobClient;
import com.facebook.presto.hive.$internal.org.apache.hadoop.mapred.JobConf;
import com.facebook.presto.hive.$internal.org.apache.hadoop.mapred.RunningJob;
import com.facebook.presto.hive.$internal.org.apache.hadoop.mapred.TaskAttemptID;
import com.facebook.presto.hive.$internal.org.apache.hadoop.mapred.TaskCompletionEvent;
import com.facebook.presto.hive.$internal.org.apache.hadoop.mapreduce.Counters;
import com.facebook.presto.hive.$internal.org.apache.hadoop.mapreduce.InputFormat;
import com.facebook.presto.hive.$internal.org.apache.hadoop.mapreduce.JobContext;
import com.facebook.presto.hive.$internal.org.apache.hadoop.mapreduce.Mapper;
import com.facebook.presto.hive.$internal.org.apache.hadoop.mapreduce.OutputFormat;
import com.facebook.presto.hive.$internal.org.apache.hadoop.mapreduce.Partitioner;
import com.facebook.presto.hive.$internal.org.apache.hadoop.mapreduce.Reducer;
import java.io.IOException;

public class Job
extends JobContext {
    private JobState state = JobState.DEFINE;
    private JobClient jobClient = new JobClient((JobConf)this.getConfiguration());
    private RunningJob info;

    public Job() throws IOException {
        this(new Configuration());
    }

    public Job(Configuration conf) throws IOException {
        super(conf, null);
    }

    public Job(Configuration conf, String jobName) throws IOException {
        this(conf);
        this.setJobName(jobName);
    }

    private void ensureState(JobState state) throws IllegalStateException {
        if (state != this.state) {
            throw new IllegalStateException("Job in state " + (Object)((Object)this.state) + " instead of " + (Object)((Object)state));
        }
    }

    public void setNumReduceTasks(int tasks) throws IllegalStateException {
        this.ensureState(JobState.DEFINE);
        this.conf.setNumReduceTasks(tasks);
    }

    public void setWorkingDirectory(Path dir) throws IOException {
        this.ensureState(JobState.DEFINE);
        this.conf.setWorkingDirectory(dir);
    }

    public void setInputFormatClass(Class<? extends InputFormat> cls) throws IllegalStateException {
        this.ensureState(JobState.DEFINE);
        this.conf.setClass("mapreduce.inputformat.class", cls, InputFormat.class);
    }

    public void setOutputFormatClass(Class<? extends OutputFormat> cls) throws IllegalStateException {
        this.ensureState(JobState.DEFINE);
        this.conf.setClass("mapreduce.outputformat.class", cls, OutputFormat.class);
    }

    public void setMapperClass(Class<? extends Mapper> cls) throws IllegalStateException {
        this.ensureState(JobState.DEFINE);
        this.conf.setClass("mapreduce.map.class", cls, Mapper.class);
    }

    public void setJarByClass(Class<?> cls) {
        this.conf.setJarByClass(cls);
    }

    @Override
    public String getJar() {
        return this.conf.getJar();
    }

    public void setCombinerClass(Class<? extends Reducer> cls) throws IllegalStateException {
        this.ensureState(JobState.DEFINE);
        this.conf.setClass("mapreduce.combine.class", cls, Reducer.class);
    }

    public void setReducerClass(Class<? extends Reducer> cls) throws IllegalStateException {
        this.ensureState(JobState.DEFINE);
        this.conf.setClass("mapreduce.reduce.class", cls, Reducer.class);
    }

    public void setPartitionerClass(Class<? extends Partitioner> cls) throws IllegalStateException {
        this.ensureState(JobState.DEFINE);
        this.conf.setClass("mapreduce.partitioner.class", cls, Partitioner.class);
    }

    public void setMapOutputKeyClass(Class<?> theClass) throws IllegalStateException {
        this.ensureState(JobState.DEFINE);
        this.conf.setMapOutputKeyClass(theClass);
    }

    public void setMapOutputValueClass(Class<?> theClass) throws IllegalStateException {
        this.ensureState(JobState.DEFINE);
        this.conf.setMapOutputValueClass(theClass);
    }

    public void setOutputKeyClass(Class<?> theClass) throws IllegalStateException {
        this.ensureState(JobState.DEFINE);
        this.conf.setOutputKeyClass(theClass);
    }

    public void setOutputValueClass(Class<?> theClass) throws IllegalStateException {
        this.ensureState(JobState.DEFINE);
        this.conf.setOutputValueClass(theClass);
    }

    public void setSortComparatorClass(Class<? extends RawComparator> cls) throws IllegalStateException {
        this.ensureState(JobState.DEFINE);
        this.conf.setOutputKeyComparatorClass(cls);
    }

    public void setGroupingComparatorClass(Class<? extends RawComparator> cls) throws IllegalStateException {
        this.ensureState(JobState.DEFINE);
        this.conf.setOutputValueGroupingComparator(cls);
    }

    public void setJobName(String name) throws IllegalStateException {
        this.ensureState(JobState.DEFINE);
        this.conf.setJobName(name);
    }

    public String getTrackingURL() {
        this.ensureState(JobState.RUNNING);
        return this.info.getTrackingURL();
    }

    public float mapProgress() throws IOException {
        this.ensureState(JobState.RUNNING);
        return this.info.mapProgress();
    }

    public float reduceProgress() throws IOException {
        this.ensureState(JobState.RUNNING);
        return this.info.reduceProgress();
    }

    public boolean isComplete() throws IOException {
        this.ensureState(JobState.RUNNING);
        return this.info.isComplete();
    }

    public boolean isSuccessful() throws IOException {
        this.ensureState(JobState.RUNNING);
        return this.info.isSuccessful();
    }

    public void killJob() throws IOException {
        this.ensureState(JobState.RUNNING);
        this.info.killJob();
    }

    public TaskCompletionEvent[] getTaskCompletionEvents(int startFrom) throws IOException {
        this.ensureState(JobState.RUNNING);
        return this.info.getTaskCompletionEvents(startFrom);
    }

    public void killTask(com.facebook.presto.hive.$internal.org.apache.hadoop.mapreduce.TaskAttemptID taskId) throws IOException {
        this.ensureState(JobState.RUNNING);
        this.info.killTask(TaskAttemptID.downgrade(taskId), false);
    }

    public void failTask(com.facebook.presto.hive.$internal.org.apache.hadoop.mapreduce.TaskAttemptID taskId) throws IOException {
        this.ensureState(JobState.RUNNING);
        this.info.killTask(TaskAttemptID.downgrade(taskId), true);
    }

    public Counters getCounters() throws IOException {
        this.ensureState(JobState.RUNNING);
        return new Counters(this.info.getCounters());
    }

    private void ensureNotSet(String attr, String msg) throws IOException {
        if (this.conf.get(attr) != null) {
            throw new IOException(attr + " is incompatible with " + msg + " mode.");
        }
    }

    private void setUseNewAPI() throws IOException {
        String mode;
        int numReduces = this.conf.getNumReduceTasks();
        String oldMapperClass = "mapred.mapper.class";
        String oldReduceClass = "mapred.reducer.class";
        this.conf.setBooleanIfUnset("mapred.mapper.new-api", this.conf.get(oldMapperClass) == null);
        if (this.conf.getUseNewMapper()) {
            mode = "new map API";
            this.ensureNotSet("mapred.input.format.class", mode);
            this.ensureNotSet(oldMapperClass, mode);
            if (numReduces != 0) {
                this.ensureNotSet("mapred.partitioner.class", mode);
            } else {
                this.ensureNotSet("mapred.output.format.class", mode);
            }
        } else {
            mode = "map compatability";
            this.ensureNotSet("mapreduce.inputformat.class", mode);
            this.ensureNotSet("mapreduce.map.class", mode);
            if (numReduces != 0) {
                this.ensureNotSet("mapreduce.partitioner.class", mode);
            } else {
                this.ensureNotSet("mapreduce.outputformat.class", mode);
            }
        }
        if (numReduces != 0) {
            this.conf.setBooleanIfUnset("mapred.reducer.new-api", this.conf.get(oldReduceClass) == null);
            if (this.conf.getUseNewReducer()) {
                mode = "new reduce API";
                this.ensureNotSet("mapred.output.format.class", mode);
                this.ensureNotSet(oldReduceClass, mode);
            } else {
                mode = "reduce compatability";
                this.ensureNotSet("mapreduce.outputformat.class", mode);
                this.ensureNotSet("mapreduce.reduce.class", mode);
            }
        }
    }

    public void submit() throws IOException, InterruptedException, ClassNotFoundException {
        this.ensureState(JobState.DEFINE);
        this.setUseNewAPI();
        this.info = this.jobClient.submitJobInternal(this.conf);
        this.state = JobState.RUNNING;
    }

    public boolean waitForCompletion(boolean verbose) throws IOException, InterruptedException, ClassNotFoundException {
        if (this.state == JobState.DEFINE) {
            this.submit();
        }
        if (verbose) {
            this.jobClient.monitorAndPrintJob(this.conf, this.info);
        } else {
            this.info.waitForCompletion();
        }
        return this.isSuccessful();
    }

    public static enum JobState {
        DEFINE,
        RUNNING;

    }
}

