/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.$internal.org.apache.hadoop.mapred.tools;

import com.facebook.presto.hive.$internal.org.apache.hadoop.conf.Configuration;
import com.facebook.presto.hive.$internal.org.apache.hadoop.conf.Configured;
import com.facebook.presto.hive.$internal.org.apache.hadoop.ipc.RPC;
import com.facebook.presto.hive.$internal.org.apache.hadoop.ipc.RemoteException;
import com.facebook.presto.hive.$internal.org.apache.hadoop.mapred.JobTracker;
import com.facebook.presto.hive.$internal.org.apache.hadoop.net.NetUtils;
import com.facebook.presto.hive.$internal.org.apache.hadoop.security.UnixUserGroupInformation;
import com.facebook.presto.hive.$internal.org.apache.hadoop.security.authorize.RefreshAuthorizationPolicyProtocol;
import com.facebook.presto.hive.$internal.org.apache.hadoop.util.Tool;
import com.facebook.presto.hive.$internal.org.apache.hadoop.util.ToolRunner;
import java.io.IOException;
import javax.security.auth.login.LoginException;

public class MRAdmin
extends Configured
implements Tool {
    public MRAdmin() {
    }

    public MRAdmin(Configuration conf) {
        super(conf);
    }

    private static void printHelp(String cmd) {
        String summary = "hadoop mradmin is the command to execute Map-Reduce administrative commands.\nThe full syntax is: \n\nhadoop mradmin [-refreshServiceAcl] [-help [cmd]]\n";
        String refreshServiceAcl = "-refreshServiceAcl: Reload the service-level authorization policy file\n\t\tJobtracker will reload the authorization policy file.\n";
        String help = "-help [cmd]: \tDisplays help for the given command or all commands if none\n\t\tis specified.\n";
        if ("refreshServiceAcl".equals(cmd)) {
            System.out.println(refreshServiceAcl);
        } else if ("help".equals(cmd)) {
            System.out.println(help);
        } else {
            System.out.println(summary);
            System.out.println(refreshServiceAcl);
            System.out.println(help);
            System.out.println();
            ToolRunner.printGenericCommandUsage(System.out);
        }
    }

    private static void printUsage(String cmd) {
        if ("-refreshServiceAcl".equals(cmd)) {
            System.err.println("Usage: java MRAdmin [-refreshServiceAcl]");
        } else {
            System.err.println("Usage: java MRAdmin");
            System.err.println("           [-refreshServiceAcl]");
            System.err.println("           [-help [cmd]]");
            System.err.println();
            ToolRunner.printGenericCommandUsage(System.err);
        }
    }

    private static UnixUserGroupInformation getUGI(Configuration conf) throws IOException {
        UnixUserGroupInformation ugi = null;
        try {
            ugi = UnixUserGroupInformation.login(conf, true);
        }
        catch (LoginException e) {
            throw (IOException)new IOException("Failed to get the current user's information.").initCause(e);
        }
        return ugi;
    }

    private int refreshAuthorizationPolicy() throws IOException {
        Configuration conf = this.getConf();
        RefreshAuthorizationPolicyProtocol refreshProtocol = (RefreshAuthorizationPolicyProtocol)RPC.getProxy(RefreshAuthorizationPolicyProtocol.class, 1L, JobTracker.getAddress(conf), MRAdmin.getUGI(conf), conf, NetUtils.getSocketFactory(conf, RefreshAuthorizationPolicyProtocol.class));
        refreshProtocol.refreshServiceAcl();
        return 0;
    }

    @Override
    public int run(String[] args) throws Exception {
        String cmd;
        if (args.length < 1) {
            MRAdmin.printUsage("");
            return -1;
        }
        int exitCode = -1;
        int i = 0;
        if ("-refreshServiceAcl".equals(cmd = args[i++]) && args.length != 1) {
            MRAdmin.printUsage(cmd);
            return exitCode;
        }
        exitCode = 0;
        try {
            if ("-refreshServiceAcl".equals(cmd)) {
                exitCode = this.refreshAuthorizationPolicy();
            } else if ("-help".equals(cmd)) {
                if (i < args.length) {
                    MRAdmin.printUsage(args[i]);
                } else {
                    MRAdmin.printHelp("");
                }
            } else {
                exitCode = -1;
                System.err.println(cmd.substring(1) + ": Unknown command");
                MRAdmin.printUsage("");
            }
        }
        catch (IllegalArgumentException arge) {
            exitCode = -1;
            System.err.println(cmd.substring(1) + ": " + arge.getLocalizedMessage());
            MRAdmin.printUsage(cmd);
        }
        catch (RemoteException e) {
            exitCode = -1;
            try {
                String[] content = e.getLocalizedMessage().split("\n");
                System.err.println(cmd.substring(1) + ": " + content[0]);
            }
            catch (Exception ex) {
                System.err.println(cmd.substring(1) + ": " + ex.getLocalizedMessage());
            }
        }
        catch (Exception e) {
            exitCode = -1;
            System.err.println(cmd.substring(1) + ": " + e.getLocalizedMessage());
        }
        return exitCode;
    }

    public static void main(String[] args) throws Exception {
        int result = ToolRunner.run(new MRAdmin(), args);
        System.exit(result);
    }
}

