/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.$internal.org.apache.hadoop.mapred.lib.db;

import com.facebook.presto.hive.$internal.org.apache.commons.logging.Log;
import com.facebook.presto.hive.$internal.org.apache.commons.logging.LogFactory;
import com.facebook.presto.hive.$internal.org.apache.hadoop.fs.FileSystem;
import com.facebook.presto.hive.$internal.org.apache.hadoop.mapred.JobConf;
import com.facebook.presto.hive.$internal.org.apache.hadoop.mapred.OutputFormat;
import com.facebook.presto.hive.$internal.org.apache.hadoop.mapred.RecordWriter;
import com.facebook.presto.hive.$internal.org.apache.hadoop.mapred.Reporter;
import com.facebook.presto.hive.$internal.org.apache.hadoop.mapred.lib.db.DBConfiguration;
import com.facebook.presto.hive.$internal.org.apache.hadoop.mapred.lib.db.DBWritable;
import com.facebook.presto.hive.$internal.org.apache.hadoop.util.Progressable;
import com.facebook.presto.hive.$internal.org.apache.hadoop.util.StringUtils;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class DBOutputFormat<K extends DBWritable, V>
implements OutputFormat<K, V> {
    private static final Log LOG = LogFactory.getLog(DBOutputFormat.class);

    protected String constructQuery(String table, String[] fieldNames) {
        int i;
        if (fieldNames == null) {
            throw new IllegalArgumentException("Field names may not be null");
        }
        StringBuilder query = new StringBuilder();
        query.append("INSERT INTO ").append(table);
        if (fieldNames.length > 0 && fieldNames[0] != null) {
            query.append(" (");
            for (i = 0; i < fieldNames.length; ++i) {
                query.append(fieldNames[i]);
                if (i == fieldNames.length - 1) continue;
                query.append(",");
            }
            query.append(")");
        }
        query.append(" VALUES (");
        for (i = 0; i < fieldNames.length; ++i) {
            query.append("?");
            if (i == fieldNames.length - 1) continue;
            query.append(",");
        }
        query.append(");");
        return query.toString();
    }

    @Override
    public void checkOutputSpecs(FileSystem filesystem, JobConf job) throws IOException {
    }

    @Override
    public RecordWriter<K, V> getRecordWriter(FileSystem filesystem, JobConf job, String name, Progressable progress) throws IOException {
        DBConfiguration dbConf = new DBConfiguration(job);
        String tableName = dbConf.getOutputTableName();
        String[] fieldNames = dbConf.getOutputFieldNames();
        try {
            Connection connection = dbConf.getConnection();
            PreparedStatement statement = null;
            statement = connection.prepareStatement(this.constructQuery(tableName, fieldNames));
            return new DBRecordWriter(connection, statement);
        }
        catch (Exception ex) {
            throw new IOException(ex.getMessage());
        }
    }

    public static void setOutput(JobConf job, String tableName, String ... fieldNames) {
        job.setOutputFormat(DBOutputFormat.class);
        job.setReduceSpeculativeExecution(false);
        DBConfiguration dbConf = new DBConfiguration(job);
        dbConf.setOutputTableName(tableName);
        dbConf.setOutputFieldNames(fieldNames);
    }

    protected class DBRecordWriter
    implements RecordWriter<K, V> {
        private Connection connection;
        private PreparedStatement statement;

        protected DBRecordWriter(Connection connection, PreparedStatement statement) throws SQLException {
            this.connection = connection;
            this.statement = statement;
            this.connection.setAutoCommit(false);
        }

        @Override
        public void close(Reporter reporter) throws IOException {
            try {
                this.statement.executeBatch();
                this.connection.commit();
            }
            catch (SQLException e) {
                try {
                    this.connection.rollback();
                }
                catch (SQLException ex) {
                    LOG.warn(StringUtils.stringifyException(ex));
                }
                throw new IOException(e.getMessage());
            }
            finally {
                try {
                    this.statement.close();
                    this.connection.close();
                }
                catch (SQLException ex) {
                    throw new IOException(ex.getMessage());
                }
            }
        }

        @Override
        public void write(K key, V value) throws IOException {
            try {
                key.write(this.statement);
                this.statement.addBatch();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }
}

