/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.$internal.org.apache.hadoop.mapred.lib.db;

import com.facebook.presto.hive.;
import com.facebook.presto.hive.$internal.org.apache.hadoop.mapred.JobConf;
import com.facebook.presto.hive.$internal.org.apache.hadoop.mapred.lib.db.DBWritable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;

public class DBConfiguration {
    public static final String DRIVER_CLASS_PROPERTY = "mapred.jdbc.driver.class";
    public static final String URL_PROPERTY = "mapred.jdbc.url";
    public static final String USERNAME_PROPERTY = "mapred.jdbc.username";
    public static final String PASSWORD_PROPERTY = "mapred.jdbc.password";
    public static final String INPUT_TABLE_NAME_PROPERTY = "mapred.jdbc.input.table.name";
    public static final String INPUT_FIELD_NAMES_PROPERTY = "mapred.jdbc.input.field.names";
    public static final String INPUT_CONDITIONS_PROPERTY = "mapred.jdbc.input.conditions";
    public static final String INPUT_ORDER_BY_PROPERTY = "mapred.jdbc.input.orderby";
    public static final String INPUT_QUERY = "mapred.jdbc.input.query";
    public static final String INPUT_COUNT_QUERY = "mapred.jdbc.input.count.query";
    public static final String INPUT_CLASS_PROPERTY = "mapred.jdbc.input.class";
    public static final String OUTPUT_TABLE_NAME_PROPERTY = "mapred.jdbc.output.table.name";
    public static final String OUTPUT_FIELD_NAMES_PROPERTY = "mapred.jdbc.output.field.names";
    private JobConf job;

    public static void configureDB(JobConf job, String driverClass, String dbUrl, String userName, String passwd) {
        job.set(DRIVER_CLASS_PROPERTY, driverClass);
        job.set(URL_PROPERTY, dbUrl);
        if (userName != null) {
            job.set(USERNAME_PROPERTY, userName);
        }
        if (passwd != null) {
            job.set(PASSWORD_PROPERTY, passwd);
        }
    }

    public static void configureDB(JobConf job, String driverClass, String dbUrl) {
        DBConfiguration.configureDB(job, driverClass, dbUrl, null, null);
    }

    DBConfiguration(JobConf job) {
        this.job = job;
    }

    Connection getConnection() throws ClassNotFoundException, SQLException {
        Class.forName(this.job.get(DRIVER_CLASS_PROPERTY));
        if (this.job.get(USERNAME_PROPERTY) == null) {
            return DriverManager.getConnection(this.job.get(URL_PROPERTY));
        }
        return DriverManager.getConnection(this.job.get(URL_PROPERTY), this.job.get(USERNAME_PROPERTY), this.job.get(PASSWORD_PROPERTY));
    }

    String getInputTableName() {
        return this.job.get(INPUT_TABLE_NAME_PROPERTY);
    }

    void setInputTableName(String tableName) {
        this.job.set(INPUT_TABLE_NAME_PROPERTY, tableName);
    }

    String[] getInputFieldNames() {
        return this.job.getStrings(INPUT_FIELD_NAMES_PROPERTY);
    }

    void setInputFieldNames(String ... fieldNames) {
        this.job.setStrings(INPUT_FIELD_NAMES_PROPERTY, fieldNames);
    }

    String getInputConditions() {
        return this.job.get(INPUT_CONDITIONS_PROPERTY);
    }

    void setInputConditions(String conditions) {
        if (conditions != null && conditions.length() > 0) {
            this.job.set(INPUT_CONDITIONS_PROPERTY, conditions);
        }
    }

    String getInputOrderBy() {
        return this.job.get(INPUT_ORDER_BY_PROPERTY);
    }

    void setInputOrderBy(String orderby) {
        if (orderby != null && orderby.length() > 0) {
            this.job.set(INPUT_ORDER_BY_PROPERTY, orderby);
        }
    }

    String getInputQuery() {
        return this.job.get(INPUT_QUERY);
    }

    void setInputQuery(String query) {
        if (query != null && query.length() > 0) {
            this.job.set(INPUT_QUERY, query);
        }
    }

    String getInputCountQuery() {
        return this.job.get(INPUT_COUNT_QUERY);
    }

    void setInputCountQuery(String query) {
        if (query != null && query.length() > 0) {
            this.job.set(INPUT_COUNT_QUERY, query);
        }
    }

    Class<?> getInputClass() {
        return this.job.getClass(INPUT_CLASS_PROPERTY, .DBInputFormat.NullDBWritable.class);
    }

    void setInputClass(Class<? extends DBWritable> inputClass) {
        this.job.setClass(INPUT_CLASS_PROPERTY, inputClass, DBWritable.class);
    }

    String getOutputTableName() {
        return this.job.get(OUTPUT_TABLE_NAME_PROPERTY);
    }

    void setOutputTableName(String tableName) {
        this.job.set(OUTPUT_TABLE_NAME_PROPERTY, tableName);
    }

    String[] getOutputFieldNames() {
        return this.job.getStrings(OUTPUT_FIELD_NAMES_PROPERTY);
    }

    void setOutputFieldNames(String ... fieldNames) {
        this.job.setStrings(OUTPUT_FIELD_NAMES_PROPERTY, fieldNames);
    }
}

