/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.$internal.org.apache.hadoop.mapred.lib;

import com.facebook.presto.hive.$internal.org.apache.hadoop.io.LongWritable;
import com.facebook.presto.hive.$internal.org.apache.hadoop.io.Text;
import com.facebook.presto.hive.$internal.org.apache.hadoop.mapred.JobConf;
import com.facebook.presto.hive.$internal.org.apache.hadoop.mapred.MapReduceBase;
import com.facebook.presto.hive.$internal.org.apache.hadoop.mapred.Mapper;
import com.facebook.presto.hive.$internal.org.apache.hadoop.mapred.OutputCollector;
import com.facebook.presto.hive.$internal.org.apache.hadoop.mapred.Reporter;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegexMapper<K>
extends MapReduceBase
implements Mapper<K, Text, Text, LongWritable> {
    private Pattern pattern;
    private int group;

    @Override
    public void configure(JobConf job) {
        this.pattern = Pattern.compile(job.get("mapred.mapper.regex"));
        this.group = job.getInt("mapred.mapper.regex.group", 0);
    }

    @Override
    public void map(K key, Text value, OutputCollector<Text, LongWritable> output, Reporter reporter) throws IOException {
        String text = value.toString();
        Matcher matcher = this.pattern.matcher(text);
        while (matcher.find()) {
            output.collect(new Text(matcher.group(this.group)), new LongWritable(1L));
        }
    }
}

