/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.$internal.org.apache.hadoop.mapred.lib;

import com.facebook.presto.hive.$internal.org.apache.commons.logging.Log;
import com.facebook.presto.hive.$internal.org.apache.commons.logging.LogFactory;
import com.facebook.presto.hive.$internal.org.apache.hadoop.io.Text;
import com.facebook.presto.hive.$internal.org.apache.hadoop.mapred.JobConf;
import com.facebook.presto.hive.$internal.org.apache.hadoop.mapred.Mapper;
import com.facebook.presto.hive.$internal.org.apache.hadoop.mapred.OutputCollector;
import com.facebook.presto.hive.$internal.org.apache.hadoop.mapred.Reducer;
import com.facebook.presto.hive.$internal.org.apache.hadoop.mapred.Reporter;
import com.facebook.presto.hive.$internal.org.apache.hadoop.mapred.TextInputFormat;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;

public class FieldSelectionMapReduce<K, V>
implements Mapper<K, V, Text, Text>,
Reducer<Text, Text, Text, Text> {
    private String mapOutputKeyValueSpec;
    private boolean ignoreInputKey;
    private String fieldSeparator = "\t";
    private int[] mapOutputKeyFieldList = null;
    private int[] mapOutputValueFieldList = null;
    private int allMapValueFieldsFrom = -1;
    private String reduceOutputKeyValueSpec;
    private int[] reduceOutputKeyFieldList = null;
    private int[] reduceOutputValueFieldList = null;
    private int allReduceValueFieldsFrom = -1;
    private static Text emptyText = new Text("");
    public static final Log LOG = LogFactory.getLog("FieldSelectionMapReduce");

    private String specToString() {
        StringBuffer sb = new StringBuffer();
        sb.append("fieldSeparator: ").append(this.fieldSeparator).append("\n");
        sb.append("mapOutputKeyValueSpec: ").append(this.mapOutputKeyValueSpec).append("\n");
        sb.append("reduceOutputKeyValueSpec: ").append(this.reduceOutputKeyValueSpec).append("\n");
        sb.append("allMapValueFieldsFrom: ").append(this.allMapValueFieldsFrom).append("\n");
        sb.append("allReduceValueFieldsFrom: ").append(this.allReduceValueFieldsFrom).append("\n");
        int i = 0;
        sb.append("mapOutputKeyFieldList.length: ").append(this.mapOutputKeyFieldList.length).append("\n");
        for (i = 0; i < this.mapOutputKeyFieldList.length; ++i) {
            sb.append("\t").append(this.mapOutputKeyFieldList[i]).append("\n");
        }
        sb.append("mapOutputValueFieldList.length: ").append(this.mapOutputValueFieldList.length).append("\n");
        for (i = 0; i < this.mapOutputValueFieldList.length; ++i) {
            sb.append("\t").append(this.mapOutputValueFieldList[i]).append("\n");
        }
        sb.append("reduceOutputKeyFieldList.length: ").append(this.reduceOutputKeyFieldList.length).append("\n");
        for (i = 0; i < this.reduceOutputKeyFieldList.length; ++i) {
            sb.append("\t").append(this.reduceOutputKeyFieldList[i]).append("\n");
        }
        sb.append("reduceOutputValueFieldList.length: ").append(this.reduceOutputValueFieldList.length).append("\n");
        for (i = 0; i < this.reduceOutputValueFieldList.length; ++i) {
            sb.append("\t").append(this.reduceOutputValueFieldList[i]).append("\n");
        }
        return sb.toString();
    }

    @Override
    public void map(K key, V val, OutputCollector<Text, Text> output, Reporter reporter) throws IOException {
        Text newTextVal;
        String valStr = val.toString();
        String[] inputValFields = valStr.split(this.fieldSeparator);
        String[] inputKeyFields = null;
        String[] fields = null;
        if (this.ignoreInputKey) {
            fields = inputValFields;
        } else {
            inputKeyFields = key.toString().split(this.fieldSeparator);
            fields = new String[inputKeyFields.length + inputValFields.length];
            int i = 0;
            for (i = 0; i < inputKeyFields.length; ++i) {
                fields[i] = inputKeyFields[i];
            }
            for (i = 0; i < inputValFields.length; ++i) {
                fields[inputKeyFields.length + i] = inputValFields[i];
            }
        }
        String newKey = FieldSelectionMapReduce.selectFields(fields, this.mapOutputKeyFieldList, -1, this.fieldSeparator);
        String newVal = FieldSelectionMapReduce.selectFields(fields, this.mapOutputValueFieldList, this.allMapValueFieldsFrom, this.fieldSeparator);
        if (newKey == null) {
            newKey = newVal;
            newVal = null;
        }
        Text newTextKey = emptyText;
        if (newKey != null) {
            newTextKey = new Text(newKey);
        }
        if ((newTextVal = emptyText) != null) {
            newTextVal = new Text(newVal);
        }
        output.collect(newTextKey, newTextVal);
    }

    private int extractFields(String[] fieldListSpec, ArrayList<Integer> fieldList) {
        int allFieldsFrom = -1;
        int i = 0;
        int j = 0;
        int pos = -1;
        String fieldSpec = null;
        for (i = 0; i < fieldListSpec.length; ++i) {
            fieldSpec = fieldListSpec[i];
            if (fieldSpec.length() == 0) continue;
            pos = fieldSpec.indexOf(45);
            if (pos < 0) {
                Integer fn = new Integer(fieldSpec);
                fieldList.add(fn);
                continue;
            }
            String start = fieldSpec.substring(0, pos);
            String end = fieldSpec.substring(pos + 1);
            if (start.length() == 0) {
                start = "0";
            }
            if (end.length() == 0) {
                allFieldsFrom = Integer.parseInt(start);
                continue;
            }
            int startPos = Integer.parseInt(start);
            int endPos = Integer.parseInt(end);
            for (j = startPos; j <= endPos; ++j) {
                fieldList.add(j);
            }
        }
        return allFieldsFrom;
    }

    private void parseOutputKeyValueSpec() {
        String[] mapKeyValSpecs = this.mapOutputKeyValueSpec.split(":", -1);
        String[] mapKeySpec = mapKeyValSpecs[0].split(",");
        String[] mapValSpec = new String[]{};
        if (mapKeyValSpecs.length > 1) {
            mapValSpec = mapKeyValSpecs[1].split(",");
        }
        int i = 0;
        ArrayList<Integer> fieldList = new ArrayList<Integer>();
        this.extractFields(mapKeySpec, fieldList);
        this.mapOutputKeyFieldList = new int[fieldList.size()];
        for (i = 0; i < fieldList.size(); ++i) {
            this.mapOutputKeyFieldList[i] = fieldList.get(i);
        }
        fieldList = new ArrayList();
        this.allMapValueFieldsFrom = this.extractFields(mapValSpec, fieldList);
        this.mapOutputValueFieldList = new int[fieldList.size()];
        for (i = 0; i < fieldList.size(); ++i) {
            this.mapOutputValueFieldList[i] = fieldList.get(i);
        }
        String[] reduceKeyValSpecs = this.reduceOutputKeyValueSpec.split(":", -1);
        String[] reduceKeySpec = reduceKeyValSpecs[0].split(",");
        String[] reduceValSpec = new String[]{};
        if (reduceKeyValSpecs.length > 1) {
            reduceValSpec = reduceKeyValSpecs[1].split(",");
        }
        fieldList = new ArrayList();
        this.extractFields(reduceKeySpec, fieldList);
        this.reduceOutputKeyFieldList = new int[fieldList.size()];
        for (i = 0; i < fieldList.size(); ++i) {
            this.reduceOutputKeyFieldList[i] = fieldList.get(i);
        }
        fieldList = new ArrayList();
        this.allReduceValueFieldsFrom = this.extractFields(reduceValSpec, fieldList);
        this.reduceOutputValueFieldList = new int[fieldList.size()];
        for (i = 0; i < fieldList.size(); ++i) {
            this.reduceOutputValueFieldList[i] = fieldList.get(i);
        }
    }

    @Override
    public void configure(JobConf job) {
        this.fieldSeparator = job.get("mapred.data.field.separator", "\t");
        this.mapOutputKeyValueSpec = job.get("map.output.key.value.fields.spec", "0-:");
        this.ignoreInputKey = TextInputFormat.class.getCanonicalName().equals(job.getInputFormat().getClass().getCanonicalName());
        this.reduceOutputKeyValueSpec = job.get("reduce.output.key.value.fields.spec", "0-:");
        this.parseOutputKeyValueSpec();
        LOG.info(this.specToString());
    }

    @Override
    public void close() throws IOException {
    }

    private static String selectFields(String[] fields, int[] fieldList, int allFieldsFrom, String separator) {
        String retv = null;
        int i = 0;
        StringBuffer sb = null;
        if (fieldList != null && fieldList.length > 0) {
            if (sb == null) {
                sb = new StringBuffer();
            }
            for (i = 0; i < fieldList.length; ++i) {
                if (fieldList[i] < fields.length) {
                    sb.append(fields[fieldList[i]]);
                }
                sb.append(separator);
            }
        }
        if (allFieldsFrom >= 0) {
            if (sb == null) {
                sb = new StringBuffer();
            }
            for (i = allFieldsFrom; i < fields.length; ++i) {
                sb.append(fields[i]).append(separator);
            }
        }
        if (sb != null && (retv = sb.toString()).length() > 0) {
            retv = retv.substring(0, retv.length() - 1);
        }
        return retv;
    }

    @Override
    public void reduce(Text key, Iterator<Text> values, OutputCollector<Text, Text> output, Reporter reporter) throws IOException {
        String keyStr = key.toString() + this.fieldSeparator;
        while (values.hasNext()) {
            String valStr = values.next().toString();
            valStr = keyStr + valStr;
            String[] fields = valStr.split(this.fieldSeparator);
            String newKey = FieldSelectionMapReduce.selectFields(fields, this.reduceOutputKeyFieldList, -1, this.fieldSeparator);
            String newVal = FieldSelectionMapReduce.selectFields(fields, this.reduceOutputValueFieldList, this.allReduceValueFieldsFrom, this.fieldSeparator);
            Text newTextKey = null;
            if (newKey != null) {
                newTextKey = new Text(newKey);
            }
            Text newTextVal = null;
            if (newVal != null) {
                newTextVal = new Text(newVal);
            }
            output.collect(newTextKey, newTextVal);
        }
    }
}

