/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.$internal.org.apache.hadoop.mapred.join;

import com.facebook.presto.hive.$internal.org.apache.hadoop.io.WritableComparator;
import com.facebook.presto.hive.$internal.org.apache.hadoop.mapred.FileInputFormat;
import com.facebook.presto.hive.$internal.org.apache.hadoop.mapred.InputFormat;
import com.facebook.presto.hive.$internal.org.apache.hadoop.mapred.InputSplit;
import com.facebook.presto.hive.$internal.org.apache.hadoop.mapred.JobConf;
import com.facebook.presto.hive.$internal.org.apache.hadoop.mapred.RecordReader;
import com.facebook.presto.hive.$internal.org.apache.hadoop.mapred.Reporter;
import com.facebook.presto.hive.$internal.org.apache.hadoop.mapred.join.ComposableInputFormat;
import com.facebook.presto.hive.$internal.org.apache.hadoop.mapred.join.ComposableRecordReader;
import com.facebook.presto.hive.$internal.org.apache.hadoop.mapred.join.CompositeInputSplit;
import com.facebook.presto.hive.$internal.org.apache.hadoop.mapred.join.CompositeRecordReader;
import com.facebook.presto.hive.$internal.org.apache.hadoop.util.ReflectionUtils;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Stack;

public class Parser {
    private static Token reduce(Stack<Token> st, JobConf job) throws IOException {
        LinkedList<Token> args = new LinkedList<Token>();
        while (!st.isEmpty() && !TType.LPAREN.equals((Object)st.peek().getType())) {
            args.addFirst(st.pop());
        }
        if (st.isEmpty()) {
            throw new IOException("Unmatched ')'");
        }
        st.pop();
        if (st.isEmpty() || !TType.IDENT.equals((Object)st.peek().getType())) {
            throw new IOException("Identifier expected");
        }
        Node n = Node.forIdent(st.pop().getStr());
        n.parse(args, job);
        return new NodeToken(n);
    }

    static Node parse(String expr, JobConf job) throws IOException {
        Token tok;
        if (null == expr) {
            throw new IOException("Expression is null");
        }
        Class<WritableComparator> cmpcl = job.getClass("mapred.join.keycomparator", null, WritableComparator.class);
        Lexer lex = new Lexer(expr);
        Stack<Token> st = new Stack<Token>();
        while ((tok = lex.next()) != null) {
            if (TType.RPAREN.equals((Object)tok.getType())) {
                st.push(Parser.reduce(st, job));
                continue;
            }
            st.push(tok);
        }
        if (st.size() == 1 && TType.CIF.equals((Object)((Token)st.peek()).getType())) {
            Node ret = st.pop().getNode();
            if (cmpcl != null) {
                ret.setKeyComparator(cmpcl);
            }
            return ret;
        }
        throw new IOException("Missing ')'");
    }

    static class CNode
    extends Node {
        private static final Class<?>[] cstrSig = new Class[]{Integer.TYPE, JobConf.class, Integer.TYPE, Class.class};
        private ArrayList<Node> kids = new ArrayList();

        static void addIdentifier(String ident, Class<? extends ComposableRecordReader> cl) throws NoSuchMethodException {
            Node.addIdentifier(ident, cstrSig, CNode.class, cl);
        }

        public CNode(String ident) {
            super(ident);
        }

        @Override
        public void setKeyComparator(Class<? extends WritableComparator> cmpcl) {
            super.setKeyComparator(cmpcl);
            for (Node n : this.kids) {
                n.setKeyComparator(cmpcl);
            }
        }

        @Override
        public InputSplit[] getSplits(JobConf job, int numSplits) throws IOException {
            InputSplit[][] splits = new InputSplit[this.kids.size()][];
            for (int i = 0; i < this.kids.size(); ++i) {
                InputSplit[] tmp = this.kids.get(i).getSplits(job, numSplits);
                if (null == tmp) {
                    throw new IOException("Error gathering splits from child RReader");
                }
                if (i > 0 && splits[i - 1].length != tmp.length) {
                    throw new IOException("Inconsistent split cardinality from child " + i + " (" + splits[i - 1].length + "/" + tmp.length + ")");
                }
                splits[i] = tmp;
            }
            int size = splits[0].length;
            InputSplit[] ret = new CompositeInputSplit[size];
            for (int i = 0; i < size; ++i) {
                ret[i] = new CompositeInputSplit(splits.length);
                for (int j = 0; j < splits.length; ++j) {
                    ((CompositeInputSplit)ret[i]).add(splits[j][i]);
                }
            }
            return ret;
        }

        public ComposableRecordReader getRecordReader(InputSplit split, JobConf job, Reporter reporter) throws IOException {
            if (!(split instanceof CompositeInputSplit)) {
                throw new IOException("Invalid split type:" + split.getClass().getName());
            }
            CompositeInputSplit spl = (CompositeInputSplit)split;
            int capacity = this.kids.size();
            CompositeRecordReader ret = null;
            try {
                if (!rrCstrMap.containsKey(this.ident)) {
                    throw new IOException("No RecordReader for " + this.ident);
                }
                ret = (CompositeRecordReader)((Constructor)rrCstrMap.get(this.ident)).newInstance(this.id, job, capacity, this.cmpcl);
            }
            catch (IllegalAccessException e) {
                throw (IOException)new IOException().initCause(e);
            }
            catch (InstantiationException e) {
                throw (IOException)new IOException().initCause(e);
            }
            catch (InvocationTargetException e) {
                throw (IOException)new IOException().initCause(e);
            }
            for (int i = 0; i < capacity; ++i) {
                ret.add(this.kids.get(i).getRecordReader(spl.get(i), job, reporter));
            }
            return (ComposableRecordReader)((Object)ret);
        }

        @Override
        public void parse(List<Token> args, JobConf job) throws IOException {
            ListIterator<Token> i = args.listIterator();
            while (i.hasNext()) {
                Token t = i.next();
                t.getNode().setID(i.previousIndex() >> 1);
                this.kids.add(t.getNode());
                if (!i.hasNext() || TType.COMMA.equals((Object)i.next().getType())) continue;
                throw new IOException("Expected ','");
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.ident + "(");
            for (Node n : this.kids) {
                sb.append(n.toString() + ",");
            }
            sb.setCharAt(sb.length() - 1, ')');
            return sb.toString();
        }
    }

    static class WNode
    extends Node {
        private static final Class<?>[] cstrSig = new Class[]{Integer.TYPE, RecordReader.class, Class.class};
        private String indir;
        private InputFormat inf;

        static void addIdentifier(String ident, Class<? extends ComposableRecordReader> cl) throws NoSuchMethodException {
            Node.addIdentifier(ident, cstrSig, WNode.class, cl);
        }

        public WNode(String ident) {
            super(ident);
        }

        @Override
        public void parse(List<Token> ll, JobConf job) throws IOException {
            Token t;
            StringBuilder sb = new StringBuilder();
            Iterator<Token> i = ll.iterator();
            while (i.hasNext()) {
                t = i.next();
                if (TType.COMMA.equals((Object)t.getType())) {
                    try {
                        this.inf = (InputFormat)ReflectionUtils.newInstance(job.getClassByName(sb.toString()), job);
                        break;
                    }
                    catch (ClassNotFoundException e) {
                        throw (IOException)new IOException().initCause(e);
                    }
                    catch (IllegalArgumentException e) {
                        throw (IOException)new IOException().initCause(e);
                    }
                }
                sb.append(t.getStr());
            }
            if (!i.hasNext()) {
                throw new IOException("Parse error");
            }
            t = i.next();
            if (!TType.QUOT.equals((Object)t.getType())) {
                throw new IOException("Expected quoted string");
            }
            this.indir = t.getStr();
        }

        private JobConf getConf(JobConf job) {
            JobConf conf = new JobConf(job);
            FileInputFormat.setInputPaths(conf, this.indir);
            return conf;
        }

        @Override
        public InputSplit[] getSplits(JobConf job, int numSplits) throws IOException {
            return this.inf.getSplits(this.getConf(job), numSplits);
        }

        public ComposableRecordReader getRecordReader(InputSplit split, JobConf job, Reporter reporter) throws IOException {
            try {
                if (!rrCstrMap.containsKey(this.ident)) {
                    throw new IOException("No RecordReader for " + this.ident);
                }
                return (ComposableRecordReader)((Constructor)rrCstrMap.get(this.ident)).newInstance(this.id, this.inf.getRecordReader(split, this.getConf(job), reporter), this.cmpcl);
            }
            catch (IllegalAccessException e) {
                throw (IOException)new IOException().initCause(e);
            }
            catch (InstantiationException e) {
                throw (IOException)new IOException().initCause(e);
            }
            catch (InvocationTargetException e) {
                throw (IOException)new IOException().initCause(e);
            }
        }

        public String toString() {
            return this.ident + "(" + this.inf.getClass().getName() + ",\"" + this.indir + "\")";
        }
    }

    public static abstract class Node
    implements ComposableInputFormat {
        private static final Class<?>[] ncstrSig = new Class[]{String.class};
        private static final Map<String, Constructor<? extends Node>> nodeCstrMap = new HashMap<String, Constructor<? extends Node>>();
        protected static final Map<String, Constructor<? extends ComposableRecordReader>> rrCstrMap = new HashMap<String, Constructor<? extends ComposableRecordReader>>();
        protected int id = -1;
        protected String ident;
        protected Class<? extends WritableComparator> cmpcl;

        static Node forIdent(String ident) throws IOException {
            try {
                if (!nodeCstrMap.containsKey(ident)) {
                    throw new IOException("No nodetype for " + ident);
                }
                return nodeCstrMap.get(ident).newInstance(ident);
            }
            catch (IllegalAccessException e) {
                throw (IOException)new IOException().initCause(e);
            }
            catch (InstantiationException e) {
                throw (IOException)new IOException().initCause(e);
            }
            catch (InvocationTargetException e) {
                throw (IOException)new IOException().initCause(e);
            }
        }

        protected static void addIdentifier(String ident, Class<?>[] mcstrSig, Class<? extends Node> nodetype, Class<? extends ComposableRecordReader> cl) throws NoSuchMethodException {
            Constructor<? extends Node> ncstr = nodetype.getDeclaredConstructor(ncstrSig);
            ncstr.setAccessible(true);
            nodeCstrMap.put(ident, ncstr);
            Constructor<? extends ComposableRecordReader> mcstr = cl.getDeclaredConstructor(mcstrSig);
            mcstr.setAccessible(true);
            rrCstrMap.put(ident, mcstr);
        }

        protected Node(String ident) {
            this.ident = ident;
        }

        protected void setID(int id) {
            this.id = id;
        }

        protected void setKeyComparator(Class<? extends WritableComparator> cmpcl) {
            this.cmpcl = cmpcl;
        }

        abstract void parse(List<Token> var1, JobConf var2) throws IOException;
    }

    private static class Lexer {
        private StreamTokenizer tok;

        Lexer(String s) {
            this.tok = new StreamTokenizer(new CharArrayReader(s.toCharArray()));
            this.tok.quoteChar(34);
            this.tok.parseNumbers();
            this.tok.ordinaryChar(44);
            this.tok.ordinaryChar(40);
            this.tok.ordinaryChar(41);
            this.tok.wordChars(36, 36);
            this.tok.wordChars(95, 95);
        }

        Token next() throws IOException {
            int type = this.tok.nextToken();
            switch (type) {
                case -1: 
                case 10: {
                    return null;
                }
                case -2: {
                    return new NumToken(this.tok.nval);
                }
                case -3: {
                    return new StrToken(TType.IDENT, this.tok.sval);
                }
                case 34: {
                    return new StrToken(TType.QUOT, this.tok.sval);
                }
            }
            switch (type) {
                case 44: {
                    return new Token(TType.COMMA);
                }
                case 40: {
                    return new Token(TType.LPAREN);
                }
                case 41: {
                    return new Token(TType.RPAREN);
                }
            }
            throw new IOException("Unexpected: " + type);
        }
    }

    public static class StrToken
    extends Token {
        private String str;

        public StrToken(TType type, String str) {
            super(type);
            this.str = str;
        }

        @Override
        public String getStr() {
            return this.str;
        }
    }

    public static class NodeToken
    extends Token {
        private Node node;

        NodeToken(Node node) {
            super(TType.CIF);
            this.node = node;
        }

        @Override
        public Node getNode() {
            return this.node;
        }
    }

    public static class NumToken
    extends Token {
        private double num;

        public NumToken(double num) {
            super(TType.NUM);
            this.num = num;
        }

        @Override
        public double getNum() {
            return this.num;
        }
    }

    public static class Token {
        private TType type;

        Token(TType type) {
            this.type = type;
        }

        public TType getType() {
            return this.type;
        }

        public Node getNode() throws IOException {
            throw new IOException("Expected nodetype");
        }

        public double getNum() throws IOException {
            throw new IOException("Expected numtype");
        }

        public String getStr() throws IOException {
            throw new IOException("Expected strtype");
        }
    }

    public static enum TType {
        CIF,
        IDENT,
        COMMA,
        LPAREN,
        RPAREN,
        QUOT,
        NUM;

    }
}

