/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.$internal.org.apache.hadoop.mapred;

import com.facebook.presto.hive.$internal.org.apache.hadoop.mapred.ClusterStatus;
import com.facebook.presto.hive.$internal.org.apache.hadoop.mapred.JSPUtil;
import com.facebook.presto.hive.$internal.org.apache.hadoop.mapred.JobInProgress;
import com.facebook.presto.hive.$internal.org.apache.hadoop.mapred.JobQueueInfo;
import com.facebook.presto.hive.$internal.org.apache.hadoop.mapred.JobTracker;
import com.facebook.presto.hive.$internal.org.apache.hadoop.util.ServletUtil;
import com.facebook.presto.hive.$internal.org.apache.hadoop.util.StringUtils;
import com.facebook.presto.hive.$internal.org.apache.hadoop.util.VersionInfo;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspFactory;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.SkipPageException;
import org.apache.jasper.runtime.HttpJspBase;
import org.apache.jasper.runtime.JspSourceDependent;

public final class jobtracker_jsp
extends HttpJspBase
implements JspSourceDependent {
    private static final long serialVersionUID = 1L;
    private static DecimalFormat percentFormat = new DecimalFormat("##0.00");
    private static List _jspx_dependants;

    public void generateSummaryTable(JspWriter out, ClusterStatus status, JobTracker tracker) throws IOException {
        String tasksPerNode = status.getTaskTrackers() > 0 ? percentFormat.format((double)(status.getMaxMapTasks() + status.getMaxReduceTasks()) / (double)status.getTaskTrackers()) : "-";
        out.print("<table border=\"1\" cellpadding=\"5\" cellspacing=\"0\">\n<tr><th>Maps</th><th>Reduces</th><th>Total Submissions</th><th>Nodes</th><th>Map Task Capacity</th><th>Reduce Task Capacity</th><th>Avg. Tasks/Node</th><th>Blacklisted Nodes</th></tr>\n");
        out.print("<tr><td>" + status.getMapTasks() + "</td><td>" + status.getReduceTasks() + "</td><td>" + tracker.getTotalSubmissions() + "</td><td><a href=\"machines.jsp?type=active\">" + status.getTaskTrackers() + "</a></td><td>" + status.getMaxMapTasks() + "</td><td>" + status.getMaxReduceTasks() + "</td><td>" + tasksPerNode + "</td><td><a href=\"machines.jsp?type=blacklisted\">" + status.getBlacklistedTrackers() + "</a>" + "</td></tr></table>\n");
        out.print("<br>");
        if (tracker.hasRestarted()) {
            out.print("<span class=\"small\"><i>");
            if (tracker.hasRecovered()) {
                out.print("The JobTracker got restarted and recovered back in ");
                out.print(StringUtils.formatTime(tracker.getRecoveryDuration()));
            } else {
                out.print("The JobTracker got restarted and is still recovering");
            }
            out.print("</i></span>");
        }
    }

    public Object getDependants() {
        return _jspx_dependants;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void _jspService(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        JspFactory _jspxFactory = null;
        PageContext pageContext = null;
        HttpSession session = null;
        ServletContext application = null;
        ServletConfig config = null;
        JspWriter out = null;
        jobtracker_jsp page = this;
        JspWriter _jspx_out = null;
        PageContext _jspx_page_context = null;
        try {
            _jspxFactory = JspFactory.getDefaultFactory();
            response.setContentType("text/html; charset=UTF-8");
            _jspx_page_context = pageContext = _jspxFactory.getPageContext((Servlet)this, (ServletRequest)request, (ServletResponse)response, null, true, 8192, true);
            application = pageContext.getServletContext();
            config = pageContext.getServletConfig();
            session = pageContext.getSession();
            _jspx_out = out = pageContext.getOut();
            out.write(10);
            out.write(10);
            JobTracker tracker = (JobTracker)application.getAttribute("job.tracker");
            ClusterStatus status = tracker.getClusterStatus();
            String trackerName = StringUtils.simpleHostname(tracker.getJobTrackerMachine());
            JobQueueInfo[] queues = tracker.getQueues();
            Vector<JobInProgress> runningJobs = tracker.runningJobs();
            Vector<JobInProgress> completedJobs = tracker.completedJobs();
            Vector<JobInProgress> failedJobs = tracker.failedJobs();
            out.write(10);
            out.write("\n\n\n<html>\n<head>\n<title>");
            out.print(trackerName);
            out.write(" Hadoop Map/Reduce Administration</title>\n<link rel=\"stylesheet\" type=\"text/css\" href=\"/static/hadoop.css\">\n<script type=\"text/javascript\" src=\"/static/jobtracker.js\"></script>\n</head>\n<body>\n\n");
            JSPUtil.processButtons(request, response, tracker);
            out.write("\n\n<h1>");
            out.print(trackerName);
            out.write(" Hadoop Map/Reduce Administration</h1>\n\n<div id=\"quicklinks\">\n  <a href=\"#quicklinks\" onclick=\"toggle('quicklinks-list'); return false;\">Quick Links</a>\n  <ul id=\"quicklinks-list\">\n    <li><a href=\"#scheduling_info\">Scheduling Info</a></li>\n    <li><a href=\"#running_jobs\">Running Jobs</a></li>\n    <li><a href=\"#completed_jobs\">Completed Jobs</a></li>\n    <li><a href=\"#failed_jobs\">Failed Jobs</a></li>\n    <li><a href=\"#local_logs\">Local Logs</a></li>\n  </ul>\n</div>\n\n<b>State:</b> ");
            out.print((Object)status.getJobTrackerState());
            out.write("<br>\n<b>Started:</b> ");
            out.print((Object)new Date(tracker.getStartTime()));
            out.write("<br>\n<b>Version:</b> ");
            out.print(VersionInfo.getVersion());
            out.write(",\n                r");
            out.print(VersionInfo.getRevision());
            out.write("<br>\n<b>Compiled:</b> ");
            out.print(VersionInfo.getDate());
            out.write(" by \n                 ");
            out.print(VersionInfo.getUser());
            out.write("<br>\n<b>Identifier:</b> ");
            out.print(tracker.getTrackerIdentifier());
            out.write("<br>                 \n                   \n<hr>\n<h2>Cluster Summary (Heap Size is ");
            out.print(StringUtils.byteDesc(status.getUsedMemory()));
            out.write(47);
            out.print(StringUtils.byteDesc(status.getMaxMemory()));
            out.write(")</h2>\n");
            this.generateSummaryTable(out, status, tracker);
            out.write("\n<hr>\n<h2 id=\"scheduling_info\">Scheduling Information</h2>\n<table border=\"2\" cellpadding=\"5\" cellspacing=\"2\">\n<thead style=\"font-weight: bold\">\n<tr>\n<td> Queue Name </td>\n<td> Scheduling Information</td>\n</tr>\n</thead>\n<tbody>\n");
            for (JobQueueInfo queue : queues) {
                String queueName = queue.getQueueName();
                String schedulingInformation = queue.getSchedulingInfo();
                if (schedulingInformation == null || schedulingInformation.trim().equals("")) {
                    schedulingInformation = "NA";
                }
                out.write("\n<tr>\n<td><a href=\"jobqueue_details.jsp?queueName=");
                out.print(queueName);
                out.write(34);
                out.write(62);
                out.print(queueName);
                out.write("</a></td>\n<td>");
                out.print(schedulingInformation.replaceAll("\n", "<br/>"));
                out.write("\n</td>\n</tr>\n");
            }
            out.write("\n</tbody>\n</table>\n<hr/>\n<b>Filter (Jobid, Priority, User, Name)</b> <input type=\"text\" id=\"filter\" onkeyup=\"applyfilter()\"> <br>\n<span class=\"small\">Example: 'user:smith 3200' will filter by 'smith' only in the user field and '3200' in all fields</span>\n<hr>\n\n<h2 id=\"running_jobs\">Running Jobs</h2>\n");
            out.print(JSPUtil.generateJobTable("Running", runningJobs, 30, 0));
            out.write("\n<hr>\n\n<h2 id=\"completed_jobs\">Completed Jobs</h2>\n");
            out.print(JSPUtil.generateJobTable("Completed", completedJobs, 0, runningJobs.size()));
            out.write("\n<hr>\n\n<h2 id=\"failed_jobs\">Failed Jobs</h2>\n");
            out.print(JSPUtil.generateJobTable("Failed", failedJobs, 0, runningJobs.size() + completedJobs.size()));
            out.write("\n<hr>\n\n<h2 id=\"local_logs\">Local Logs</h2>\n<a href=\"logs/\">Log</a> directory, <a href=\"jobhistory.jsp\">\nJob Tracker History</a>\n\n");
            out.println(ServletUtil.htmlFooter());
            out.write(10);
            if (_jspxFactory == null) return;
        }
        catch (Throwable t) {
            try {
                if (t instanceof SkipPageException) return;
                out = _jspx_out;
                if (out != null && out.getBufferSize() != 0) {
                    out.clearBuffer();
                }
                if (_jspx_page_context == null) return;
                _jspx_page_context.handlePageException(t);
                return;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                if (_jspxFactory != null) {
                    _jspxFactory.releasePageContext(_jspx_page_context);
                }
            }
        }
        _jspxFactory.releasePageContext(_jspx_page_context);
        return;
    }
}

