/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.$internal.org.apache.hadoop.mapred;

import com.facebook.presto.hive.$internal.org.apache.hadoop.mapred.JobID;
import com.facebook.presto.hive.$internal.org.apache.hadoop.mapred.JobInProgress;
import com.facebook.presto.hive.$internal.org.apache.hadoop.mapred.JobTracker;
import com.facebook.presto.hive.$internal.org.apache.hadoop.mapred.TaskID;
import com.facebook.presto.hive.$internal.org.apache.hadoop.mapred.TaskInProgress;
import com.facebook.presto.hive.$internal.org.apache.hadoop.mapred.TaskLogServlet;
import com.facebook.presto.hive.$internal.org.apache.hadoop.mapred.TaskStatus;
import com.facebook.presto.hive.$internal.org.apache.hadoop.mapred.TaskTrackerStatus;
import com.facebook.presto.hive.$internal.org.apache.hadoop.util.ServletUtil;
import com.facebook.presto.hive.$internal.org.apache.hadoop.util.StringUtils;
import java.io.IOException;
import java.util.List;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspFactory;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.SkipPageException;
import org.apache.jasper.runtime.HttpJspBase;
import org.apache.jasper.runtime.JspSourceDependent;

public final class jobfailures_jsp
extends HttpJspBase
implements JspSourceDependent {
    private static final long serialVersionUID = 1L;
    private static List _jspx_dependants;

    private void printFailedAttempts(JspWriter out, JobTracker tracker, JobID jobId, TaskInProgress tip, TaskStatus.State failState) throws IOException {
        TaskStatus[] statuses = tip.getTaskStatuses();
        TaskID tipId = tip.getTIPId();
        for (int i = 0; i < statuses.length; ++i) {
            TaskStatus.State taskState = statuses[i].getRunState();
            if ((failState != null || taskState != TaskStatus.State.FAILED && taskState != TaskStatus.State.KILLED) && taskState != failState) continue;
            String taskTrackerName = statuses[i].getTaskTracker();
            TaskTrackerStatus taskTracker = tracker.getTaskTracker(taskTrackerName);
            out.print("<tr><td>" + statuses[i].getTaskID() + "</td><td><a href=\"taskdetails.jsp?jobid=" + jobId + "&tipid=" + tipId + "\">" + tipId + "</a></td>");
            if (taskTracker == null) {
                out.print("<td>" + taskTrackerName + "</td>");
            } else {
                out.print("<td><a href=\"http://" + taskTracker.getHost() + ":" + taskTracker.getHttpPort() + "\">" + taskTracker.getHost() + "</a></td>");
            }
            out.print("<td>" + (Object)((Object)taskState) + "</td>");
            out.print("<td><pre>");
            String[] failures = tracker.getTaskDiagnostics(statuses[i].getTaskID());
            if (failures == null) {
                out.print("&nbsp;");
            } else {
                for (int j = 0; j < failures.length; ++j) {
                    out.print(failures[j]);
                    if (j >= failures.length - 1) continue;
                    out.print("\n-------\n");
                }
            }
            out.print("</pre></td>");
            out.print("<td>");
            String taskLogUrl = null;
            if (taskTracker != null) {
                taskLogUrl = TaskLogServlet.getTaskLogUrl(taskTracker.getHost(), String.valueOf(taskTracker.getHttpPort()), statuses[i].getTaskID().toString());
            }
            if (taskLogUrl != null) {
                String tailFourKBUrl = taskLogUrl + "&start=-4097";
                String tailEightKBUrl = taskLogUrl + "&start=-8193";
                String entireLogUrl = taskLogUrl;
                out.print("<a href=\"" + tailFourKBUrl + "\">Last 4KB</a><br/>");
                out.print("<a href=\"" + tailEightKBUrl + "\">Last 8KB</a><br/>");
                out.print("<a href=\"" + entireLogUrl + "\">All</a><br/>");
            } else {
                out.print("n/a");
            }
            out.print("</td>");
            out.print("</tr>\n");
        }
    }

    private void printFailures(JspWriter out, JobTracker tracker, JobID jobId, String kind, String cause) throws IOException {
        int i;
        TaskInProgress[] tips;
        JobInProgress job = tracker.getJob(jobId);
        if (job == null) {
            out.print("<b>Job " + jobId + " not found.</b><br>\n");
            return;
        }
        boolean includeMap = false;
        boolean includeReduce = false;
        if (kind == null) {
            includeMap = true;
            includeReduce = true;
        } else if ("map".equals(kind)) {
            includeMap = true;
        } else if ("reduce".equals(kind)) {
            includeReduce = true;
        } else if ("all".equals(kind)) {
            includeMap = true;
            includeReduce = true;
        } else {
            out.print("<b>Kind " + kind + " not supported.</b><br>\n");
            return;
        }
        TaskStatus.State state = null;
        try {
            if (cause != null && (state = TaskStatus.State.valueOf(cause.toUpperCase())) != TaskStatus.State.FAILED && state != TaskStatus.State.KILLED) {
                out.print("<b>Cause '" + cause + "' is not an 'unsuccessful' state.</b><br>\n");
                return;
            }
        }
        catch (IllegalArgumentException e) {
            out.print("<b>Cause '" + cause + "' not supported.</b><br>\n");
            return;
        }
        out.print("<table border=2 cellpadding=\"5\" cellspacing=\"2\">");
        out.print("<tr><th>Attempt</th><th>Task</th><th>Machine</th><th>State</th><th>Error</th><th>Logs</th></tr>\n");
        if (includeMap) {
            tips = job.getMapTasks();
            for (i = 0; i < tips.length; ++i) {
                this.printFailedAttempts(out, tracker, jobId, tips[i], state);
            }
        }
        if (includeReduce) {
            tips = job.getReduceTasks();
            for (i = 0; i < tips.length; ++i) {
                this.printFailedAttempts(out, tracker, jobId, tips[i], state);
            }
        }
        out.print("</table>\n");
    }

    public Object getDependants() {
        return _jspx_dependants;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void _jspService(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String jobId;
        String trackerName;
        JobTracker tracker;
        PageContext _jspx_page_context;
        JspWriter _jspx_out;
        JspWriter out;
        JspFactory _jspxFactory;
        block8: {
            _jspxFactory = null;
            PageContext pageContext = null;
            HttpSession session = null;
            ServletContext application = null;
            ServletConfig config = null;
            out = null;
            jobfailures_jsp page = this;
            _jspx_out = null;
            _jspx_page_context = null;
            _jspxFactory = JspFactory.getDefaultFactory();
            response.setContentType("text/html; charset=UTF-8");
            _jspx_page_context = pageContext = _jspxFactory.getPageContext((Servlet)this, (ServletRequest)request, (ServletResponse)response, null, true, 8192, true);
            application = pageContext.getServletContext();
            config = pageContext.getServletConfig();
            session = pageContext.getSession();
            _jspx_out = out = pageContext.getOut();
            out.write(10);
            out.write(10);
            out.write(10);
            out.write(10);
            tracker = (JobTracker)application.getAttribute("job.tracker");
            trackerName = StringUtils.simpleHostname(tracker.getJobTrackerMachine());
            out.write(10);
            out.write(10);
            out.write(10);
            jobId = request.getParameter("jobid");
            if (jobId != null) break block8;
            out.println("<h2>Missing 'jobid'!</h2>");
            if (_jspxFactory == null) return;
            _jspxFactory.releasePageContext(_jspx_page_context);
            return;
        }
        try {
            JobID jobIdObj = JobID.forName(jobId);
            String kind = request.getParameter("kind");
            String cause = request.getParameter("cause");
            out.write("\n\n<html>\n<title>Hadoop ");
            out.print(jobId);
            out.write(" failures on ");
            out.print(trackerName);
            out.write("</title>\n<body>\n<h1>Hadoop <a href=\"jobdetails.jsp?jobid=");
            out.print(jobId);
            out.write(34);
            out.write(62);
            out.print(jobId);
            out.write("</a>\nfailures on <a href=\"jobtracker.jsp\">");
            out.print(trackerName);
            out.write("</a></h1>\n\n");
            this.printFailures(out, tracker, jobIdObj, kind, cause);
            out.write("\n\n<hr>\n<a href=\"jobtracker.jsp\">Go back to JobTracker</a><br>\n");
            out.println(ServletUtil.htmlFooter());
            out.write(10);
            if (_jspxFactory == null) return;
        }
        catch (Throwable t) {
            try {
                if (t instanceof SkipPageException) return;
                out = _jspx_out;
                if (out != null && out.getBufferSize() != 0) {
                    out.clearBuffer();
                }
                if (_jspx_page_context == null) return;
                _jspx_page_context.handlePageException(t);
                return;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                if (_jspxFactory != null) {
                    _jspxFactory.releasePageContext(_jspx_page_context);
                }
            }
        }
        _jspxFactory.releasePageContext(_jspx_page_context);
        return;
    }
}

