/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.$internal.org.apache.hadoop.mapred;

import com.facebook.presto.hive.$internal.org.apache.hadoop.io.UTF8;
import com.facebook.presto.hive.$internal.org.apache.hadoop.io.Writable;
import com.facebook.presto.hive.$internal.org.apache.hadoop.io.WritableFactories;
import com.facebook.presto.hive.$internal.org.apache.hadoop.io.WritableFactory;
import com.facebook.presto.hive.$internal.org.apache.hadoop.io.WritableUtils;
import com.facebook.presto.hive.$internal.org.apache.hadoop.mapred.TaskStatus;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

class TaskTrackerStatus
implements Writable {
    String trackerName;
    String host;
    int httpPort;
    int failures;
    List<TaskStatus> taskReports;
    volatile long lastSeen;
    private int maxMapTasks;
    private int maxReduceTasks;
    private ResourceStatus resStatus;

    public TaskTrackerStatus() {
        this.taskReports = new ArrayList<TaskStatus>();
        this.resStatus = new ResourceStatus();
    }

    public TaskTrackerStatus(String trackerName, String host, int httpPort, List<TaskStatus> taskReports, int failures, int maxMapTasks, int maxReduceTasks) {
        this.trackerName = trackerName;
        this.host = host;
        this.httpPort = httpPort;
        this.taskReports = new ArrayList<TaskStatus>(taskReports);
        this.failures = failures;
        this.maxMapTasks = maxMapTasks;
        this.maxReduceTasks = maxReduceTasks;
        this.resStatus = new ResourceStatus();
    }

    public String getTrackerName() {
        return this.trackerName;
    }

    public String getHost() {
        return this.host;
    }

    public int getHttpPort() {
        return this.httpPort;
    }

    public int getFailures() {
        return this.failures;
    }

    public List<TaskStatus> getTaskReports() {
        return this.taskReports;
    }

    public int countMapTasks() {
        int mapCount = 0;
        for (TaskStatus ts : this.taskReports) {
            TaskStatus.State state = ts.getRunState();
            if (!ts.getIsMap() || state != TaskStatus.State.RUNNING && state != TaskStatus.State.UNASSIGNED && !ts.inTaskCleanupPhase()) continue;
            ++mapCount;
        }
        return mapCount;
    }

    public int countReduceTasks() {
        int reduceCount = 0;
        for (TaskStatus ts : this.taskReports) {
            TaskStatus.State state = ts.getRunState();
            if (ts.getIsMap() || state != TaskStatus.State.RUNNING && state != TaskStatus.State.UNASSIGNED && !ts.inTaskCleanupPhase()) continue;
            ++reduceCount;
        }
        return reduceCount;
    }

    public long getLastSeen() {
        return this.lastSeen;
    }

    public void setLastSeen(long lastSeen) {
        this.lastSeen = lastSeen;
    }

    public int getMaxMapTasks() {
        return this.maxMapTasks;
    }

    public int getMaxReduceTasks() {
        return this.maxReduceTasks;
    }

    ResourceStatus getResourceStatus() {
        return this.resStatus;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        UTF8.writeString(out, this.trackerName);
        UTF8.writeString(out, this.host);
        out.writeInt(this.httpPort);
        out.writeInt(this.failures);
        out.writeInt(this.maxMapTasks);
        out.writeInt(this.maxReduceTasks);
        this.resStatus.write(out);
        out.writeInt(this.taskReports.size());
        for (TaskStatus taskStatus : this.taskReports) {
            TaskStatus.writeTaskStatus(out, taskStatus);
        }
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.trackerName = UTF8.readString(in);
        this.host = UTF8.readString(in);
        this.httpPort = in.readInt();
        this.failures = in.readInt();
        this.maxMapTasks = in.readInt();
        this.maxReduceTasks = in.readInt();
        this.resStatus.readFields(in);
        this.taskReports.clear();
        int numTasks = in.readInt();
        for (int i = 0; i < numTasks; ++i) {
            this.taskReports.add(TaskStatus.readTaskStatus(in));
        }
    }

    static {
        WritableFactories.setFactory(TaskTrackerStatus.class, new WritableFactory(){

            @Override
            public Writable newInstance() {
                return new TaskTrackerStatus();
            }
        });
    }

    static class ResourceStatus
    implements Writable {
        private long totalVirtualMemory = -1L;
        private long totalPhysicalMemory = -1L;
        private long mapSlotMemorySizeOnTT = -1L;
        private long reduceSlotMemorySizeOnTT = -1L;
        private long availableSpace = Long.MAX_VALUE;

        ResourceStatus() {
        }

        void setTotalVirtualMemory(long totalMem) {
            this.totalVirtualMemory = totalMem;
        }

        long getTotalVirtualMemory() {
            return this.totalVirtualMemory;
        }

        void setTotalPhysicalMemory(long totalRAM) {
            this.totalPhysicalMemory = totalRAM;
        }

        long getTotalPhysicalMemory() {
            return this.totalPhysicalMemory;
        }

        void setMapSlotMemorySizeOnTT(long mem) {
            this.mapSlotMemorySizeOnTT = mem;
        }

        long getMapSlotMemorySizeOnTT() {
            return this.mapSlotMemorySizeOnTT;
        }

        void setReduceSlotMemorySizeOnTT(long mem) {
            this.reduceSlotMemorySizeOnTT = mem;
        }

        long getReduceSlotMemorySizeOnTT() {
            return this.reduceSlotMemorySizeOnTT;
        }

        void setAvailableSpace(long availSpace) {
            this.availableSpace = availSpace;
        }

        long getAvailableSpace() {
            return this.availableSpace;
        }

        @Override
        public void write(DataOutput out) throws IOException {
            WritableUtils.writeVLong(out, this.totalVirtualMemory);
            WritableUtils.writeVLong(out, this.totalPhysicalMemory);
            WritableUtils.writeVLong(out, this.mapSlotMemorySizeOnTT);
            WritableUtils.writeVLong(out, this.reduceSlotMemorySizeOnTT);
            WritableUtils.writeVLong(out, this.availableSpace);
        }

        @Override
        public void readFields(DataInput in) throws IOException {
            this.totalVirtualMemory = WritableUtils.readVLong(in);
            this.totalPhysicalMemory = WritableUtils.readVLong(in);
            this.mapSlotMemorySizeOnTT = WritableUtils.readVLong(in);
            this.reduceSlotMemorySizeOnTT = WritableUtils.readVLong(in);
            this.availableSpace = WritableUtils.readVLong(in);
        }
    }
}

