/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.$internal.org.apache.hadoop.mapred;

import com.facebook.presto.hive.$internal.org.apache.commons.logging.Log;
import com.facebook.presto.hive.$internal.org.apache.commons.logging.LogFactory;
import com.facebook.presto.hive.$internal.org.apache.hadoop.conf.Configuration;
import com.facebook.presto.hive.$internal.org.apache.hadoop.fs.FileSystem;
import com.facebook.presto.hive.$internal.org.apache.hadoop.fs.FileUtil;
import com.facebook.presto.hive.$internal.org.apache.hadoop.fs.LocalFileSystem;
import com.facebook.presto.hive.$internal.org.apache.hadoop.fs.Path;
import com.facebook.presto.hive.$internal.org.apache.hadoop.mapred.JobConf;
import com.facebook.presto.hive.$internal.org.apache.hadoop.mapred.TaskAttemptID;
import com.facebook.presto.hive.$internal.org.apache.hadoop.mapred.TaskLogAppender;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.apache.log4j.Appender;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class TaskLog {
    private static final Log LOG = LogFactory.getLog(TaskLog.class.getName());
    private static final File LOG_DIR = new File(System.getProperty("hadoop.log.dir"), "userlogs").getAbsoluteFile();
    static LocalFileSystem localFS = null;
    private static long prevOutLength;
    private static long prevErrLength;
    private static long prevLogLength;
    private static volatile TaskAttemptID currentTaskid;
    private static final String bashCommand = "bash";
    private static final String tailCommand = "tail";

    public static File getTaskLogFile(TaskAttemptID taskid, LogName filter) {
        return new File(TaskLog.getBaseDir(taskid.toString()), filter.toString());
    }

    public static File getRealTaskLogFileLocation(TaskAttemptID taskid, LogName filter) {
        LogFileDetail l;
        try {
            l = TaskLog.getTaskLogFileDetail(taskid, filter);
        }
        catch (IOException ie) {
            LOG.error("getTaskLogFileDetail threw an exception " + ie);
            return null;
        }
        return new File(TaskLog.getBaseDir(l.location), filter.toString());
    }

    private static LogFileDetail getTaskLogFileDetail(TaskAttemptID taskid, LogName filter) throws IOException {
        return TaskLog.getLogFileDetail(taskid, filter, false);
    }

    private static LogFileDetail getLogFileDetail(TaskAttemptID taskid, LogName filter, boolean isCleanup) throws IOException {
        File indexFile = TaskLog.getIndexFile(taskid.toString(), isCleanup);
        BufferedReader fis = new BufferedReader(new FileReader(indexFile));
        LogFileDetail l = new LogFileDetail();
        String str = fis.readLine();
        if (str == null) {
            throw new IOException("Index file for the log of " + taskid + " doesn't exist.");
        }
        l.location = str.substring(str.indexOf("LOG_DIR:") + "LOG_DIR:".length());
        if (filter.equals((Object)LogName.DEBUGOUT) || filter.equals((Object)LogName.PROFILE)) {
            l.length = new File(TaskLog.getBaseDir(l.location), filter.toString()).length();
            l.start = 0L;
            fis.close();
            return l;
        }
        str = fis.readLine();
        while (str != null) {
            if (str.contains(filter.toString())) {
                str = str.substring(filter.toString().length() + 1);
                String[] startAndLen = str.split(" ");
                l.start = Long.parseLong(startAndLen[0]);
                l.length = Long.parseLong(startAndLen[1]);
                break;
            }
            str = fis.readLine();
        }
        fis.close();
        return l;
    }

    private static File getTmpIndexFile(String taskid) {
        return new File(TaskLog.getBaseDir(taskid), "log.tmp");
    }

    public static File getIndexFile(String taskid) {
        return TaskLog.getIndexFile(taskid, false);
    }

    public static File getIndexFile(String taskid, boolean isCleanup) {
        if (isCleanup) {
            return new File(TaskLog.getBaseDir(taskid), "log.index.cleanup");
        }
        return new File(TaskLog.getBaseDir(taskid), "log.index");
    }

    private static File getBaseDir(String taskid) {
        return new File(LOG_DIR, taskid);
    }

    private static void writeToIndexFile(TaskAttemptID firstTaskid, boolean isCleanup) throws IOException {
        File tmpIndexFile = TaskLog.getTmpIndexFile(currentTaskid.toString());
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(tmpIndexFile, false));
        DataOutputStream dos = new DataOutputStream(bos);
        dos.writeBytes("LOG_DIR:" + firstTaskid.toString() + "\n" + LogName.STDOUT.toString() + ":");
        dos.writeBytes(Long.toString(prevOutLength) + " ");
        dos.writeBytes(Long.toString(TaskLog.getTaskLogFile(firstTaskid, LogName.STDOUT).length() - prevOutLength) + "\n" + (Object)((Object)LogName.STDERR) + ":");
        dos.writeBytes(Long.toString(prevErrLength) + " ");
        dos.writeBytes(Long.toString(TaskLog.getTaskLogFile(firstTaskid, LogName.STDERR).length() - prevErrLength) + "\n" + LogName.SYSLOG.toString() + ":");
        dos.writeBytes(Long.toString(prevLogLength) + " ");
        dos.writeBytes(Long.toString(TaskLog.getTaskLogFile(firstTaskid, LogName.SYSLOG).length() - prevLogLength) + "\n");
        dos.close();
        File indexFile = TaskLog.getIndexFile(currentTaskid.toString(), isCleanup);
        Path indexFilePath = new Path(indexFile.getAbsolutePath());
        Path tmpIndexFilePath = new Path(tmpIndexFile.getAbsolutePath());
        localFS.rename(tmpIndexFilePath, indexFilePath);
    }

    private static void resetPrevLengths(TaskAttemptID firstTaskid) {
        prevOutLength = TaskLog.getTaskLogFile(firstTaskid, LogName.STDOUT).length();
        prevErrLength = TaskLog.getTaskLogFile(firstTaskid, LogName.STDERR).length();
        prevLogLength = TaskLog.getTaskLogFile(firstTaskid, LogName.SYSLOG).length();
    }

    public static synchronized void syncLogs(TaskAttemptID firstTaskid, TaskAttemptID taskid) throws IOException {
        TaskLog.syncLogs(firstTaskid, taskid, false);
    }

    public static synchronized void syncLogs(TaskAttemptID firstTaskid, TaskAttemptID taskid, boolean isCleanup) throws IOException {
        System.out.flush();
        System.err.flush();
        Enumeration allLoggers = LogManager.getCurrentLoggers();
        while (allLoggers.hasMoreElements()) {
            Logger l = (Logger)allLoggers.nextElement();
            Enumeration allAppenders = l.getAllAppenders();
            while (allAppenders.hasMoreElements()) {
                Appender a = (Appender)allAppenders.nextElement();
                if (!(a instanceof TaskLogAppender)) continue;
                ((TaskLogAppender)a).flush();
            }
        }
        if (currentTaskid != taskid) {
            currentTaskid = taskid;
            TaskLog.resetPrevLengths(firstTaskid);
        }
        TaskLog.writeToIndexFile(firstTaskid, isCleanup);
    }

    public static synchronized void cleanup(int logsRetainHours) throws IOException {
        long purgeTimeStamp = System.currentTimeMillis() - (long)logsRetainHours * 60L * 60L * 1000L;
        File[] oldTaskLogs = LOG_DIR.listFiles(new TaskLogsPurgeFilter(purgeTimeStamp));
        if (oldTaskLogs != null) {
            for (int i = 0; i < oldTaskLogs.length; ++i) {
                FileUtil.fullyDelete(oldTaskLogs[i]);
            }
        }
    }

    public static long getTaskLogLength(JobConf conf) {
        return conf.getLong("mapred.userlog.limit.kb", 100L) * 1024L;
    }

    public static List<String> captureOutAndError(List<String> cmd, File stdoutFilename, File stderrFilename, long tailLength) throws IOException {
        return TaskLog.captureOutAndError(null, cmd, stdoutFilename, stderrFilename, tailLength, null);
    }

    public static List<String> captureOutAndError(List<String> setup, List<String> cmd, File stdoutFilename, File stderrFilename, long tailLength) throws IOException {
        return TaskLog.captureOutAndError(setup, cmd, stdoutFilename, stderrFilename, tailLength, null);
    }

    public static List<String> captureOutAndError(List<String> setup, List<String> cmd, File stdoutFilename, File stderrFilename, long tailLength, String pidFileName) throws IOException {
        String stdout = FileUtil.makeShellPath(stdoutFilename);
        String stderr = FileUtil.makeShellPath(stderrFilename);
        ArrayList<String> result = new ArrayList<String>(3);
        result.add(bashCommand);
        result.add("-c");
        StringBuffer mergedCmd = new StringBuffer();
        if (pidFileName != null) {
            mergedCmd.append("echo $$ > ");
            mergedCmd.append(pidFileName);
            mergedCmd.append(" ;");
        }
        if (setup != null && setup.size() > 0) {
            mergedCmd.append(TaskLog.addCommand(setup, false));
            mergedCmd.append(";");
        }
        if (tailLength > 0L) {
            mergedCmd.append("(");
        } else {
            mergedCmd.append("exec ");
        }
        mergedCmd.append(TaskLog.addCommand(cmd, true));
        mergedCmd.append(" < /dev/null ");
        if (tailLength > 0L) {
            mergedCmd.append(" | ");
            mergedCmd.append(tailCommand);
            mergedCmd.append(" -c ");
            mergedCmd.append(tailLength);
            mergedCmd.append(" >> ");
            mergedCmd.append(stdout);
            mergedCmd.append(" ; exit $PIPESTATUS ) 2>&1 | ");
            mergedCmd.append(tailCommand);
            mergedCmd.append(" -c ");
            mergedCmd.append(tailLength);
            mergedCmd.append(" >> ");
            mergedCmd.append(stderr);
            mergedCmd.append(" ; exit $PIPESTATUS");
        } else {
            mergedCmd.append(" 1>> ");
            mergedCmd.append(stdout);
            mergedCmd.append(" 2>> ");
            mergedCmd.append(stderr);
        }
        result.add(mergedCmd.toString());
        return result;
    }

    public static String addCommand(List<String> cmd, boolean isExecutable) throws IOException {
        StringBuffer command = new StringBuffer();
        for (String s : cmd) {
            command.append('\'');
            if (isExecutable) {
                command.append(FileUtil.makeShellPath(new File(s)));
                isExecutable = false;
            } else {
                command.append(s);
            }
            command.append('\'');
            command.append(" ");
        }
        return command.toString();
    }

    public static List<String> captureDebugOut(List<String> cmd, File debugoutFilename) throws IOException {
        String debugout = FileUtil.makeShellPath(debugoutFilename);
        ArrayList<String> result = new ArrayList<String>(3);
        result.add(bashCommand);
        result.add("-c");
        StringBuffer mergedCmd = new StringBuffer();
        mergedCmd.append("exec ");
        boolean isExecutable = true;
        for (String s : cmd) {
            if (isExecutable) {
                mergedCmd.append(FileUtil.makeShellPath(new File(s)));
                isExecutable = false;
            } else {
                mergedCmd.append(s);
            }
            mergedCmd.append(" ");
        }
        mergedCmd.append(" < /dev/null ");
        mergedCmd.append(" >");
        mergedCmd.append(debugout);
        mergedCmd.append(" 2>&1 ");
        result.add(mergedCmd.toString());
        return result;
    }

    static {
        try {
            localFS = FileSystem.getLocal(new Configuration());
        }
        catch (IOException ioe) {
            LOG.warn("Getting local file system failed.");
        }
        if (!LOG_DIR.exists()) {
            LOG_DIR.mkdirs();
        }
        currentTaskid = null;
    }

    static class Reader
    extends InputStream {
        private long bytesRemaining;
        private FileInputStream file;

        public Reader(TaskAttemptID taskid, LogName kind, long start, long end) throws IOException {
            this(taskid, kind, start, end, false);
        }

        public Reader(TaskAttemptID taskid, LogName kind, long start, long end, boolean isCleanup) throws IOException {
            long result;
            LogFileDetail fileDetail = TaskLog.getLogFileDetail(taskid, kind, isCleanup);
            long size = fileDetail.length;
            if (start < 0L) {
                start += size + 1L;
            }
            if (end < 0L) {
                end += size + 1L;
            }
            start = Math.max(0L, Math.min(start, size));
            end = Math.max(0L, Math.min(end, size));
            this.bytesRemaining = (end += fileDetail.start) - (start += fileDetail.start);
            this.file = new FileInputStream(new File(TaskLog.getBaseDir(fileDetail.location), kind.toString()));
            for (long pos = 0L; pos < start; pos += result) {
                result = this.file.skip(start - pos);
                if (result >= 0L) continue;
                this.bytesRemaining = 0L;
                break;
            }
        }

        @Override
        public int read() throws IOException {
            int result = -1;
            if (this.bytesRemaining > 0L) {
                --this.bytesRemaining;
                result = this.file.read();
            }
            return result;
        }

        @Override
        public int read(byte[] buffer, int offset, int length) throws IOException {
            int bytes = this.file.read(buffer, offset, length = (int)Math.min((long)length, this.bytesRemaining));
            if (bytes > 0) {
                this.bytesRemaining -= (long)bytes;
            }
            return bytes;
        }

        @Override
        public int available() throws IOException {
            return (int)Math.min(this.bytesRemaining, (long)this.file.available());
        }

        @Override
        public void close() throws IOException {
            this.file.close();
        }
    }

    private static class TaskLogsPurgeFilter
    implements FileFilter {
        long purgeTimeStamp;

        TaskLogsPurgeFilter(long purgeTimeStamp) {
            this.purgeTimeStamp = purgeTimeStamp;
        }

        @Override
        public boolean accept(File file) {
            LOG.debug("PurgeFilter - file: " + file + ", mtime: " + file.lastModified() + ", purge: " + this.purgeTimeStamp);
            return file.lastModified() < this.purgeTimeStamp;
        }
    }

    public static enum LogName {
        STDOUT("stdout"),
        STDERR("stderr"),
        SYSLOG("syslog"),
        PROFILE("profile.out"),
        DEBUGOUT("debugout");

        private String prefix;

        private LogName(String prefix) {
            this.prefix = prefix;
        }

        public String toString() {
            return this.prefix;
        }
    }

    private static class LogFileDetail {
        static final String LOCATION = "LOG_DIR:";
        String location;
        long start;
        long length;

        private LogFileDetail() {
        }
    }
}

