/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.$internal.org.apache.hadoop.mapred;

import com.facebook.presto.hive.$internal.org.apache.hadoop.conf.Configuration;
import com.facebook.presto.hive.$internal.org.apache.hadoop.fs.Path;
import com.facebook.presto.hive.$internal.org.apache.hadoop.mapred.FileOutputFormat;
import com.facebook.presto.hive.$internal.org.apache.hadoop.mapred.JobConf;

public class SkipBadRecords {
    public static final String COUNTER_GROUP = "SkippingTaskCounters";
    public static final String COUNTER_MAP_PROCESSED_RECORDS = "MapProcessedRecords";
    public static final String COUNTER_REDUCE_PROCESSED_GROUPS = "ReduceProcessedGroups";
    private static final String ATTEMPTS_TO_START_SKIPPING = "mapred.skip.attempts.to.start.skipping";
    private static final String AUTO_INCR_MAP_PROC_COUNT = "mapred.skip.map.auto.incr.proc.count";
    private static final String AUTO_INCR_REDUCE_PROC_COUNT = "mapred.skip.reduce.auto.incr.proc.count";
    private static final String OUT_PATH = "mapred.skip.out.dir";
    private static final String MAPPER_MAX_SKIP_RECORDS = "mapred.skip.map.max.skip.records";
    private static final String REDUCER_MAX_SKIP_GROUPS = "mapred.skip.reduce.max.skip.groups";

    public static int getAttemptsToStartSkipping(Configuration conf) {
        return conf.getInt(ATTEMPTS_TO_START_SKIPPING, 2);
    }

    public static void setAttemptsToStartSkipping(Configuration conf, int attemptsToStartSkipping) {
        conf.setInt(ATTEMPTS_TO_START_SKIPPING, attemptsToStartSkipping);
    }

    public static boolean getAutoIncrMapperProcCount(Configuration conf) {
        return conf.getBoolean(AUTO_INCR_MAP_PROC_COUNT, true);
    }

    public static void setAutoIncrMapperProcCount(Configuration conf, boolean autoIncr) {
        conf.setBoolean(AUTO_INCR_MAP_PROC_COUNT, autoIncr);
    }

    public static boolean getAutoIncrReducerProcCount(Configuration conf) {
        return conf.getBoolean(AUTO_INCR_REDUCE_PROC_COUNT, true);
    }

    public static void setAutoIncrReducerProcCount(Configuration conf, boolean autoIncr) {
        conf.setBoolean(AUTO_INCR_REDUCE_PROC_COUNT, autoIncr);
    }

    public static Path getSkipOutputPath(Configuration conf) {
        String name = conf.get(OUT_PATH);
        if (name != null) {
            if ("none".equals(name)) {
                return null;
            }
            return new Path(name);
        }
        Path outPath = FileOutputFormat.getOutputPath(new JobConf(conf));
        return outPath == null ? null : new Path(outPath, "_logs/skip");
    }

    public static void setSkipOutputPath(JobConf conf, Path path) {
        String pathStr = null;
        pathStr = path == null ? "none" : path.toString();
        conf.set(OUT_PATH, pathStr);
    }

    public static long getMapperMaxSkipRecords(Configuration conf) {
        return conf.getLong(MAPPER_MAX_SKIP_RECORDS, 0L);
    }

    public static void setMapperMaxSkipRecords(Configuration conf, long maxSkipRecs) {
        conf.setLong(MAPPER_MAX_SKIP_RECORDS, maxSkipRecs);
    }

    public static long getReducerMaxSkipGroups(Configuration conf) {
        return conf.getLong(REDUCER_MAX_SKIP_GROUPS, 0L);
    }

    public static void setReducerMaxSkipGroups(Configuration conf, long maxSkipGrps) {
        conf.setLong(REDUCER_MAX_SKIP_GROUPS, maxSkipGrps);
    }
}

