/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.$internal.org.apache.hadoop.mapred;

import com.facebook.presto.hive.$internal.org.apache.hadoop.conf.Configuration;
import com.facebook.presto.hive.$internal.org.apache.hadoop.fs.FileSystem;
import com.facebook.presto.hive.$internal.org.apache.hadoop.fs.Path;
import com.facebook.presto.hive.$internal.org.apache.hadoop.io.BytesWritable;
import com.facebook.presto.hive.$internal.org.apache.hadoop.io.DataOutputBuffer;
import com.facebook.presto.hive.$internal.org.apache.hadoop.io.SequenceFile;
import com.facebook.presto.hive.$internal.org.apache.hadoop.mapred.FileSplit;
import com.facebook.presto.hive.$internal.org.apache.hadoop.mapred.InputSplit;
import com.facebook.presto.hive.$internal.org.apache.hadoop.mapred.JobConf;
import com.facebook.presto.hive.$internal.org.apache.hadoop.mapred.RecordReader;
import com.facebook.presto.hive.$internal.org.apache.hadoop.mapred.Reporter;
import com.facebook.presto.hive.$internal.org.apache.hadoop.mapred.SequenceFileInputFormat;
import java.io.IOException;

public class SequenceFileAsBinaryInputFormat
extends SequenceFileInputFormat<BytesWritable, BytesWritable> {
    @Override
    public RecordReader<BytesWritable, BytesWritable> getRecordReader(InputSplit split, JobConf job, Reporter reporter) throws IOException {
        return new SequenceFileAsBinaryRecordReader(job, (FileSplit)split);
    }

    public static class SequenceFileAsBinaryRecordReader
    implements RecordReader<BytesWritable, BytesWritable> {
        private SequenceFile.Reader in;
        private long start;
        private long end;
        private boolean done = false;
        private DataOutputBuffer buffer = new DataOutputBuffer();
        private SequenceFile.ValueBytes vbytes;

        public SequenceFileAsBinaryRecordReader(Configuration conf, FileSplit split) throws IOException {
            Path path = split.getPath();
            FileSystem fs = path.getFileSystem(conf);
            this.in = new SequenceFile.Reader(fs, path, conf);
            this.end = split.getStart() + split.getLength();
            if (split.getStart() > this.in.getPosition()) {
                this.in.sync(split.getStart());
            }
            this.start = this.in.getPosition();
            this.vbytes = this.in.createValueBytes();
            this.done = this.start >= this.end;
        }

        @Override
        public BytesWritable createKey() {
            return new BytesWritable();
        }

        @Override
        public BytesWritable createValue() {
            return new BytesWritable();
        }

        public String getKeyClassName() {
            return this.in.getKeyClassName();
        }

        public String getValueClassName() {
            return this.in.getValueClassName();
        }

        @Override
        public synchronized boolean next(BytesWritable key, BytesWritable val) throws IOException {
            boolean eof;
            if (this.done) {
                return false;
            }
            long pos = this.in.getPosition();
            boolean bl = eof = -1 == this.in.nextRawKey(this.buffer);
            if (!eof) {
                key.set(this.buffer.getData(), 0, this.buffer.getLength());
                this.buffer.reset();
                this.in.nextRawValue(this.vbytes);
                this.vbytes.writeUncompressedBytes(this.buffer);
                val.set(this.buffer.getData(), 0, this.buffer.getLength());
                this.buffer.reset();
            }
            this.done = eof || pos >= this.end && this.in.syncSeen();
            return !this.done;
        }

        @Override
        public long getPos() throws IOException {
            return this.in.getPosition();
        }

        @Override
        public void close() throws IOException {
            this.in.close();
        }

        @Override
        public float getProgress() throws IOException {
            if (this.end == this.start) {
                return 0.0f;
            }
            return Math.min(1.0f, (float)((double)(this.in.getPosition() - this.start) / (double)(this.end - this.start)));
        }
    }
}

