/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.$internal.org.apache.hadoop.mapred;

import com.facebook.presto.hive.$internal.org.apache.commons.logging.Log;
import com.facebook.presto.hive.$internal.org.apache.commons.logging.LogFactory;
import com.facebook.presto.hive.$internal.org.apache.hadoop.conf.Configuration;
import com.facebook.presto.hive.$internal.org.apache.hadoop.mapred.JobInProgress;
import com.facebook.presto.hive.$internal.org.apache.hadoop.mapred.JobQueueInfo;
import com.facebook.presto.hive.$internal.org.apache.hadoop.security.SecurityUtil;
import com.facebook.presto.hive.$internal.org.apache.hadoop.security.UserGroupInformation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import java.util.TreeSet;

class QueueManager {
    private static final Log LOG = LogFactory.getLog(QueueManager.class);
    private static final String QUEUE_CONF_PROPERTY_NAME_PREFIX = "mapred.queue.";
    private Set<String> queueNames = new TreeSet<String>();
    private HashMap<String, SecurityUtil.AccessControlList> aclsMap = new HashMap();
    private HashMap<String, Object> schedulerInfoObjects = new HashMap();
    private boolean aclsEnabled;

    public QueueManager(Configuration conf) {
        this.initialize(conf);
    }

    public synchronized Set<String> getQueues() {
        return this.queueNames;
    }

    public synchronized boolean hasAccess(String queueName, QueueOperation oper, UserGroupInformation ugi) {
        return this.hasAccess(queueName, null, oper, ugi);
    }

    public synchronized boolean hasAccess(String queueName, JobInProgress job, QueueOperation oper, UserGroupInformation ugi) {
        if (!this.aclsEnabled) {
            return true;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("checking access for : " + QueueManager.toFullPropertyName(queueName, oper.getAclName()));
        }
        if (oper.isJobOwnerAllowed() && job.getJobConf().getUser().equals(ugi.getUserName())) {
            return true;
        }
        SecurityUtil.AccessControlList acl = this.aclsMap.get(QueueManager.toFullPropertyName(queueName, oper.getAclName()));
        if (acl == null) {
            return false;
        }
        boolean allowed = acl.allAllowed();
        if (!allowed) {
            if (acl.getUsers().contains(ugi.getUserName())) {
                allowed = true;
            } else {
                Set<String> allowedGroups = acl.getGroups();
                for (String group : ugi.getGroupNames()) {
                    if (!allowedGroups.contains(group)) continue;
                    allowed = true;
                    break;
                }
            }
        }
        return allowed;
    }

    public synchronized void setSchedulerInfo(String queueName, Object queueInfo) {
        this.schedulerInfoObjects.put(queueName, queueInfo);
    }

    public synchronized Object getSchedulerInfo(String queueName) {
        return this.schedulerInfoObjects.get(queueName);
    }

    public synchronized void refresh(Configuration conf) {
        this.queueNames.clear();
        this.aclsMap.clear();
        this.schedulerInfoObjects.clear();
        this.initialize(conf);
    }

    private void initialize(Configuration conf) {
        this.aclsEnabled = conf.getBoolean("mapred.acls.enabled", false);
        String[] queues = conf.getStrings("mapred.queue.names", "default");
        QueueManager.addToSet(this.queueNames, queues);
        for (String queue : queues) {
            for (QueueOperation oper : QueueOperation.values()) {
                String key = QueueManager.toFullPropertyName(queue, oper.getAclName());
                String aclString = conf.get(key, "*");
                this.aclsMap.put(key, new SecurityUtil.AccessControlList(aclString));
            }
        }
    }

    private static final String toFullPropertyName(String queue, String property) {
        return QUEUE_CONF_PROPERTY_NAME_PREFIX + queue + "." + property;
    }

    private static final void addToSet(Set<String> set, String[] elems) {
        for (String elem : elems) {
            set.add(elem);
        }
    }

    synchronized JobQueueInfo[] getJobQueueInfos() {
        ArrayList<JobQueueInfo> queueInfoList = new ArrayList<JobQueueInfo>();
        for (String queue : this.queueNames) {
            Object schedulerInfo = this.schedulerInfoObjects.get(queue);
            if (schedulerInfo != null) {
                queueInfoList.add(new JobQueueInfo(queue, schedulerInfo.toString()));
                continue;
            }
            queueInfoList.add(new JobQueueInfo(queue, null));
        }
        return queueInfoList.toArray(new JobQueueInfo[queueInfoList.size()]);
    }

    JobQueueInfo getJobQueueInfo(String queue) {
        Object schedulingInfo = this.schedulerInfoObjects.get(queue);
        if (schedulingInfo != null) {
            return new JobQueueInfo(queue, schedulingInfo.toString());
        }
        return new JobQueueInfo(queue, null);
    }

    static enum QueueOperation {
        SUBMIT_JOB("acl-submit-job", false),
        ADMINISTER_JOBS("acl-administer-jobs", true);

        private final String aclName;
        private final boolean jobOwnerAllowed;

        private QueueOperation(String aclName, boolean jobOwnerAllowed) {
            this.aclName = aclName;
            this.jobOwnerAllowed = jobOwnerAllowed;
        }

        final String getAclName() {
            return this.aclName;
        }

        final boolean isJobOwnerAllowed() {
            return this.jobOwnerAllowed;
        }
    }
}

