/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.$internal.org.apache.hadoop.mapred;

import com.facebook.presto.hive.$internal.org.apache.hadoop.io.IntWritable;
import com.facebook.presto.hive.$internal.org.apache.hadoop.io.SequenceFile;
import com.facebook.presto.hive.$internal.org.apache.hadoop.mapred.BasicTypeSorterBase;
import com.facebook.presto.hive.$internal.org.apache.hadoop.mapred.MRSortResultIterator;
import com.facebook.presto.hive.$internal.org.apache.hadoop.util.MergeSort;
import java.util.Comparator;

class MergeSorter
extends BasicTypeSorterBase
implements Comparator<IntWritable> {
    private static int progressUpdateFrequency = 10000;
    private int progressCalls = 0;

    MergeSorter() {
    }

    @Override
    public SequenceFile.Sorter.RawKeyValueIterator sort() {
        MergeSort m = new MergeSort(this);
        int count = this.count;
        if (count == 0) {
            return null;
        }
        int[] pointers = this.pointers;
        int[] pointersCopy = new int[count];
        System.arraycopy(pointers, 0, pointersCopy, 0, count);
        m.mergeSort(pointers, pointersCopy, 0, count);
        return new MRSortResultIterator(this.keyValBuffer, pointersCopy, this.startOffsets, this.keyLengths, this.valueLengths);
    }

    @Override
    public int compare(IntWritable i, IntWritable j) {
        if (this.progressCalls < progressUpdateFrequency) {
            ++this.progressCalls;
        } else {
            this.progressCalls = 0;
            this.reporter.progress();
        }
        return this.comparator.compare(this.keyValBuffer.getData(), this.startOffsets[i.get()], this.keyLengths[i.get()], this.keyValBuffer.getData(), this.startOffsets[j.get()], this.keyLengths[j.get()]);
    }

    @Override
    public long getMemoryUtilized() {
        return super.getMemoryUtilized() + (long)(this.count * 4);
    }
}

