/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.$internal.org.apache.hadoop.mapred;

import com.facebook.presto.hive.;
import com.facebook.presto.hive.$internal.org.apache.commons.logging.Log;
import com.facebook.presto.hive.$internal.org.apache.commons.logging.LogFactory;
import com.facebook.presto.hive.$internal.org.apache.hadoop.fs.FileSystem;
import com.facebook.presto.hive.$internal.org.apache.hadoop.fs.Path;
import com.facebook.presto.hive.$internal.org.apache.hadoop.io.DataOutputBuffer;
import com.facebook.presto.hive.$internal.org.apache.hadoop.io.serializer.SerializationFactory;
import com.facebook.presto.hive.$internal.org.apache.hadoop.io.serializer.Serializer;
import com.facebook.presto.hive.$internal.org.apache.hadoop.mapred.ClusterStatus;
import com.facebook.presto.hive.$internal.org.apache.hadoop.mapred.Counters;
import com.facebook.presto.hive.$internal.org.apache.hadoop.mapred.InputSplit;
import com.facebook.presto.hive.$internal.org.apache.hadoop.mapred.JVMId;
import com.facebook.presto.hive.$internal.org.apache.hadoop.mapred.JobClient;
import com.facebook.presto.hive.$internal.org.apache.hadoop.mapred.JobConf;
import com.facebook.presto.hive.$internal.org.apache.hadoop.mapred.JobContext;
import com.facebook.presto.hive.$internal.org.apache.hadoop.mapred.JobEndNotifier;
import com.facebook.presto.hive.$internal.org.apache.hadoop.mapred.JobID;
import com.facebook.presto.hive.$internal.org.apache.hadoop.mapred.JobProfile;
import com.facebook.presto.hive.$internal.org.apache.hadoop.mapred.JobQueueInfo;
import com.facebook.presto.hive.$internal.org.apache.hadoop.mapred.JobStatus;
import com.facebook.presto.hive.$internal.org.apache.hadoop.mapred.JobSubmissionProtocol;
import com.facebook.presto.hive.$internal.org.apache.hadoop.mapred.JobTracker;
import com.facebook.presto.hive.$internal.org.apache.hadoop.mapred.JobTrackerInstrumentation;
import com.facebook.presto.hive.$internal.org.apache.hadoop.mapred.JobTrackerMetricsInst;
import com.facebook.presto.hive.$internal.org.apache.hadoop.mapred.JvmTask;
import com.facebook.presto.hive.$internal.org.apache.hadoop.mapred.MapOutputFile;
import com.facebook.presto.hive.$internal.org.apache.hadoop.mapred.MapTask;
import com.facebook.presto.hive.$internal.org.apache.hadoop.mapred.MapTaskCompletionEventsUpdate;
import com.facebook.presto.hive.$internal.org.apache.hadoop.mapred.OutputCommitter;
import com.facebook.presto.hive.$internal.org.apache.hadoop.mapred.ReduceTask;
import com.facebook.presto.hive.$internal.org.apache.hadoop.mapred.Task;
import com.facebook.presto.hive.$internal.org.apache.hadoop.mapred.TaskAttemptID;
import com.facebook.presto.hive.$internal.org.apache.hadoop.mapred.TaskCompletionEvent;
import com.facebook.presto.hive.$internal.org.apache.hadoop.mapred.TaskID;
import com.facebook.presto.hive.$internal.org.apache.hadoop.mapred.TaskReport;
import com.facebook.presto.hive.$internal.org.apache.hadoop.mapred.TaskStatus;
import com.facebook.presto.hive.$internal.org.apache.hadoop.mapred.TaskUmbilicalProtocol;
import com.facebook.presto.hive.$internal.org.apache.hadoop.mapreduce.InputFormat;
import com.facebook.presto.hive.$internal.org.apache.hadoop.util.ReflectionUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

class LocalJobRunner
implements JobSubmissionProtocol {
    public static final Log LOG = LogFactory.getLog(LocalJobRunner.class);
    private FileSystem fs;
    private HashMap<JobID, Job> jobs = new HashMap();
    private JobConf conf;
    private int map_tasks = 0;
    private int reduce_tasks = 0;
    private JobTrackerInstrumentation myMetrics = null;
    private static final String jobDir = "localRunner/";
    private static int jobid = 0;

    @Override
    public long getProtocolVersion(String protocol, long clientVersion) {
        return 20L;
    }

    public LocalJobRunner(JobConf conf) throws IOException {
        this.fs = FileSystem.get(conf);
        this.conf = conf;
        this.myMetrics = new JobTrackerMetricsInst(null, new JobConf(conf));
    }

    @Override
    public synchronized JobID getNewJobId() {
        return new JobID("local", ++jobid);
    }

    @Override
    public JobStatus submitJob(JobID jobid) throws IOException {
        return new Job(jobid, this.conf).status;
    }

    @Override
    public void killJob(JobID id) {
        this.jobs.get((Object)id).killed = true;
        this.jobs.get(id).interrupt();
    }

    @Override
    public void setJobPriority(JobID id, String jp) throws IOException {
        throw new UnsupportedOperationException("Changing job priority in LocalJobRunner is not supported.");
    }

    @Override
    public boolean killTask(TaskAttemptID taskId, boolean shouldFail) throws IOException {
        throw new UnsupportedOperationException("Killing tasks in LocalJobRunner is not supported");
    }

    @Override
    public JobProfile getJobProfile(JobID id) {
        Job job = this.jobs.get(id);
        if (job != null) {
            return job.getProfile();
        }
        return null;
    }

    @Override
    public TaskReport[] getMapTaskReports(JobID id) {
        return new TaskReport[0];
    }

    @Override
    public TaskReport[] getReduceTaskReports(JobID id) {
        return new TaskReport[0];
    }

    @Override
    public TaskReport[] getCleanupTaskReports(JobID id) {
        return new TaskReport[0];
    }

    @Override
    public TaskReport[] getSetupTaskReports(JobID id) {
        return new TaskReport[0];
    }

    @Override
    public JobStatus getJobStatus(JobID id) {
        Job job = this.jobs.get(id);
        if (job != null) {
            return job.status;
        }
        return null;
    }

    @Override
    public Counters getJobCounters(JobID id) {
        Job job = this.jobs.get(id);
        return job.currentCounters;
    }

    @Override
    public String getFilesystemName() throws IOException {
        return this.fs.getUri().toString();
    }

    @Override
    public ClusterStatus getClusterStatus(boolean detailed) {
        return new ClusterStatus(1, 0, 0L, this.map_tasks, this.reduce_tasks, 1, 1, JobTracker.State.RUNNING);
    }

    @Override
    public JobStatus[] jobsToComplete() {
        return null;
    }

    @Override
    public TaskCompletionEvent[] getTaskCompletionEvents(JobID jobid, int fromEventId, int maxEvents) throws IOException {
        return TaskCompletionEvent.EMPTY_ARRAY;
    }

    @Override
    public JobStatus[] getAllJobs() {
        return null;
    }

    @Override
    public String[] getTaskDiagnostics(TaskAttemptID taskid) throws IOException {
        return new String[0];
    }

    @Override
    public String getSystemDir() {
        Path sysDir = new Path(this.conf.get("mapred.system.dir", "/tmp/hadoop/mapred/system"));
        return this.fs.makeQualified(sysDir).toString();
    }

    @Override
    public JobStatus[] getJobsFromQueue(String queue) throws IOException {
        return null;
    }

    @Override
    public JobQueueInfo[] getQueues() throws IOException {
        return null;
    }

    @Override
    public JobQueueInfo getQueueInfo(String queue) throws IOException {
        return null;
    }

    private class Job
    extends Thread
    implements TaskUmbilicalProtocol {
        private Path file;
        private JobID id;
        private JobConf job;
        private JobStatus status;
        private ArrayList<TaskAttemptID> mapIds = new ArrayList();
        private MapOutputFile mapoutputFile;
        private JobProfile profile;
        private Path localFile;
        private FileSystem localFs;
        boolean killed = false;
        private Counters completedTaskCounters = new Counters();
        private Counters currentCounters = new Counters();

        @Override
        public long getProtocolVersion(String protocol, long clientVersion) {
            return 16L;
        }

        public Job(JobID jobid, JobConf conf) throws IOException {
            this.file = new Path(LocalJobRunner.this.getSystemDir(), jobid + "/job.xml");
            this.id = jobid;
            this.mapoutputFile = new MapOutputFile(jobid);
            this.mapoutputFile.setConf(conf);
            this.localFile = new JobConf(conf).getLocalPath(LocalJobRunner.jobDir + this.id + ".xml");
            this.localFs = FileSystem.getLocal(conf);
            LocalJobRunner.this.fs.copyToLocalFile(this.file, this.localFile);
            this.job = new JobConf(this.localFile);
            this.profile = new JobProfile(this.job.getUser(), this.id, this.file.toString(), "http://localhost:8080/", this.job.getJobName());
            this.status = new JobStatus(this.id, 0.0f, 0.0f, 1);
            LocalJobRunner.this.jobs.put(this.id, this);
            this.start();
        }

        JobProfile getProfile() {
            return this.profile;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            JobID jobId = this.profile.getJobID();
            JobContext jContext = new JobContext(LocalJobRunner.this.conf, (com.facebook.presto.hive.$internal.org.apache.hadoop.mapreduce.JobID)jobId);
            OutputCommitter outputCommitter = this.job.getOutputCommitter();
            try {
                block33: {
                    int numReduceTasks;
                    JobClient.RawSplit[] rawSplits;
                    if (this.job.getUseNewMapper()) {
                        InputFormat<?, ?> input = ReflectionUtils.newInstance(jContext.getInputFormatClass(), jContext.getJobConf());
                        List<com.facebook.presto.hive.$internal.org.apache.hadoop.mapreduce.InputSplit> splits = input.getSplits(jContext);
                        rawSplits = new JobClient.RawSplit[splits.size()];
                        DataOutputBuffer buffer = new DataOutputBuffer();
                        SerializationFactory factory = new SerializationFactory(LocalJobRunner.this.conf);
                        Serializer<?> serializer = factory.getSerializer(splits.get(0).getClass());
                        serializer.open(buffer);
                        for (int i = 0; i < splits.size(); ++i) {
                            buffer.reset();
                            serializer.serialize(splits.get(i));
                            JobClient.RawSplit rawSplit = new JobClient.RawSplit();
                            rawSplit.setClassName(splits.get(i).getClass().getName());
                            rawSplit.setDataLength(splits.get(i).getLength());
                            rawSplit.setBytes(buffer.getData(), 0, buffer.getLength());
                            rawSplit.setLocations(splits.get(i).getLocations());
                            rawSplits[i] = rawSplit;
                        }
                    } else {
                        InputSplit[] splits = this.job.getInputFormat().getSplits(this.job, 1);
                        rawSplits = new JobClient.RawSplit[splits.length];
                        DataOutputBuffer buffer = new DataOutputBuffer();
                        for (int i = 0; i < splits.length; ++i) {
                            buffer.reset();
                            splits[i].write(buffer);
                            JobClient.RawSplit rawSplit = new JobClient.RawSplit();
                            rawSplit.setClassName(splits[i].getClass().getName());
                            rawSplit.setDataLength(splits[i].getLength());
                            rawSplit.setBytes(buffer.getData(), 0, buffer.getLength());
                            rawSplit.setLocations(splits[i].getLocations());
                            rawSplits[i] = rawSplit;
                        }
                    }
                    if ((numReduceTasks = this.job.getNumReduceTasks()) > 1 || numReduceTasks < 0) {
                        numReduceTasks = 1;
                        this.job.setNumReduceTasks(1);
                    }
                    outputCommitter.setupJob(jContext);
                    this.status.setSetupProgress(1.0f);
                    for (int i = 0; i < rawSplits.length; ++i) {
                        if (this.isInterrupted()) {
                            throw new InterruptedException();
                        }
                        TaskAttemptID mapId = new TaskAttemptID(new TaskID(jobId, true, i), 0);
                        this.mapIds.add(mapId);
                        MapTask map = new MapTask(this.file.toString(), mapId, i, rawSplits[i].getClassName(), rawSplits[i].getBytes());
                        JobConf localConf = new JobConf(this.job);
                        map.setJobFile(this.localFile.toString());
                        map.localizeConfiguration(localConf);
                        map.setConf(localConf);
                        LocalJobRunner.this.map_tasks += 1;
                        LocalJobRunner.this.myMetrics.launchMap(mapId);
                        map.run(localConf, this);
                        LocalJobRunner.this.myMetrics.completeMap(mapId);
                        LocalJobRunner.this.map_tasks -= 1;
                        this.updateCounters(map);
                    }
                    TaskAttemptID reduceId = new TaskAttemptID(new TaskID(jobId, false, 0), 0);
                    try {
                        if (numReduceTasks <= 0) break block33;
                        for (int i = 0; i < this.mapIds.size(); ++i) {
                            if (!this.isInterrupted()) {
                                TaskAttemptID mapId = this.mapIds.get(i);
                                Path mapOut = this.mapoutputFile.getOutputFile(mapId);
                                Path reduceIn = this.mapoutputFile.getInputFileForWrite(mapId.getTaskID(), reduceId, this.localFs.getLength(mapOut));
                                if (!this.localFs.mkdirs(reduceIn.getParent())) {
                                    throw new IOException("Mkdirs failed to create " + reduceIn.getParent().toString());
                                }
                                if (this.localFs.rename(mapOut, reduceIn)) continue;
                                throw new IOException("Couldn't rename " + mapOut);
                            }
                            throw new InterruptedException();
                        }
                        if (!this.isInterrupted()) {
                            ReduceTask reduce = new ReduceTask(this.file.toString(), reduceId, 0, this.mapIds.size());
                            JobConf localConf = new JobConf(this.job);
                            reduce.setJobFile(this.localFile.toString());
                            reduce.localizeConfiguration(localConf);
                            reduce.setConf(localConf);
                            LocalJobRunner.this.reduce_tasks += 1;
                            LocalJobRunner.this.myMetrics.launchReduce(reduce.getTaskID());
                            reduce.run(localConf, this);
                            LocalJobRunner.this.myMetrics.completeReduce(reduce.getTaskID());
                            LocalJobRunner.this.reduce_tasks -= 1;
                            this.updateCounters(reduce);
                            break block33;
                        }
                        throw new InterruptedException();
                    }
                    finally {
                        for (TaskAttemptID mapId : this.mapIds) {
                            this.mapoutputFile.removeAll(mapId);
                        }
                        if (numReduceTasks == 1) {
                            this.mapoutputFile.removeAll(reduceId);
                        }
                    }
                }
                outputCommitter.cleanupJob(jContext);
                this.status.setCleanupProgress(1.0f);
                if (this.killed) {
                    this.status.setRunState(5);
                } else {
                    this.status.setRunState(2);
                }
                JobEndNotifier.localRunnerNotification(this.job, this.status);
            }
            catch (Throwable t) {
                try {
                    outputCommitter.cleanupJob(jContext);
                }
                catch (IOException ioe) {
                    LOG.info("Error cleaning up job:" + this.id);
                }
                this.status.setCleanupProgress(1.0f);
                if (this.killed) {
                    this.status.setRunState(5);
                } else {
                    this.status.setRunState(3);
                }
                LOG.warn(this.id, t);
                JobEndNotifier.localRunnerNotification(this.job, this.status);
            }
            finally {
                try {
                    LocalJobRunner.this.fs.delete(this.file.getParent(), true);
                    this.localFs.delete(this.localFile, true);
                }
                catch (IOException e) {
                    LOG.warn("Error cleaning up " + this.id + ": " + e);
                }
            }
        }

        @Override
        public JvmTask getTask(JVMId jvmId) {
            return null;
        }

        @Override
        public boolean statusUpdate(TaskAttemptID taskId, TaskStatus taskStatus) throws IOException, InterruptedException {
            LOG.info(taskStatus.getStateString());
            float taskIndex = this.mapIds.indexOf(taskId);
            if (taskIndex >= 0.0f) {
                float numTasks = this.mapIds.size();
                this.status.setMapProgress(taskIndex / numTasks + taskStatus.getProgress() / numTasks);
            } else {
                this.status.setReduceProgress(taskStatus.getProgress());
            }
            this.currentCounters = Counters.sum(this.completedTaskCounters, taskStatus.getCounters());
            return true;
        }

        @Override
        public void commitPending(TaskAttemptID taskid, TaskStatus taskStatus) throws IOException, InterruptedException {
            this.statusUpdate(taskid, taskStatus);
        }

        private void updateCounters(Task task) {
            this.completedTaskCounters.incrAllCounters(task.getCounters());
        }

        @Override
        public void reportDiagnosticInfo(TaskAttemptID taskid, String trace) {
        }

        @Override
        public void reportNextRecordRange(TaskAttemptID taskid, .SortedRanges.Range range) throws IOException {
            LOG.info("Task " + taskid + " reportedNextRecordRange " + range);
        }

        @Override
        public boolean ping(TaskAttemptID taskid) throws IOException {
            return true;
        }

        @Override
        public boolean canCommit(TaskAttemptID taskid) throws IOException {
            return true;
        }

        @Override
        public void done(TaskAttemptID taskId) throws IOException {
            int taskIndex = this.mapIds.indexOf(taskId);
            if (taskIndex >= 0) {
                this.status.setMapProgress(1.0f);
            } else {
                this.status.setReduceProgress(1.0f);
            }
        }

        @Override
        public synchronized void fsError(TaskAttemptID taskId, String message) throws IOException {
            LOG.fatal("FSError: " + message + "from task: " + taskId);
        }

        @Override
        public void shuffleError(TaskAttemptID taskId, String message) throws IOException {
            LOG.fatal("shuffleError: " + message + "from task: " + taskId);
        }

        @Override
        public synchronized void fatalError(TaskAttemptID taskId, String msg) throws IOException {
            LOG.fatal("Fatal: " + msg + "from task: " + taskId);
        }

        @Override
        public MapTaskCompletionEventsUpdate getMapCompletionEvents(JobID jobId, int fromEventId, int maxLocs, TaskAttemptID id) throws IOException {
            return new MapTaskCompletionEventsUpdate(TaskCompletionEvent.EMPTY_ARRAY, false);
        }
    }
}

