/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.$internal.org.apache.hadoop.mapred;

import com.facebook.presto.hive.$internal.org.apache.hadoop.mapred.JobChangeEvent;
import com.facebook.presto.hive.$internal.org.apache.hadoop.mapred.JobID;
import com.facebook.presto.hive.$internal.org.apache.hadoop.mapred.JobInProgress;
import com.facebook.presto.hive.$internal.org.apache.hadoop.mapred.JobInProgressListener;
import com.facebook.presto.hive.$internal.org.apache.hadoop.mapred.JobPriority;
import com.facebook.presto.hive.$internal.org.apache.hadoop.mapred.JobStatus;
import com.facebook.presto.hive.$internal.org.apache.hadoop.mapred.JobStatusChangeEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;

class JobQueueJobInProgressListener
extends JobInProgressListener {
    static final Comparator<JobSchedulingInfo> FIFO_JOB_QUEUE_COMPARATOR = new Comparator<JobSchedulingInfo>(){

        @Override
        public int compare(JobSchedulingInfo o1, JobSchedulingInfo o2) {
            int res = o1.getPriority().compareTo(o2.getPriority());
            if (res == 0) {
                if (o1.getStartTime() < o2.getStartTime()) {
                    res = -1;
                } else {
                    int n = res = o1.getStartTime() == o2.getStartTime() ? 0 : 1;
                }
            }
            if (res == 0) {
                res = o1.getJobID().compareTo(o2.getJobID());
            }
            return res;
        }
    };
    private Map<JobSchedulingInfo, JobInProgress> jobQueue;

    public JobQueueJobInProgressListener() {
        this(new TreeMap<JobSchedulingInfo, JobInProgress>(FIFO_JOB_QUEUE_COMPARATOR));
    }

    protected JobQueueJobInProgressListener(Map<JobSchedulingInfo, JobInProgress> jobQueue) {
        this.jobQueue = Collections.synchronizedMap(jobQueue);
    }

    public Collection<JobInProgress> getJobQueue() {
        return this.jobQueue.values();
    }

    @Override
    public void jobAdded(JobInProgress job) {
        this.jobQueue.put(new JobSchedulingInfo(job.getStatus()), job);
    }

    @Override
    public void jobRemoved(JobInProgress job) {
    }

    private void jobCompleted(JobSchedulingInfo oldInfo) {
        this.jobQueue.remove(oldInfo);
    }

    @Override
    public synchronized void jobUpdated(JobChangeEvent event) {
        JobInProgress job = event.getJobInProgress();
        if (event instanceof JobStatusChangeEvent) {
            int runState;
            JobStatusChangeEvent statusEvent = (JobStatusChangeEvent)event;
            JobSchedulingInfo oldInfo = new JobSchedulingInfo(statusEvent.getOldStatus());
            if (statusEvent.getEventType() == JobStatusChangeEvent.EventType.PRIORITY_CHANGED || statusEvent.getEventType() == JobStatusChangeEvent.EventType.START_TIME_CHANGED) {
                this.reorderJobs(job, oldInfo);
            } else if (statusEvent.getEventType() == JobStatusChangeEvent.EventType.RUN_STATE_CHANGED && ((runState = statusEvent.getNewStatus().getRunState()) == 2 || runState == 3 || runState == 5)) {
                this.jobCompleted(oldInfo);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reorderJobs(JobInProgress job, JobSchedulingInfo oldInfo) {
        Map<JobSchedulingInfo, JobInProgress> map = this.jobQueue;
        synchronized (map) {
            this.jobQueue.remove(oldInfo);
            this.jobQueue.put(new JobSchedulingInfo(job), job);
        }
    }

    static class JobSchedulingInfo {
        private JobPriority priority;
        private long startTime;
        private JobID id;

        public JobSchedulingInfo(JobInProgress jip) {
            this(jip.getStatus());
        }

        public JobSchedulingInfo(JobStatus status) {
            this.priority = status.getJobPriority();
            this.startTime = status.getStartTime();
            this.id = status.getJobID();
        }

        JobPriority getPriority() {
            return this.priority;
        }

        long getStartTime() {
            return this.startTime;
        }

        JobID getJobID() {
            return this.id;
        }
    }
}

