/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.$internal.org.apache.hadoop.mapred;

import com.facebook.presto.hive.$internal.org.apache.commons.logging.Log;
import com.facebook.presto.hive.$internal.org.apache.commons.logging.LogFactory;
import com.facebook.presto.hive.$internal.org.apache.hadoop.io.IntWritable;
import com.facebook.presto.hive.$internal.org.apache.hadoop.io.Text;
import com.facebook.presto.hive.$internal.org.apache.hadoop.io.Writable;
import com.facebook.presto.hive.$internal.org.apache.hadoop.io.WritableUtils;
import com.facebook.presto.hive.$internal.org.apache.hadoop.util.StringUtils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

@Deprecated
public class Counters
implements Writable,
Iterable<Group> {
    private static final Log LOG = LogFactory.getLog(Counters.class);
    private static final char GROUP_OPEN = '{';
    private static final char GROUP_CLOSE = '}';
    private static final char COUNTER_OPEN = '[';
    private static final char COUNTER_CLOSE = ']';
    private static final char UNIT_OPEN = '(';
    private static final char UNIT_CLOSE = ')';
    private static char[] charsToEscape = new char[]{'{', '}', '[', ']', '(', ')'};
    private Map<String, Group> counters = new HashMap<String, Group>();
    private Map<Enum, Counter> cache = new IdentityHashMap<Enum, Counter>();

    public synchronized Collection<String> getGroupNames() {
        return this.counters.keySet();
    }

    @Override
    public synchronized Iterator<Group> iterator() {
        return this.counters.values().iterator();
    }

    public synchronized Group getGroup(String groupName) {
        Group result = this.counters.get(groupName);
        if (result == null) {
            result = new Group(groupName);
            this.counters.put(groupName, result);
        }
        return result;
    }

    public synchronized Counter findCounter(Enum key) {
        Counter counter = this.cache.get(key);
        if (counter == null) {
            Group group = this.getGroup(key.getDeclaringClass().getName());
            counter = group.getCounterForName(key.toString());
            this.cache.put(key, counter);
        }
        return counter;
    }

    public synchronized Counter findCounter(String group, String name) {
        return this.getGroup(group).getCounterForName(name);
    }

    @Deprecated
    public synchronized Counter findCounter(String group, int id, String name) {
        return this.getGroup(group).getCounterForName(name);
    }

    public synchronized void incrCounter(Enum key, long amount) {
        this.findCounter(key).increment(amount);
    }

    public synchronized void incrCounter(String group, String counter, long amount) {
        this.getGroup(group).getCounterForName(counter).increment(amount);
    }

    public synchronized long getCounter(Enum key) {
        return this.findCounter(key).getValue();
    }

    public synchronized void incrAllCounters(Counters other) {
        for (Group otherGroup : other) {
            Group group = this.getGroup(otherGroup.getName());
            group.displayName = otherGroup.displayName;
            for (Counter otherCounter : otherGroup) {
                Counter counter = group.getCounterForName(otherCounter.getName());
                counter.setDisplayName(otherCounter.getDisplayName());
                counter.increment(otherCounter.getValue());
            }
        }
    }

    public static Counters sum(Counters a, Counters b) {
        Counters counters = new Counters();
        counters.incrAllCounters(a);
        counters.incrAllCounters(b);
        return counters;
    }

    public synchronized int size() {
        int result = 0;
        for (Group group : this) {
            result += group.size();
        }
        return result;
    }

    @Override
    public synchronized void write(DataOutput out) throws IOException {
        out.writeInt(this.counters.size());
        for (Group group : this.counters.values()) {
            Text.writeString(out, group.getName());
            group.write(out);
        }
    }

    @Override
    public synchronized void readFields(DataInput in) throws IOException {
        int numClasses = in.readInt();
        this.counters.clear();
        while (numClasses-- > 0) {
            String groupName = Text.readString(in);
            Group group = new Group(groupName);
            group.readFields(in);
            this.counters.put(groupName, group);
        }
    }

    public void log(Log log) {
        log.info("Counters: " + this.size());
        for (Group group : this) {
            log.info("  " + group.getDisplayName());
            for (Counter counter : group) {
                log.info("    " + counter.getDisplayName() + "=" + counter.getCounter());
            }
        }
    }

    public synchronized String toString() {
        StringBuilder sb = new StringBuilder("Counters: " + this.size());
        for (Group group : this) {
            sb.append("\n\t" + group.getDisplayName());
            for (Counter counter : group) {
                sb.append("\n\t\t" + counter.getDisplayName() + "=" + counter.getCounter());
            }
        }
        return sb.toString();
    }

    public synchronized String makeCompactString() {
        StringBuffer buffer = new StringBuffer();
        boolean first = true;
        for (Group group : this) {
            for (Counter counter : group) {
                if (first) {
                    first = false;
                } else {
                    buffer.append(',');
                }
                buffer.append(group.getDisplayName());
                buffer.append('.');
                buffer.append(counter.getDisplayName());
                buffer.append(':');
                buffer.append(counter.getCounter());
            }
        }
        return buffer.toString();
    }

    public synchronized String makeEscapedCompactString() {
        StringBuffer buffer = new StringBuffer();
        for (Group group : this) {
            buffer.append(group.makeEscapedCompactString());
        }
        return buffer.toString();
    }

    private static String getBlock(String str, char open, char close, IntWritable index) throws ParseException {
        StringBuilder split = new StringBuilder();
        int next = StringUtils.findNext(str, open, '\\', index.get(), split);
        split.setLength(0);
        if (next >= 0) {
            ++next;
            if ((next = StringUtils.findNext(str, close, '\\', next, split)) >= 0) {
                index.set(++next);
                return split.toString();
            }
            throw new ParseException("Unexpected end of block", next);
        }
        return null;
    }

    public static Counters fromEscapedCompactString(String compactString) throws ParseException {
        Counters counters = new Counters();
        IntWritable index = new IntWritable(0);
        String groupString = Counters.getBlock(compactString, '{', '}', index);
        while (groupString != null) {
            IntWritable groupIndex = new IntWritable(0);
            String groupName = Counters.getBlock(groupString, '(', ')', groupIndex);
            groupName = Counters.unescape(groupName);
            String groupDisplayName = Counters.getBlock(groupString, '(', ')', groupIndex);
            groupDisplayName = Counters.unescape(groupDisplayName);
            Group group = counters.getGroup(groupName);
            group.setDisplayName(groupDisplayName);
            String counterString = Counters.getBlock(groupString, '[', ']', groupIndex);
            while (counterString != null) {
                IntWritable counterIndex = new IntWritable(0);
                String counterName = Counters.getBlock(counterString, '(', ')', counterIndex);
                counterName = Counters.unescape(counterName);
                String counterDisplayName = Counters.getBlock(counterString, '(', ')', counterIndex);
                counterDisplayName = Counters.unescape(counterDisplayName);
                long value = Long.parseLong(Counters.getBlock(counterString, '(', ')', counterIndex));
                Counter counter = group.getCounterForName(counterName);
                counter.setDisplayName(counterDisplayName);
                counter.increment(value);
                counterString = Counters.getBlock(groupString, '[', ']', groupIndex);
            }
            groupString = Counters.getBlock(compactString, '{', '}', index);
        }
        return counters;
    }

    private static String escape(String string) {
        return StringUtils.escapeString(string, '\\', charsToEscape);
    }

    private static String unescape(String string) {
        return StringUtils.unEscapeString(string, '\\', charsToEscape);
    }

    public synchronized int hashCode() {
        return ((Object)this.counters).hashCode();
    }

    public synchronized boolean equals(Object obj) {
        boolean isEqual = false;
        if (obj != null && obj instanceof Counters) {
            Counters other = (Counters)obj;
            if (this.size() == other.size()) {
                isEqual = true;
                for (Map.Entry<String, Group> entry : this.counters.entrySet()) {
                    Group targetGroup;
                    String key = entry.getKey();
                    Group sourceGroup = entry.getValue();
                    if (sourceGroup.equals(targetGroup = other.getGroup(key))) continue;
                    isEqual = false;
                    break;
                }
            }
        }
        return isEqual;
    }

    public static class Group
    implements Writable,
    Iterable<Counter> {
        private String groupName;
        private String displayName;
        private Map<String, Counter> subcounters = new HashMap<String, Counter>();
        private ResourceBundle bundle = null;

        Group(String groupName) {
            try {
                this.bundle = Group.getResourceBundle(groupName);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            this.groupName = groupName;
            this.displayName = this.localize("CounterGroupName", groupName);
            LOG.debug("Creating group " + groupName + " with " + (this.bundle == null ? "nothing" : "bundle"));
        }

        private static ResourceBundle getResourceBundle(String enumClassName) {
            String bundleName = enumClassName.replace('$', '_');
            return ResourceBundle.getBundle(bundleName);
        }

        public String getName() {
            return this.groupName;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public String makeEscapedCompactString() {
            StringBuffer buf = new StringBuffer();
            buf.append('{');
            buf.append('(');
            buf.append(Counters.escape(this.getName()));
            buf.append(')');
            buf.append('(');
            buf.append(Counters.escape(this.getDisplayName()));
            buf.append(')');
            for (Counter counter : this.subcounters.values()) {
                buf.append(counter.makeEscapedCompactString());
            }
            buf.append('}');
            return buf.toString();
        }

        public int hashCode() {
            return ((Object)this.subcounters).hashCode();
        }

        public synchronized boolean equals(Object obj) {
            boolean isEqual = false;
            if (obj != null && obj instanceof Group) {
                Group g = (Group)obj;
                if (this.size() == g.size()) {
                    isEqual = true;
                    for (Map.Entry<String, Counter> entry : this.subcounters.entrySet()) {
                        Counter c2;
                        String key = entry.getKey();
                        Counter c1 = entry.getValue();
                        if (c1.contentEquals(c2 = g.getCounterForName(key))) continue;
                        isEqual = false;
                        break;
                    }
                }
            }
            return isEqual;
        }

        public synchronized long getCounter(String counterName) {
            for (Counter counter : this.subcounters.values()) {
                if (counter == null || !counter.getDisplayName().equals(counterName)) continue;
                return counter.getValue();
            }
            return 0L;
        }

        @Deprecated
        public synchronized Counter getCounter(int id, String name) {
            return this.getCounterForName(name);
        }

        public synchronized Counter getCounterForName(String name) {
            Counter result = this.subcounters.get(name);
            if (result == null) {
                LOG.debug("Adding " + name);
                result = new Counter(name, this.localize(name + ".name", name), 0L);
                this.subcounters.put(name, result);
            }
            return result;
        }

        public synchronized int size() {
            return this.subcounters.size();
        }

        private String localize(String key, String defaultValue) {
            String result = defaultValue;
            if (this.bundle != null) {
                try {
                    result = this.bundle.getString(key);
                }
                catch (MissingResourceException mre) {
                    // empty catch block
                }
            }
            return result;
        }

        @Override
        public synchronized void write(DataOutput out) throws IOException {
            Text.writeString(out, this.displayName);
            WritableUtils.writeVInt(out, this.subcounters.size());
            for (Counter counter : this.subcounters.values()) {
                counter.write(out);
            }
        }

        @Override
        public synchronized void readFields(DataInput in) throws IOException {
            this.displayName = Text.readString(in);
            this.subcounters.clear();
            int size = WritableUtils.readVInt(in);
            for (int i = 0; i < size; ++i) {
                Counter counter = new Counter();
                counter.readFields(in);
                this.subcounters.put(counter.getName(), counter);
            }
        }

        @Override
        public synchronized Iterator<Counter> iterator() {
            return new ArrayList<Counter>(this.subcounters.values()).iterator();
        }
    }

    public static class Counter
    extends com.facebook.presto.hive.$internal.org.apache.hadoop.mapreduce.Counter {
        Counter() {
        }

        Counter(String name, String displayName, long value) {
            super(name, displayName);
            this.increment(value);
        }

        @Override
        public void setDisplayName(String newName) {
            super.setDisplayName(newName);
        }

        public synchronized String makeEscapedCompactString() {
            StringBuffer buf = new StringBuffer();
            buf.append('[');
            buf.append('(');
            buf.append(Counters.escape(this.getName()));
            buf.append(')');
            buf.append('(');
            buf.append(Counters.escape(this.getDisplayName()));
            buf.append(')');
            buf.append('(');
            buf.append(this.getValue());
            buf.append(')');
            buf.append(']');
            return buf.toString();
        }

        @Deprecated
        synchronized boolean contentEquals(Counter c) {
            return this.equals(c);
        }

        public synchronized long getCounter() {
            return this.getValue();
        }
    }
}

