/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.$internal.org.apache.hadoop.mapred;

import com.facebook.presto.hive.$internal.org.apache.commons.logging.Log;
import com.facebook.presto.hive.$internal.org.apache.commons.logging.LogFactory;
import com.facebook.presto.hive.$internal.org.apache.hadoop.conf.Configuration;
import com.facebook.presto.hive.$internal.org.apache.hadoop.fs.FSDataInputStream;
import com.facebook.presto.hive.$internal.org.apache.hadoop.fs.FSDataOutputStream;
import com.facebook.presto.hive.$internal.org.apache.hadoop.fs.FileStatus;
import com.facebook.presto.hive.$internal.org.apache.hadoop.fs.FileSystem;
import com.facebook.presto.hive.$internal.org.apache.hadoop.fs.Path;
import com.facebook.presto.hive.$internal.org.apache.hadoop.mapred.Counters;
import com.facebook.presto.hive.$internal.org.apache.hadoop.mapred.JobID;
import com.facebook.presto.hive.$internal.org.apache.hadoop.mapred.JobInProgress;
import com.facebook.presto.hive.$internal.org.apache.hadoop.mapred.JobProfile;
import com.facebook.presto.hive.$internal.org.apache.hadoop.mapred.JobStatus;
import com.facebook.presto.hive.$internal.org.apache.hadoop.mapred.TaskCompletionEvent;
import java.io.IOException;

class CompletedJobStatusStore
implements Runnable {
    private boolean active;
    private String jobInfoDir;
    private long retainTime;
    private FileSystem fs;
    private static final String JOB_INFO_STORE_DIR = "/jobtracker/jobsInfo";
    public static final Log LOG = LogFactory.getLog(CompletedJobStatusStore.class);
    private static long HOUR = 3600000L;
    private static long SLEEP_TIME = 1L * HOUR;

    CompletedJobStatusStore(Configuration conf) throws IOException {
        this.active = conf.getBoolean("mapred.job.tracker.persist.jobstatus.active", false);
        if (this.active) {
            this.retainTime = (long)conf.getInt("mapred.job.tracker.persist.jobstatus.hours", 0) * HOUR;
            this.jobInfoDir = conf.get("mapred.job.tracker.persist.jobstatus.dir", JOB_INFO_STORE_DIR);
            Path path = new Path(this.jobInfoDir);
            this.fs = path.getFileSystem(conf);
            if (!this.fs.exists(path)) {
                this.fs.mkdirs(path);
            }
            if (this.retainTime == 0L) {
                this.deleteJobStatusDirs();
            }
            LOG.info("Completed job store activated/configured with retain-time : " + this.retainTime + " , job-info-dir : " + this.jobInfoDir);
        } else {
            LOG.info("Completed job store is inactive");
        }
    }

    public boolean isActive() {
        return this.active;
    }

    @Override
    public void run() {
        if (this.retainTime > 0L) {
            while (true) {
                this.deleteJobStatusDirs();
                try {
                    Thread.sleep(SLEEP_TIME);
                }
                catch (InterruptedException ex) {
                    break;
                }
            }
        }
    }

    private void deleteJobStatusDirs() {
        try {
            FileStatus[] jobInfoFiles;
            long currentTime = System.currentTimeMillis();
            for (FileStatus jobInfo : jobInfoFiles = this.fs.listStatus(new Path[]{new Path(this.jobInfoDir)})) {
                try {
                    if (currentTime - jobInfo.getModificationTime() <= this.retainTime) continue;
                    this.fs.delete(jobInfo.getPath(), true);
                }
                catch (IOException ie) {
                    LOG.warn("Could not do housekeeping for [ " + jobInfo.getPath() + "] job info : " + ie.getMessage(), ie);
                }
            }
        }
        catch (IOException ie) {
            LOG.warn("Could not obtain job info files : " + ie.getMessage(), ie);
        }
    }

    private Path getInfoFilePath(JobID jobId) {
        return new Path(this.jobInfoDir, jobId + ".info");
    }

    public void store(JobInProgress job) {
        if (this.active && this.retainTime > 0L) {
            JobID jobId = job.getStatus().getJobID();
            Path jobStatusFile = this.getInfoFilePath(jobId);
            try {
                FSDataOutputStream dataOut = this.fs.create(jobStatusFile);
                job.getStatus().write(dataOut);
                job.getProfile().write(dataOut);
                job.getCounters().write(dataOut);
                TaskCompletionEvent[] events = job.getTaskCompletionEvents(0, Integer.MAX_VALUE);
                dataOut.writeInt(events.length);
                for (TaskCompletionEvent event : events) {
                    event.write(dataOut);
                }
                dataOut.close();
            }
            catch (IOException ex) {
                LOG.warn("Could not store [" + jobId + "] job info : " + ex.getMessage(), ex);
                try {
                    this.fs.delete(jobStatusFile, true);
                }
                catch (IOException ex1) {
                    // empty catch block
                }
            }
        }
    }

    private FSDataInputStream getJobInfoFile(JobID jobId) throws IOException {
        Path jobStatusFile = this.getInfoFilePath(jobId);
        return this.fs.exists(jobStatusFile) ? this.fs.open(jobStatusFile) : null;
    }

    private JobStatus readJobStatus(FSDataInputStream dataIn) throws IOException {
        JobStatus jobStatus = new JobStatus();
        jobStatus.readFields(dataIn);
        return jobStatus;
    }

    private JobProfile readJobProfile(FSDataInputStream dataIn) throws IOException {
        JobProfile jobProfile = new JobProfile();
        jobProfile.readFields(dataIn);
        return jobProfile;
    }

    private Counters readCounters(FSDataInputStream dataIn) throws IOException {
        Counters counters = new Counters();
        counters.readFields(dataIn);
        return counters;
    }

    private TaskCompletionEvent[] readEvents(FSDataInputStream dataIn, int offset, int len) throws IOException {
        int size = dataIn.readInt();
        if (offset > size) {
            return TaskCompletionEvent.EMPTY_ARRAY;
        }
        if (offset + len > size) {
            len = size - offset;
        }
        TaskCompletionEvent[] events = new TaskCompletionEvent[len];
        for (int i = 0; i < offset + len; ++i) {
            TaskCompletionEvent event = new TaskCompletionEvent();
            event.readFields(dataIn);
            if (i < offset) continue;
            events[i - offset] = event;
        }
        return events;
    }

    public JobStatus readJobStatus(JobID jobId) {
        JobStatus jobStatus = null;
        if (null == jobId) {
            LOG.warn("Could not read job status for null jobId");
            return null;
        }
        if (this.active) {
            try {
                FSDataInputStream dataIn = this.getJobInfoFile(jobId);
                if (dataIn != null) {
                    jobStatus = this.readJobStatus(dataIn);
                    dataIn.close();
                }
            }
            catch (IOException ex) {
                LOG.warn("Could not read [" + jobId + "] job status : " + ex, ex);
            }
        }
        return jobStatus;
    }

    public JobProfile readJobProfile(JobID jobId) {
        JobProfile jobProfile = null;
        if (this.active) {
            try {
                FSDataInputStream dataIn = this.getJobInfoFile(jobId);
                if (dataIn != null) {
                    this.readJobStatus(dataIn);
                    jobProfile = this.readJobProfile(dataIn);
                    dataIn.close();
                }
            }
            catch (IOException ex) {
                LOG.warn("Could not read [" + jobId + "] job profile : " + ex, ex);
            }
        }
        return jobProfile;
    }

    public Counters readCounters(JobID jobId) {
        Counters counters = null;
        if (this.active) {
            try {
                FSDataInputStream dataIn = this.getJobInfoFile(jobId);
                if (dataIn != null) {
                    this.readJobStatus(dataIn);
                    this.readJobProfile(dataIn);
                    counters = this.readCounters(dataIn);
                    dataIn.close();
                }
            }
            catch (IOException ex) {
                LOG.warn("Could not read [" + jobId + "] job counters : " + ex, ex);
            }
        }
        return counters;
    }

    public TaskCompletionEvent[] readJobTaskCompletionEvents(JobID jobId, int fromEventId, int maxEvents) {
        TaskCompletionEvent[] events = TaskCompletionEvent.EMPTY_ARRAY;
        if (this.active) {
            try {
                FSDataInputStream dataIn = this.getJobInfoFile(jobId);
                if (dataIn != null) {
                    this.readJobStatus(dataIn);
                    this.readJobProfile(dataIn);
                    this.readCounters(dataIn);
                    events = this.readEvents(dataIn, fromEventId, maxEvents);
                    dataIn.close();
                }
            }
            catch (IOException ex) {
                LOG.warn("Could not read [" + jobId + "] job events : " + ex, ex);
            }
        }
        return events;
    }
}

