/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.$internal.org.apache.hadoop.mapred;

import com.facebook.presto.hive.$internal.org.apache.hadoop.io.OutputBuffer;
import com.facebook.presto.hive.$internal.org.apache.hadoop.io.RawComparator;
import com.facebook.presto.hive.$internal.org.apache.hadoop.io.SequenceFile;
import com.facebook.presto.hive.$internal.org.apache.hadoop.mapred.BufferSorter;
import com.facebook.presto.hive.$internal.org.apache.hadoop.mapred.JobConf;
import com.facebook.presto.hive.$internal.org.apache.hadoop.util.Progressable;

abstract class BasicTypeSorterBase
implements BufferSorter {
    protected OutputBuffer keyValBuffer;
    protected int[] startOffsets;
    protected int[] keyLengths;
    protected int[] valueLengths;
    protected int[] pointers;
    protected RawComparator comparator;
    protected int count;
    private static final int BUFFERED_KEY_VAL_OVERHEAD = 16;
    private static final int INITIAL_ARRAY_SIZE = 5;
    private int maxKeyLength = 0;
    private int maxValLength = 0;
    protected Progressable reporter;

    BasicTypeSorterBase() {
    }

    @Override
    public void configure(JobConf conf) {
        this.comparator = conf.getOutputKeyComparator();
    }

    @Override
    public void setProgressable(Progressable reporter) {
        this.reporter = reporter;
    }

    @Override
    public void addKeyValue(int recordOffset, int keyLength, int valLength) {
        if (this.startOffsets == null || this.count == this.startOffsets.length) {
            this.grow();
        }
        this.startOffsets[this.count] = recordOffset;
        this.keyLengths[this.count] = keyLength;
        if (keyLength > this.maxKeyLength) {
            this.maxKeyLength = keyLength;
        }
        if (valLength > this.maxValLength) {
            this.maxValLength = valLength;
        }
        this.valueLengths[this.count] = valLength;
        this.pointers[this.count] = this.count;
        ++this.count;
    }

    @Override
    public void setInputBuffer(OutputBuffer buffer) {
        this.keyValBuffer = buffer;
    }

    @Override
    public long getMemoryUtilized() {
        if (this.startOffsets != null) {
            return this.startOffsets.length * 16 + this.maxKeyLength + this.maxValLength;
        }
        return 0L;
    }

    @Override
    public abstract SequenceFile.Sorter.RawKeyValueIterator sort();

    @Override
    public void close() {
        this.count = 0;
        this.startOffsets = null;
        this.keyLengths = null;
        this.valueLengths = null;
        this.pointers = null;
        this.maxKeyLength = 0;
        this.maxValLength = 0;
        this.keyValBuffer = null;
    }

    private void grow() {
        int currLength = 0;
        if (this.startOffsets != null) {
            currLength = this.startOffsets.length;
        }
        int newLength = (int)((double)currLength * 1.1) + 1;
        this.startOffsets = this.grow(this.startOffsets, newLength);
        this.keyLengths = this.grow(this.keyLengths, newLength);
        this.valueLengths = this.grow(this.valueLengths, newLength);
        this.pointers = this.grow(this.pointers, newLength);
    }

    private int[] grow(int[] old, int newLength) {
        int[] result = new int[newLength];
        if (old != null) {
            System.arraycopy(old, 0, result, 0, old.length);
        }
        return result;
    }
}

