/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.$internal.org.apache.hadoop.ipc.metrics;

import com.facebook.presto.hive.$internal.org.apache.commons.logging.Log;
import com.facebook.presto.hive.$internal.org.apache.commons.logging.LogFactory;
import com.facebook.presto.hive.$internal.org.apache.hadoop.ipc.Server;
import com.facebook.presto.hive.$internal.org.apache.hadoop.ipc.metrics.RpcActivityMBean;
import com.facebook.presto.hive.$internal.org.apache.hadoop.metrics.MetricsContext;
import com.facebook.presto.hive.$internal.org.apache.hadoop.metrics.MetricsRecord;
import com.facebook.presto.hive.$internal.org.apache.hadoop.metrics.MetricsUtil;
import com.facebook.presto.hive.$internal.org.apache.hadoop.metrics.Updater;
import com.facebook.presto.hive.$internal.org.apache.hadoop.metrics.util.MetricsBase;
import com.facebook.presto.hive.$internal.org.apache.hadoop.metrics.util.MetricsIntValue;
import com.facebook.presto.hive.$internal.org.apache.hadoop.metrics.util.MetricsRegistry;
import com.facebook.presto.hive.$internal.org.apache.hadoop.metrics.util.MetricsTimeVaryingRate;

public class RpcMetrics
implements Updater {
    public MetricsRegistry registry = new MetricsRegistry();
    private MetricsRecord metricsRecord;
    private Server myServer;
    private static Log LOG = LogFactory.getLog(RpcMetrics.class);
    RpcActivityMBean rpcMBean;
    public MetricsTimeVaryingRate rpcQueueTime = new MetricsTimeVaryingRate("RpcQueueTime", this.registry);
    public MetricsTimeVaryingRate rpcProcessingTime = new MetricsTimeVaryingRate("RpcProcessingTime", this.registry);
    public MetricsIntValue numOpenConnections = new MetricsIntValue("NumOpenConnections", this.registry);
    public MetricsIntValue callQueueLen = new MetricsIntValue("callQueueLen", this.registry);

    public RpcMetrics(String hostName, String port, Server server) {
        this.myServer = server;
        MetricsContext context = MetricsUtil.getContext("rpc");
        this.metricsRecord = MetricsUtil.createRecord(context, "metrics");
        this.metricsRecord.setTag("port", port);
        LOG.info("Initializing RPC Metrics with hostName=" + hostName + ", port=" + port);
        context.registerUpdater(this);
        this.rpcMBean = new RpcActivityMBean(this.registry, hostName, port);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doUpdates(MetricsContext context) {
        RpcMetrics rpcMetrics = this;
        synchronized (rpcMetrics) {
            this.numOpenConnections.set(this.myServer.getNumOpenConnections());
            this.callQueueLen.set(this.myServer.getCallQueueLen());
            for (MetricsBase m : this.registry.getMetricsList()) {
                m.pushMetric(this.metricsRecord);
            }
        }
        this.metricsRecord.update();
    }

    public void shutdown() {
        if (this.rpcMBean != null) {
            this.rpcMBean.shutdown();
        }
    }
}

