/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.$internal.org.apache.hadoop.io.retry;

import com.facebook.presto.hive.$internal.org.apache.commons.logging.Log;
import com.facebook.presto.hive.$internal.org.apache.commons.logging.LogFactory;
import com.facebook.presto.hive.$internal.org.apache.hadoop.io.retry.RetryPolicies;
import com.facebook.presto.hive.$internal.org.apache.hadoop.io.retry.RetryPolicy;
import com.facebook.presto.hive.$internal.org.apache.hadoop.util.StringUtils;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Map;

class RetryInvocationHandler
implements InvocationHandler {
    public static final Log LOG = LogFactory.getLog(RetryInvocationHandler.class);
    private Object implementation;
    private RetryPolicy defaultPolicy;
    private Map<String, RetryPolicy> methodNameToPolicyMap;

    public RetryInvocationHandler(Object implementation, RetryPolicy retryPolicy) {
        this.implementation = implementation;
        this.defaultPolicy = retryPolicy;
        this.methodNameToPolicyMap = Collections.emptyMap();
    }

    public RetryInvocationHandler(Object implementation, Map<String, RetryPolicy> methodNameToPolicyMap) {
        this.implementation = implementation;
        this.defaultPolicy = RetryPolicies.TRY_ONCE_THEN_FAIL;
        this.methodNameToPolicyMap = methodNameToPolicyMap;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        RetryPolicy policy = this.methodNameToPolicyMap.get(method.getName());
        if (policy == null) {
            policy = this.defaultPolicy;
        }
        int retries = 0;
        while (true) {
            try {
                return this.invokeMethod(method, args);
            }
            catch (Exception e) {
                if (!policy.shouldRetry(e, retries++)) {
                    LOG.info("Exception while invoking " + method.getName() + " of " + this.implementation.getClass() + ". Not retrying." + StringUtils.stringifyException(e));
                    if (!method.getReturnType().equals(Void.TYPE)) {
                        throw e;
                    }
                    return null;
                }
                LOG.debug("Exception while invoking " + method.getName() + " of " + this.implementation.getClass() + ". Retrying." + StringUtils.stringifyException(e));
                continue;
            }
            break;
        }
    }

    private Object invokeMethod(Method method, Object[] args) throws Throwable {
        try {
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
            return method.invoke(this.implementation, args);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }
}

