/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.$internal.org.apache.hadoop.io;

import com.facebook.presto.hive.$internal.org.apache.hadoop.conf.Configurable;
import com.facebook.presto.hive.$internal.org.apache.hadoop.conf.Configuration;
import com.facebook.presto.hive.$internal.org.apache.hadoop.io.Writable;
import com.facebook.presto.hive.$internal.org.apache.hadoop.io.WritableFactory;
import com.facebook.presto.hive.$internal.org.apache.hadoop.util.ReflectionUtils;
import java.util.HashMap;

public class WritableFactories {
    private static final HashMap<Class, WritableFactory> CLASS_TO_FACTORY = new HashMap();

    private WritableFactories() {
    }

    public static synchronized void setFactory(Class c, WritableFactory factory) {
        CLASS_TO_FACTORY.put(c, factory);
    }

    public static synchronized WritableFactory getFactory(Class c) {
        return CLASS_TO_FACTORY.get(c);
    }

    public static Writable newInstance(Class<? extends Writable> c, Configuration conf) {
        WritableFactory factory = WritableFactories.getFactory(c);
        if (factory != null) {
            Writable result = factory.newInstance();
            if (result instanceof Configurable) {
                ((Configurable)((Object)result)).setConf(conf);
            }
            return result;
        }
        return ReflectionUtils.newInstance(c, conf);
    }

    public static Writable newInstance(Class<? extends Writable> c) {
        return WritableFactories.newInstance(c, null);
    }
}

