/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.$internal.org.apache.hadoop.io;

import com.facebook.presto.hive.;
import com.facebook.presto.hive.$internal.org.apache.hadoop.conf.Configuration;
import com.facebook.presto.hive.$internal.org.apache.hadoop.io.DataInputBuffer;
import com.facebook.presto.hive.$internal.org.apache.hadoop.io.DataOutputBuffer;
import com.facebook.presto.hive.$internal.org.apache.hadoop.io.Stringifier;
import com.facebook.presto.hive.$internal.org.apache.hadoop.io.serializer.Deserializer;
import com.facebook.presto.hive.$internal.org.apache.hadoop.io.serializer.SerializationFactory;
import com.facebook.presto.hive.$internal.org.apache.hadoop.io.serializer.Serializer;
import com.facebook.presto.hive.$internal.org.apache.hadoop.util.GenericsUtil;
import java.io.IOException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;

public class DefaultStringifier<T>
implements Stringifier<T> {
    private static final String SEPARATOR = ",";
    private Serializer<T> serializer;
    private Deserializer<T> deserializer;
    private DataInputBuffer inBuf;
    private DataOutputBuffer outBuf;

    public DefaultStringifier(Configuration conf, Class<T> c) {
        SerializationFactory factory = new SerializationFactory(conf);
        this.serializer = factory.getSerializer(c);
        this.deserializer = factory.getDeserializer(c);
        this.inBuf = new DataInputBuffer();
        this.outBuf = new DataOutputBuffer();
        try {
            this.serializer.open(this.outBuf);
            this.deserializer.open(this.inBuf);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public T fromString(String str) throws IOException {
        try {
            byte[] bytes = .Base64.decodeBase64((byte[])str.getBytes("UTF-8"));
            this.inBuf.reset(bytes, bytes.length);
            T restored = this.deserializer.deserialize(null);
            return restored;
        }
        catch (UnsupportedCharsetException ex) {
            throw new IOException(ex.toString());
        }
    }

    @Override
    public String toString(T obj) throws IOException {
        this.outBuf.reset();
        this.serializer.serialize(obj);
        byte[] buf = new byte[this.outBuf.getLength()];
        System.arraycopy(this.outBuf.getData(), 0, buf, 0, buf.length);
        return new String(.Base64.encodeBase64((byte[])buf));
    }

    @Override
    public void close() throws IOException {
        this.inBuf.close();
        this.outBuf.close();
        this.deserializer.close();
        this.serializer.close();
    }

    public static <K> void store(Configuration conf, K item, String keyName) throws IOException {
        DefaultStringifier<K> stringifier = new DefaultStringifier<K>(conf, GenericsUtil.getClass(item));
        conf.set(keyName, stringifier.toString(item));
        stringifier.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <K> K load(Configuration conf, String keyName, Class<K> itemClass) throws IOException {
        DefaultStringifier<K> stringifier = new DefaultStringifier<K>(conf, itemClass);
        try {
            String itemStr = conf.get(keyName);
            K k = stringifier.fromString(itemStr);
            return k;
        }
        finally {
            stringifier.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <K> void storeArray(Configuration conf, K[] items, String keyName) throws IOException {
        DefaultStringifier<K> stringifier = new DefaultStringifier<K>(conf, GenericsUtil.getClass(items[0]));
        try {
            StringBuilder builder = new StringBuilder();
            for (K item : items) {
                builder.append(stringifier.toString(item)).append(SEPARATOR);
            }
            conf.set(keyName, builder.toString());
        }
        finally {
            stringifier.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <K> K[] loadArray(Configuration conf, String keyName, Class<K> itemClass) throws IOException {
        DefaultStringifier<K> stringifier = new DefaultStringifier<K>(conf, itemClass);
        try {
            String[] parts;
            String itemStr = conf.get(keyName);
            ArrayList<K> list = new ArrayList<K>();
            for (String part : parts = itemStr.split(SEPARATOR)) {
                if (part.equals("")) continue;
                list.add(stringifier.fromString(part));
            }
            K[] KArray = GenericsUtil.toArray(itemClass, list);
            return KArray;
        }
        finally {
            stringifier.close();
        }
    }
}

